# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 10
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from isilon_sdk.v9_0_0.models.performance_dataset import PerformanceDataset  # noqa: F401,E501


class PerformanceDatasetCreateParams(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'filters': 'list[str]',
        'metrics': 'list[str]'
    }

    attribute_map = {
        'name': 'name',
        'filters': 'filters',
        'metrics': 'metrics'
    }

    def __init__(self, name=None, filters=None, metrics=None):  # noqa: E501
        """PerformanceDatasetCreateParams - a model defined in Swagger"""  # noqa: E501

        self._name = None
        self._filters = None
        self._metrics = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if filters is not None:
            self.filters = filters
        self.metrics = metrics

    @property
    def name(self):
        """Gets the name of this PerformanceDatasetCreateParams.  # noqa: E501

        The name of the performance dataset. If a name is not specified then a default name is assigned. The default name will be an underscore separated list of the performance metrics and filters used to configure the dataset.  # noqa: E501

        :return: The name of this PerformanceDatasetCreateParams.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this PerformanceDatasetCreateParams.

        The name of the performance dataset. If a name is not specified then a default name is assigned. The default name will be an underscore separated list of the performance metrics and filters used to configure the dataset.  # noqa: E501

        :param name: The name of this PerformanceDatasetCreateParams.  # noqa: E501
        :type: str
        """
        if name is not None and len(name) > 255:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `255`")  # noqa: E501
        if name is not None and len(name) < 1:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def filters(self):
        """Gets the filters of this PerformanceDatasetCreateParams.  # noqa: E501

        Filtered metrics for configuring this dataset.  # noqa: E501

        :return: The filters of this PerformanceDatasetCreateParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._filters

    @filters.setter
    def filters(self, filters):
        """Sets the filters of this PerformanceDatasetCreateParams.

        Filtered metrics for configuring this dataset.  # noqa: E501

        :param filters: The filters of this PerformanceDatasetCreateParams.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["groupname", "local_address", "path", "protocol", "remote_address", "share_name", "username", "zone_name", "export_id"]  # noqa: E501
        if not set(filters).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `filters` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(filters) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._filters = filters

    @property
    def metrics(self):
        """Gets the metrics of this PerformanceDatasetCreateParams.  # noqa: E501

        Performance metrics defining the dataset.  # noqa: E501

        :return: The metrics of this PerformanceDatasetCreateParams.  # noqa: E501
        :rtype: list[str]
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics):
        """Sets the metrics of this PerformanceDatasetCreateParams.

        Performance metrics defining the dataset.  # noqa: E501

        :param metrics: The metrics of this PerformanceDatasetCreateParams.  # noqa: E501
        :type: list[str]
        """
        if metrics is None:
            raise ValueError("Invalid value for `metrics`, must not be `None`")  # noqa: E501
        allowed_values = ["groupname", "local_address", "path", "protocol", "remote_address", "share_name", "username", "zone_name", "export_id"]  # noqa: E501
        if not set(metrics).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `metrics` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(metrics) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._metrics = metrics

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PerformanceDatasetCreateParams):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
