# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 10
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isilon_sdk.v9_0_0.api_client import ApiClient


class NetworkGroupnetsSubnetsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_pools_pool_rebalance_ip(self, pools_pool_rebalance_ip, groupnet, subnet, pool, **kwargs):  # noqa: E501
        """create_pools_pool_rebalance_ip  # noqa: E501

        Rebalance IP addresses in specified pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_pools_pool_rebalance_ip(pools_pool_rebalance_ip, groupnet, subnet, pool, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty pools_pool_rebalance_ip: (required)
        :param str groupnet: (required)
        :param str subnet: (required)
        :param str pool: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_pools_pool_rebalance_ip_with_http_info(pools_pool_rebalance_ip, groupnet, subnet, pool, **kwargs)  # noqa: E501
        else:
            (data) = self.create_pools_pool_rebalance_ip_with_http_info(pools_pool_rebalance_ip, groupnet, subnet, pool, **kwargs)  # noqa: E501
            return data

    def create_pools_pool_rebalance_ip_with_http_info(self, pools_pool_rebalance_ip, groupnet, subnet, pool, **kwargs):  # noqa: E501
        """create_pools_pool_rebalance_ip  # noqa: E501

        Rebalance IP addresses in specified pool.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_pools_pool_rebalance_ip_with_http_info(pools_pool_rebalance_ip, groupnet, subnet, pool, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Empty pools_pool_rebalance_ip: (required)
        :param str groupnet: (required)
        :param str subnet: (required)
        :param str pool: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pools_pool_rebalance_ip', 'groupnet', 'subnet', 'pool']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_pools_pool_rebalance_ip" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pools_pool_rebalance_ip' is set
        if ('pools_pool_rebalance_ip' not in params or
                params['pools_pool_rebalance_ip'] is None):
            raise ValueError("Missing the required parameter `pools_pool_rebalance_ip` when calling `create_pools_pool_rebalance_ip`")  # noqa: E501
        # verify the required parameter 'groupnet' is set
        if ('groupnet' not in params or
                params['groupnet'] is None):
            raise ValueError("Missing the required parameter `groupnet` when calling `create_pools_pool_rebalance_ip`")  # noqa: E501
        # verify the required parameter 'subnet' is set
        if ('subnet' not in params or
                params['subnet'] is None):
            raise ValueError("Missing the required parameter `subnet` when calling `create_pools_pool_rebalance_ip`")  # noqa: E501
        # verify the required parameter 'pool' is set
        if ('pool' not in params or
                params['pool'] is None):
            raise ValueError("Missing the required parameter `pool` when calling `create_pools_pool_rebalance_ip`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'groupnet' in params:
            path_params['Groupnet'] = params['groupnet']  # noqa: E501
        if 'subnet' in params:
            path_params['Subnet'] = params['subnet']  # noqa: E501
        if 'pool' in params:
            path_params['Pool'] = params['pool']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'pools_pool_rebalance_ip' in params:
            body_params = params['pools_pool_rebalance_ip']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{Pool}/rebalance-ips', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_pools_pool_rule(self, pools_pool_rule, groupnet, subnet, pool, **kwargs):  # noqa: E501
        """create_pools_pool_rule  # noqa: E501

        Create a new rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_pools_pool_rule(pools_pool_rule, groupnet, subnet, pool, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PoolsPoolRuleCreateParams pools_pool_rule: (required)
        :param str groupnet: (required)
        :param str subnet: (required)
        :param str pool: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_pools_pool_rule_with_http_info(pools_pool_rule, groupnet, subnet, pool, **kwargs)  # noqa: E501
        else:
            (data) = self.create_pools_pool_rule_with_http_info(pools_pool_rule, groupnet, subnet, pool, **kwargs)  # noqa: E501
            return data

    def create_pools_pool_rule_with_http_info(self, pools_pool_rule, groupnet, subnet, pool, **kwargs):  # noqa: E501
        """create_pools_pool_rule  # noqa: E501

        Create a new rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_pools_pool_rule_with_http_info(pools_pool_rule, groupnet, subnet, pool, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PoolsPoolRuleCreateParams pools_pool_rule: (required)
        :param str groupnet: (required)
        :param str subnet: (required)
        :param str pool: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pools_pool_rule', 'groupnet', 'subnet', 'pool']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_pools_pool_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pools_pool_rule' is set
        if ('pools_pool_rule' not in params or
                params['pools_pool_rule'] is None):
            raise ValueError("Missing the required parameter `pools_pool_rule` when calling `create_pools_pool_rule`")  # noqa: E501
        # verify the required parameter 'groupnet' is set
        if ('groupnet' not in params or
                params['groupnet'] is None):
            raise ValueError("Missing the required parameter `groupnet` when calling `create_pools_pool_rule`")  # noqa: E501
        # verify the required parameter 'subnet' is set
        if ('subnet' not in params or
                params['subnet'] is None):
            raise ValueError("Missing the required parameter `subnet` when calling `create_pools_pool_rule`")  # noqa: E501
        # verify the required parameter 'pool' is set
        if ('pool' not in params or
                params['pool'] is None):
            raise ValueError("Missing the required parameter `pool` when calling `create_pools_pool_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'groupnet' in params:
            path_params['Groupnet'] = params['groupnet']  # noqa: E501
        if 'subnet' in params:
            path_params['Subnet'] = params['subnet']  # noqa: E501
        if 'pool' in params:
            path_params['Pool'] = params['pool']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'pools_pool_rule' in params:
            body_params = params['pools_pool_rule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{Pool}/rules', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_pools_pool_sc_resume_node(self, pools_pool_sc_resume_node, groupnet, subnet, pool, **kwargs):  # noqa: E501
        """create_pools_pool_sc_resume_node  # noqa: E501

        Resume suspended nodes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_pools_pool_sc_resume_node(pools_pool_sc_resume_node, groupnet, subnet, pool, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PoolsPoolScResumeNode pools_pool_sc_resume_node: (required)
        :param str groupnet: (required)
        :param str subnet: (required)
        :param str pool: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_pools_pool_sc_resume_node_with_http_info(pools_pool_sc_resume_node, groupnet, subnet, pool, **kwargs)  # noqa: E501
        else:
            (data) = self.create_pools_pool_sc_resume_node_with_http_info(pools_pool_sc_resume_node, groupnet, subnet, pool, **kwargs)  # noqa: E501
            return data

    def create_pools_pool_sc_resume_node_with_http_info(self, pools_pool_sc_resume_node, groupnet, subnet, pool, **kwargs):  # noqa: E501
        """create_pools_pool_sc_resume_node  # noqa: E501

        Resume suspended nodes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_pools_pool_sc_resume_node_with_http_info(pools_pool_sc_resume_node, groupnet, subnet, pool, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PoolsPoolScResumeNode pools_pool_sc_resume_node: (required)
        :param str groupnet: (required)
        :param str subnet: (required)
        :param str pool: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pools_pool_sc_resume_node', 'groupnet', 'subnet', 'pool']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_pools_pool_sc_resume_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pools_pool_sc_resume_node' is set
        if ('pools_pool_sc_resume_node' not in params or
                params['pools_pool_sc_resume_node'] is None):
            raise ValueError("Missing the required parameter `pools_pool_sc_resume_node` when calling `create_pools_pool_sc_resume_node`")  # noqa: E501
        # verify the required parameter 'groupnet' is set
        if ('groupnet' not in params or
                params['groupnet'] is None):
            raise ValueError("Missing the required parameter `groupnet` when calling `create_pools_pool_sc_resume_node`")  # noqa: E501
        # verify the required parameter 'subnet' is set
        if ('subnet' not in params or
                params['subnet'] is None):
            raise ValueError("Missing the required parameter `subnet` when calling `create_pools_pool_sc_resume_node`")  # noqa: E501
        # verify the required parameter 'pool' is set
        if ('pool' not in params or
                params['pool'] is None):
            raise ValueError("Missing the required parameter `pool` when calling `create_pools_pool_sc_resume_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'groupnet' in params:
            path_params['Groupnet'] = params['groupnet']  # noqa: E501
        if 'subnet' in params:
            path_params['Subnet'] = params['subnet']  # noqa: E501
        if 'pool' in params:
            path_params['Pool'] = params['pool']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'pools_pool_sc_resume_node' in params:
            body_params = params['pools_pool_sc_resume_node']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{Pool}/sc-resume-nodes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_pools_pool_sc_suspend_node(self, pools_pool_sc_suspend_node, groupnet, subnet, pool, **kwargs):  # noqa: E501
        """create_pools_pool_sc_suspend_node  # noqa: E501

        Suspend nodes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_pools_pool_sc_suspend_node(pools_pool_sc_suspend_node, groupnet, subnet, pool, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PoolsPoolScResumeNode pools_pool_sc_suspend_node: (required)
        :param str groupnet: (required)
        :param str subnet: (required)
        :param str pool: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_pools_pool_sc_suspend_node_with_http_info(pools_pool_sc_suspend_node, groupnet, subnet, pool, **kwargs)  # noqa: E501
        else:
            (data) = self.create_pools_pool_sc_suspend_node_with_http_info(pools_pool_sc_suspend_node, groupnet, subnet, pool, **kwargs)  # noqa: E501
            return data

    def create_pools_pool_sc_suspend_node_with_http_info(self, pools_pool_sc_suspend_node, groupnet, subnet, pool, **kwargs):  # noqa: E501
        """create_pools_pool_sc_suspend_node  # noqa: E501

        Suspend nodes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_pools_pool_sc_suspend_node_with_http_info(pools_pool_sc_suspend_node, groupnet, subnet, pool, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PoolsPoolScResumeNode pools_pool_sc_suspend_node: (required)
        :param str groupnet: (required)
        :param str subnet: (required)
        :param str pool: (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pools_pool_sc_suspend_node', 'groupnet', 'subnet', 'pool']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_pools_pool_sc_suspend_node" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pools_pool_sc_suspend_node' is set
        if ('pools_pool_sc_suspend_node' not in params or
                params['pools_pool_sc_suspend_node'] is None):
            raise ValueError("Missing the required parameter `pools_pool_sc_suspend_node` when calling `create_pools_pool_sc_suspend_node`")  # noqa: E501
        # verify the required parameter 'groupnet' is set
        if ('groupnet' not in params or
                params['groupnet'] is None):
            raise ValueError("Missing the required parameter `groupnet` when calling `create_pools_pool_sc_suspend_node`")  # noqa: E501
        # verify the required parameter 'subnet' is set
        if ('subnet' not in params or
                params['subnet'] is None):
            raise ValueError("Missing the required parameter `subnet` when calling `create_pools_pool_sc_suspend_node`")  # noqa: E501
        # verify the required parameter 'pool' is set
        if ('pool' not in params or
                params['pool'] is None):
            raise ValueError("Missing the required parameter `pool` when calling `create_pools_pool_sc_suspend_node`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'groupnet' in params:
            path_params['Groupnet'] = params['groupnet']  # noqa: E501
        if 'subnet' in params:
            path_params['Subnet'] = params['subnet']  # noqa: E501
        if 'pool' in params:
            path_params['Pool'] = params['pool']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'pools_pool_sc_suspend_node' in params:
            body_params = params['pools_pool_sc_suspend_node']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{Pool}/sc-suspend-nodes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Empty',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_pools_pool_rule(self, pools_pool_rule_id, groupnet, subnet, pool, **kwargs):  # noqa: E501
        """delete_pools_pool_rule  # noqa: E501

        Delete a network rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_pools_pool_rule(pools_pool_rule_id, groupnet, subnet, pool, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pools_pool_rule_id: Delete a network rule. (required)
        :param str groupnet: (required)
        :param str subnet: (required)
        :param str pool: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_pools_pool_rule_with_http_info(pools_pool_rule_id, groupnet, subnet, pool, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_pools_pool_rule_with_http_info(pools_pool_rule_id, groupnet, subnet, pool, **kwargs)  # noqa: E501
            return data

    def delete_pools_pool_rule_with_http_info(self, pools_pool_rule_id, groupnet, subnet, pool, **kwargs):  # noqa: E501
        """delete_pools_pool_rule  # noqa: E501

        Delete a network rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_pools_pool_rule_with_http_info(pools_pool_rule_id, groupnet, subnet, pool, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pools_pool_rule_id: Delete a network rule. (required)
        :param str groupnet: (required)
        :param str subnet: (required)
        :param str pool: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pools_pool_rule_id', 'groupnet', 'subnet', 'pool']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_pools_pool_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pools_pool_rule_id' is set
        if ('pools_pool_rule_id' not in params or
                params['pools_pool_rule_id'] is None):
            raise ValueError("Missing the required parameter `pools_pool_rule_id` when calling `delete_pools_pool_rule`")  # noqa: E501
        # verify the required parameter 'groupnet' is set
        if ('groupnet' not in params or
                params['groupnet'] is None):
            raise ValueError("Missing the required parameter `groupnet` when calling `delete_pools_pool_rule`")  # noqa: E501
        # verify the required parameter 'subnet' is set
        if ('subnet' not in params or
                params['subnet'] is None):
            raise ValueError("Missing the required parameter `subnet` when calling `delete_pools_pool_rule`")  # noqa: E501
        # verify the required parameter 'pool' is set
        if ('pool' not in params or
                params['pool'] is None):
            raise ValueError("Missing the required parameter `pool` when calling `delete_pools_pool_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pools_pool_rule_id' in params:
            path_params['PoolsPoolRuleId'] = params['pools_pool_rule_id']  # noqa: E501
        if 'groupnet' in params:
            path_params['Groupnet'] = params['groupnet']  # noqa: E501
        if 'subnet' in params:
            path_params['Subnet'] = params['subnet']  # noqa: E501
        if 'pool' in params:
            path_params['Pool'] = params['pool']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{Pool}/rules/{PoolsPoolRuleId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_pools_pool_interfaces(self, groupnet, subnet, pool, **kwargs):  # noqa: E501
        """get_pools_pool_interfaces  # noqa: E501

        Get a list of interfaces.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pools_pool_interfaces(groupnet, subnet, pool, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str groupnet: (required)
        :param str subnet: (required)
        :param str pool: (required)
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str lnns: Get a list of interfaces for the specified lnn.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: PoolsPoolInterfaces
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_pools_pool_interfaces_with_http_info(groupnet, subnet, pool, **kwargs)  # noqa: E501
        else:
            (data) = self.get_pools_pool_interfaces_with_http_info(groupnet, subnet, pool, **kwargs)  # noqa: E501
            return data

    def get_pools_pool_interfaces_with_http_info(self, groupnet, subnet, pool, **kwargs):  # noqa: E501
        """get_pools_pool_interfaces  # noqa: E501

        Get a list of interfaces.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pools_pool_interfaces_with_http_info(groupnet, subnet, pool, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str groupnet: (required)
        :param str subnet: (required)
        :param str pool: (required)
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str lnns: Get a list of interfaces for the specified lnn.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: PoolsPoolInterfaces
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['groupnet', 'subnet', 'pool', 'dir', 'limit', 'lnns', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pools_pool_interfaces" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'groupnet' is set
        if ('groupnet' not in params or
                params['groupnet'] is None):
            raise ValueError("Missing the required parameter `groupnet` when calling `get_pools_pool_interfaces`")  # noqa: E501
        # verify the required parameter 'subnet' is set
        if ('subnet' not in params or
                params['subnet'] is None):
            raise ValueError("Missing the required parameter `subnet` when calling `get_pools_pool_interfaces`")  # noqa: E501
        # verify the required parameter 'pool' is set
        if ('pool' not in params or
                params['pool'] is None):
            raise ValueError("Missing the required parameter `pool` when calling `get_pools_pool_interfaces`")  # noqa: E501

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_pools_pool_interfaces`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_pools_pool_interfaces`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_pools_pool_interfaces`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_pools_pool_interfaces`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_pools_pool_interfaces`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_pools_pool_interfaces`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_pools_pool_interfaces`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'groupnet' in params:
            path_params['Groupnet'] = params['groupnet']  # noqa: E501
        if 'subnet' in params:
            path_params['Subnet'] = params['subnet']  # noqa: E501
        if 'pool' in params:
            path_params['Pool'] = params['pool']  # noqa: E501

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'lnns' in params:
            query_params.append(('lnns', params['lnns']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{Pool}/interfaces', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PoolsPoolInterfaces',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_pools_pool_rule(self, pools_pool_rule_id, groupnet, subnet, pool, **kwargs):  # noqa: E501
        """get_pools_pool_rule  # noqa: E501

        View a single network rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pools_pool_rule(pools_pool_rule_id, groupnet, subnet, pool, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pools_pool_rule_id: View a single network rule. (required)
        :param str groupnet: (required)
        :param str subnet: (required)
        :param str pool: (required)
        :return: PoolsPoolRules
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_pools_pool_rule_with_http_info(pools_pool_rule_id, groupnet, subnet, pool, **kwargs)  # noqa: E501
        else:
            (data) = self.get_pools_pool_rule_with_http_info(pools_pool_rule_id, groupnet, subnet, pool, **kwargs)  # noqa: E501
            return data

    def get_pools_pool_rule_with_http_info(self, pools_pool_rule_id, groupnet, subnet, pool, **kwargs):  # noqa: E501
        """get_pools_pool_rule  # noqa: E501

        View a single network rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_pools_pool_rule_with_http_info(pools_pool_rule_id, groupnet, subnet, pool, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str pools_pool_rule_id: View a single network rule. (required)
        :param str groupnet: (required)
        :param str subnet: (required)
        :param str pool: (required)
        :return: PoolsPoolRules
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pools_pool_rule_id', 'groupnet', 'subnet', 'pool']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_pools_pool_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pools_pool_rule_id' is set
        if ('pools_pool_rule_id' not in params or
                params['pools_pool_rule_id'] is None):
            raise ValueError("Missing the required parameter `pools_pool_rule_id` when calling `get_pools_pool_rule`")  # noqa: E501
        # verify the required parameter 'groupnet' is set
        if ('groupnet' not in params or
                params['groupnet'] is None):
            raise ValueError("Missing the required parameter `groupnet` when calling `get_pools_pool_rule`")  # noqa: E501
        # verify the required parameter 'subnet' is set
        if ('subnet' not in params or
                params['subnet'] is None):
            raise ValueError("Missing the required parameter `subnet` when calling `get_pools_pool_rule`")  # noqa: E501
        # verify the required parameter 'pool' is set
        if ('pool' not in params or
                params['pool'] is None):
            raise ValueError("Missing the required parameter `pool` when calling `get_pools_pool_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pools_pool_rule_id' in params:
            path_params['PoolsPoolRuleId'] = params['pools_pool_rule_id']  # noqa: E501
        if 'groupnet' in params:
            path_params['Groupnet'] = params['groupnet']  # noqa: E501
        if 'subnet' in params:
            path_params['Subnet'] = params['subnet']  # noqa: E501
        if 'pool' in params:
            path_params['Pool'] = params['pool']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{Pool}/rules/{PoolsPoolRuleId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PoolsPoolRules',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_pools_pool_rules(self, groupnet, subnet, pool, **kwargs):  # noqa: E501
        """list_pools_pool_rules  # noqa: E501

        Get a list of network rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_pools_pool_rules(groupnet, subnet, pool, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str groupnet: (required)
        :param str subnet: (required)
        :param str pool: (required)
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: PoolsPoolRulesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_pools_pool_rules_with_http_info(groupnet, subnet, pool, **kwargs)  # noqa: E501
        else:
            (data) = self.list_pools_pool_rules_with_http_info(groupnet, subnet, pool, **kwargs)  # noqa: E501
            return data

    def list_pools_pool_rules_with_http_info(self, groupnet, subnet, pool, **kwargs):  # noqa: E501
        """list_pools_pool_rules  # noqa: E501

        Get a list of network rules.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_pools_pool_rules_with_http_info(groupnet, subnet, pool, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str groupnet: (required)
        :param str subnet: (required)
        :param str pool: (required)
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: PoolsPoolRulesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['groupnet', 'subnet', 'pool', 'dir', 'limit', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_pools_pool_rules" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'groupnet' is set
        if ('groupnet' not in params or
                params['groupnet'] is None):
            raise ValueError("Missing the required parameter `groupnet` when calling `list_pools_pool_rules`")  # noqa: E501
        # verify the required parameter 'subnet' is set
        if ('subnet' not in params or
                params['subnet'] is None):
            raise ValueError("Missing the required parameter `subnet` when calling `list_pools_pool_rules`")  # noqa: E501
        # verify the required parameter 'pool' is set
        if ('pool' not in params or
                params['pool'] is None):
            raise ValueError("Missing the required parameter `pool` when calling `list_pools_pool_rules`")  # noqa: E501

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_pools_pool_rules`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_pools_pool_rules`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_pools_pool_rules`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_pools_pool_rules`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_pools_pool_rules`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_pools_pool_rules`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_pools_pool_rules`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'groupnet' in params:
            path_params['Groupnet'] = params['groupnet']  # noqa: E501
        if 'subnet' in params:
            path_params['Subnet'] = params['subnet']  # noqa: E501
        if 'pool' in params:
            path_params['Pool'] = params['pool']  # noqa: E501

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{Pool}/rules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PoolsPoolRulesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_pools_pool_rule(self, pools_pool_rule, pools_pool_rule_id, groupnet, subnet, pool, **kwargs):  # noqa: E501
        """update_pools_pool_rule  # noqa: E501

        Modify a network rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_pools_pool_rule(pools_pool_rule, pools_pool_rule_id, groupnet, subnet, pool, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PoolsPoolRule pools_pool_rule: (required)
        :param str pools_pool_rule_id: Modify a network rule. (required)
        :param str groupnet: (required)
        :param str subnet: (required)
        :param str pool: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_pools_pool_rule_with_http_info(pools_pool_rule, pools_pool_rule_id, groupnet, subnet, pool, **kwargs)  # noqa: E501
        else:
            (data) = self.update_pools_pool_rule_with_http_info(pools_pool_rule, pools_pool_rule_id, groupnet, subnet, pool, **kwargs)  # noqa: E501
            return data

    def update_pools_pool_rule_with_http_info(self, pools_pool_rule, pools_pool_rule_id, groupnet, subnet, pool, **kwargs):  # noqa: E501
        """update_pools_pool_rule  # noqa: E501

        Modify a network rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_pools_pool_rule_with_http_info(pools_pool_rule, pools_pool_rule_id, groupnet, subnet, pool, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PoolsPoolRule pools_pool_rule: (required)
        :param str pools_pool_rule_id: Modify a network rule. (required)
        :param str groupnet: (required)
        :param str subnet: (required)
        :param str pool: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pools_pool_rule', 'pools_pool_rule_id', 'groupnet', 'subnet', 'pool']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_pools_pool_rule" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'pools_pool_rule' is set
        if ('pools_pool_rule' not in params or
                params['pools_pool_rule'] is None):
            raise ValueError("Missing the required parameter `pools_pool_rule` when calling `update_pools_pool_rule`")  # noqa: E501
        # verify the required parameter 'pools_pool_rule_id' is set
        if ('pools_pool_rule_id' not in params or
                params['pools_pool_rule_id'] is None):
            raise ValueError("Missing the required parameter `pools_pool_rule_id` when calling `update_pools_pool_rule`")  # noqa: E501
        # verify the required parameter 'groupnet' is set
        if ('groupnet' not in params or
                params['groupnet'] is None):
            raise ValueError("Missing the required parameter `groupnet` when calling `update_pools_pool_rule`")  # noqa: E501
        # verify the required parameter 'subnet' is set
        if ('subnet' not in params or
                params['subnet'] is None):
            raise ValueError("Missing the required parameter `subnet` when calling `update_pools_pool_rule`")  # noqa: E501
        # verify the required parameter 'pool' is set
        if ('pool' not in params or
                params['pool'] is None):
            raise ValueError("Missing the required parameter `pool` when calling `update_pools_pool_rule`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'pools_pool_rule_id' in params:
            path_params['PoolsPoolRuleId'] = params['pools_pool_rule_id']  # noqa: E501
        if 'groupnet' in params:
            path_params['Groupnet'] = params['groupnet']  # noqa: E501
        if 'subnet' in params:
            path_params['Subnet'] = params['subnet']  # noqa: E501
        if 'pool' in params:
            path_params['Pool'] = params['pool']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'pools_pool_rule' in params:
            body_params = params['pools_pool_rule']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/network/groupnets/{Groupnet}/subnets/{Subnet}/pools/{Pool}/rules/{PoolsPoolRuleId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
