# coding: utf-8

"""
    Isilon SDK

    Isilon SDK - Language bindings for the OneFS API  # noqa: E501

    OpenAPI spec version: 10
    Contact: sdk@isilon.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from isilon_sdk.v9_0_0.api_client import ApiClient


class EventApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_event_alert_condition(self, event_alert_condition, **kwargs):  # noqa: E501
        """create_event_alert_condition  # noqa: E501

        Create a new alert condition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_event_alert_condition(event_alert_condition, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventAlertConditionCreateParams event_alert_condition: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_event_alert_condition_with_http_info(event_alert_condition, **kwargs)  # noqa: E501
        else:
            (data) = self.create_event_alert_condition_with_http_info(event_alert_condition, **kwargs)  # noqa: E501
            return data

    def create_event_alert_condition_with_http_info(self, event_alert_condition, **kwargs):  # noqa: E501
        """create_event_alert_condition  # noqa: E501

        Create a new alert condition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_event_alert_condition_with_http_info(event_alert_condition, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventAlertConditionCreateParams event_alert_condition: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_alert_condition']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_event_alert_condition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_alert_condition' is set
        if ('event_alert_condition' not in params or
                params['event_alert_condition'] is None):
            raise ValueError("Missing the required parameter `event_alert_condition` when calling `create_event_alert_condition`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'event_alert_condition' in params:
            body_params = params['event_alert_condition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/event/alert-conditions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_event_channel(self, event_channel, **kwargs):  # noqa: E501
        """create_event_channel  # noqa: E501

        Create a new channel.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_event_channel(event_channel, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventChannelCreateParams event_channel: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_event_channel_with_http_info(event_channel, **kwargs)  # noqa: E501
        else:
            (data) = self.create_event_channel_with_http_info(event_channel, **kwargs)  # noqa: E501
            return data

    def create_event_channel_with_http_info(self, event_channel, **kwargs):  # noqa: E501
        """create_event_channel  # noqa: E501

        Create a new channel.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_event_channel_with_http_info(event_channel, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventChannelCreateParams event_channel: (required)
        :return: CreateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_channel']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_event_channel" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_channel' is set
        if ('event_channel' not in params or
                params['event_channel'] is None):
            raise ValueError("Missing the required parameter `event_channel` when calling `create_event_channel`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'event_channel' in params:
            body_params = params['event_channel']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/event/channels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_event_event(self, event_event, **kwargs):  # noqa: E501
        """create_event_event  # noqa: E501

        Create a test event.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_event_event(event_event, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventEvent event_event: (required)
        :return: CreateQuotaReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_event_event_with_http_info(event_event, **kwargs)  # noqa: E501
        else:
            (data) = self.create_event_event_with_http_info(event_event, **kwargs)  # noqa: E501
            return data

    def create_event_event_with_http_info(self, event_event, **kwargs):  # noqa: E501
        """create_event_event  # noqa: E501

        Create a test event.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_event_event_with_http_info(event_event, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventEvent event_event: (required)
        :return: CreateQuotaReportResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_event']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_event_event" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_event' is set
        if ('event_event' not in params or
                params['event_event'] is None):
            raise ValueError("Missing the required parameter `event_event` when calling `create_event_event`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'event_event' in params:
            body_params = params['event_event']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/events', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateQuotaReportResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_event_alert_condition(self, event_alert_condition_id, **kwargs):  # noqa: E501
        """delete_event_alert_condition  # noqa: E501

        Delete the alert-condition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_event_alert_condition(event_alert_condition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_alert_condition_id: Delete the alert-condition. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_event_alert_condition_with_http_info(event_alert_condition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_event_alert_condition_with_http_info(event_alert_condition_id, **kwargs)  # noqa: E501
            return data

    def delete_event_alert_condition_with_http_info(self, event_alert_condition_id, **kwargs):  # noqa: E501
        """delete_event_alert_condition  # noqa: E501

        Delete the alert-condition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_event_alert_condition_with_http_info(event_alert_condition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_alert_condition_id: Delete the alert-condition. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_alert_condition_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_event_alert_condition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_alert_condition_id' is set
        if ('event_alert_condition_id' not in params or
                params['event_alert_condition_id'] is None):
            raise ValueError("Missing the required parameter `event_alert_condition_id` when calling `delete_event_alert_condition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_alert_condition_id' in params:
            path_params['EventAlertConditionId'] = params['event_alert_condition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/event/alert-conditions/{EventAlertConditionId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_event_alert_conditions(self, **kwargs):  # noqa: E501
        """delete_event_alert_conditions  # noqa: E501

        Bulk delete of alert conditions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_event_alert_conditions(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str channel: Delete only conditions for this channel
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_event_alert_conditions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.delete_event_alert_conditions_with_http_info(**kwargs)  # noqa: E501
            return data

    def delete_event_alert_conditions_with_http_info(self, **kwargs):  # noqa: E501
        """delete_event_alert_conditions  # noqa: E501

        Bulk delete of alert conditions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_event_alert_conditions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str channel: Delete only conditions for this channel
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['channel']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_event_alert_conditions" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'channel' in params:
            query_params.append(('channel', params['channel']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/event/alert-conditions', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_event_channel(self, event_channel_id, **kwargs):  # noqa: E501
        """delete_event_channel  # noqa: E501

        Delete the channel.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_event_channel(event_channel_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_channel_id: Delete the channel. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_event_channel_with_http_info(event_channel_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_event_channel_with_http_info(event_channel_id, **kwargs)  # noqa: E501
            return data

    def delete_event_channel_with_http_info(self, event_channel_id, **kwargs):  # noqa: E501
        """delete_event_channel  # noqa: E501

        Delete the channel.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_event_channel_with_http_info(event_channel_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_channel_id: Delete the channel. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_channel_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_event_channel" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_channel_id' is set
        if ('event_channel_id' not in params or
                params['event_channel_id'] is None):
            raise ValueError("Missing the required parameter `event_channel_id` when calling `delete_event_channel`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_channel_id' in params:
            path_params['EventChannelId'] = params['event_channel_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/event/channels/{EventChannelId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_alert_condition(self, event_alert_condition_id, **kwargs):  # noqa: E501
        """get_event_alert_condition  # noqa: E501

        Retrieve the alert-condition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_alert_condition(event_alert_condition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_alert_condition_id: Retrieve the alert-condition. (required)
        :return: EventAlertConditions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_event_alert_condition_with_http_info(event_alert_condition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_event_alert_condition_with_http_info(event_alert_condition_id, **kwargs)  # noqa: E501
            return data

    def get_event_alert_condition_with_http_info(self, event_alert_condition_id, **kwargs):  # noqa: E501
        """get_event_alert_condition  # noqa: E501

        Retrieve the alert-condition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_alert_condition_with_http_info(event_alert_condition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_alert_condition_id: Retrieve the alert-condition. (required)
        :return: EventAlertConditions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_alert_condition_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_alert_condition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_alert_condition_id' is set
        if ('event_alert_condition_id' not in params or
                params['event_alert_condition_id'] is None):
            raise ValueError("Missing the required parameter `event_alert_condition_id` when calling `get_event_alert_condition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_alert_condition_id' in params:
            path_params['EventAlertConditionId'] = params['event_alert_condition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/event/alert-conditions/{EventAlertConditionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventAlertConditions',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_categories(self, **kwargs):  # noqa: E501
        """get_event_categories  # noqa: E501

        List all eventgroup categories.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_categories(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: EventCategoriesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_event_categories_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_event_categories_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_event_categories_with_http_info(self, **kwargs):  # noqa: E501
        """get_event_categories  # noqa: E501

        List all eventgroup categories.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_categories_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: EventCategoriesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_categories" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_event_categories`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_event_categories`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_event_categories`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_event_categories`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/categories', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventCategoriesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_category(self, event_category_id, **kwargs):  # noqa: E501
        """get_event_category  # noqa: E501

        Retrieve the eventgroup category.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_category(event_category_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_category_id: Retrieve the eventgroup category. (required)
        :return: EventCategories
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_event_category_with_http_info(event_category_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_event_category_with_http_info(event_category_id, **kwargs)  # noqa: E501
            return data

    def get_event_category_with_http_info(self, event_category_id, **kwargs):  # noqa: E501
        """get_event_category  # noqa: E501

        Retrieve the eventgroup category.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_category_with_http_info(event_category_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_category_id: Retrieve the eventgroup category. (required)
        :return: EventCategories
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_category_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_category" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_category_id' is set
        if ('event_category_id' not in params or
                params['event_category_id'] is None):
            raise ValueError("Missing the required parameter `event_category_id` when calling `get_event_category`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_category_id' in params:
            path_params['EventCategoryId'] = params['event_category_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/categories/{EventCategoryId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventCategories',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_channel(self, event_channel_id, **kwargs):  # noqa: E501
        """get_event_channel  # noqa: E501

        Retrieve the channel.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_channel(event_channel_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_channel_id: Retrieve the channel. (required)
        :return: EventChannels
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_event_channel_with_http_info(event_channel_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_event_channel_with_http_info(event_channel_id, **kwargs)  # noqa: E501
            return data

    def get_event_channel_with_http_info(self, event_channel_id, **kwargs):  # noqa: E501
        """get_event_channel  # noqa: E501

        Retrieve the channel.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_channel_with_http_info(event_channel_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_channel_id: Retrieve the channel. (required)
        :return: EventChannels
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_channel_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_channel" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_channel_id' is set
        if ('event_channel_id' not in params or
                params['event_channel_id'] is None):
            raise ValueError("Missing the required parameter `event_channel_id` when calling `get_event_channel`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_channel_id' in params:
            path_params['EventChannelId'] = params['event_channel_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/event/channels/{EventChannelId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventChannels',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_eventgroup_definition(self, event_eventgroup_definition_id, **kwargs):  # noqa: E501
        """get_event_eventgroup_definition  # noqa: E501

        Retrieve the eventgroup definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_eventgroup_definition(event_eventgroup_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_eventgroup_definition_id: Retrieve the eventgroup definition. (required)
        :return: EventEventgroupDefinitions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_event_eventgroup_definition_with_http_info(event_eventgroup_definition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_event_eventgroup_definition_with_http_info(event_eventgroup_definition_id, **kwargs)  # noqa: E501
            return data

    def get_event_eventgroup_definition_with_http_info(self, event_eventgroup_definition_id, **kwargs):  # noqa: E501
        """get_event_eventgroup_definition  # noqa: E501

        Retrieve the eventgroup definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_eventgroup_definition_with_http_info(event_eventgroup_definition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_eventgroup_definition_id: Retrieve the eventgroup definition. (required)
        :return: EventEventgroupDefinitions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_eventgroup_definition_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_eventgroup_definition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_eventgroup_definition_id' is set
        if ('event_eventgroup_definition_id' not in params or
                params['event_eventgroup_definition_id'] is None):
            raise ValueError("Missing the required parameter `event_eventgroup_definition_id` when calling `get_event_eventgroup_definition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_eventgroup_definition_id' in params:
            path_params['EventEventgroupDefinitionId'] = params['event_eventgroup_definition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/9/event/eventgroup-definitions/{EventEventgroupDefinitionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventEventgroupDefinitions',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_eventgroup_definitions(self, **kwargs):  # noqa: E501
        """get_event_eventgroup_definitions  # noqa: E501

        List all eventgroup definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_eventgroup_definitions(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int category: Return eventgroups in the specified category
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: EventEventgroupDefinitionsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_event_eventgroup_definitions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_event_eventgroup_definitions_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_event_eventgroup_definitions_with_http_info(self, **kwargs):  # noqa: E501
        """get_event_eventgroup_definitions  # noqa: E501

        List all eventgroup definitions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_eventgroup_definitions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int category: Return eventgroups in the specified category
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: EventEventgroupDefinitionsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['category', 'limit', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_eventgroup_definitions" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_event_eventgroup_definitions`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_event_eventgroup_definitions`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_event_eventgroup_definitions`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_event_eventgroup_definitions`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'category' in params:
            query_params.append(('category', params['category']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/9/event/eventgroup-definitions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventEventgroupDefinitionsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_eventgroup_occurrence(self, event_eventgroup_occurrence_id, **kwargs):  # noqa: E501
        """get_event_eventgroup_occurrence  # noqa: E501

        Retrieve individual eventgroup occurrence.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_eventgroup_occurrence(event_eventgroup_occurrence_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_eventgroup_occurrence_id: Retrieve individual eventgroup occurrence. (required)
        :return: EventEventgroupOccurrences
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_event_eventgroup_occurrence_with_http_info(event_eventgroup_occurrence_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_event_eventgroup_occurrence_with_http_info(event_eventgroup_occurrence_id, **kwargs)  # noqa: E501
            return data

    def get_event_eventgroup_occurrence_with_http_info(self, event_eventgroup_occurrence_id, **kwargs):  # noqa: E501
        """get_event_eventgroup_occurrence  # noqa: E501

        Retrieve individual eventgroup occurrence.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_eventgroup_occurrence_with_http_info(event_eventgroup_occurrence_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_eventgroup_occurrence_id: Retrieve individual eventgroup occurrence. (required)
        :return: EventEventgroupOccurrences
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_eventgroup_occurrence_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_eventgroup_occurrence" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_eventgroup_occurrence_id' is set
        if ('event_eventgroup_occurrence_id' not in params or
                params['event_eventgroup_occurrence_id'] is None):
            raise ValueError("Missing the required parameter `event_eventgroup_occurrence_id` when calling `get_event_eventgroup_occurrence`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_eventgroup_occurrence_id' in params:
            path_params['EventEventgroupOccurrenceId'] = params['event_eventgroup_occurrence_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/eventgroup-occurrences/{EventEventgroupOccurrenceId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventEventgroupOccurrences',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_eventgroup_occurrences(self, **kwargs):  # noqa: E501
        """get_event_eventgroup_occurrences  # noqa: E501

        List all eventgroup occurrences.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_eventgroup_occurrences(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int begin: Events that are in progress after this time.
        :param str cause: Filter by cause.
        :param list[int] devid: Filter by devid.
        :param str dir: The direction of the sort.
        :param int end: Events that were in progress before this time.
        :param int event_count: Events for which event_count > this.
        :param bool ignore: Filter by ignored eventgroups.
        :param int last_event_begin: Filter eventgroups by those that have last_event after this time.
        :param int last_event_end: Filter eventgroups by those that have last_event before this time.
        :param int limit: Return no more than this many results at once (see resume).
        :param str partial_cause_long: Filter by partial long-cause description.
        :param str partial_event_type: Filter eventgroups by there associated event's event-type number.
        :param str partial_eventgroup_id: Filter by partial eventgroup id.
        :param bool resolved: Filter by resolved eventgroups.
        :param str resolver: Filter by eventgroup resolver.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param list[str] severity: Filter by severity.
        :param str sort: The field that will be used for sorting.
        :return: EventEventgroupOccurrencesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_event_eventgroup_occurrences_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_event_eventgroup_occurrences_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_event_eventgroup_occurrences_with_http_info(self, **kwargs):  # noqa: E501
        """get_event_eventgroup_occurrences  # noqa: E501

        List all eventgroup occurrences.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_eventgroup_occurrences_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int begin: Events that are in progress after this time.
        :param str cause: Filter by cause.
        :param list[int] devid: Filter by devid.
        :param str dir: The direction of the sort.
        :param int end: Events that were in progress before this time.
        :param int event_count: Events for which event_count > this.
        :param bool ignore: Filter by ignored eventgroups.
        :param int last_event_begin: Filter eventgroups by those that have last_event after this time.
        :param int last_event_end: Filter eventgroups by those that have last_event before this time.
        :param int limit: Return no more than this many results at once (see resume).
        :param str partial_cause_long: Filter by partial long-cause description.
        :param str partial_event_type: Filter eventgroups by there associated event's event-type number.
        :param str partial_eventgroup_id: Filter by partial eventgroup id.
        :param bool resolved: Filter by resolved eventgroups.
        :param str resolver: Filter by eventgroup resolver.
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param list[str] severity: Filter by severity.
        :param str sort: The field that will be used for sorting.
        :return: EventEventgroupOccurrencesExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['begin', 'cause', 'devid', 'dir', 'end', 'event_count', 'ignore', 'last_event_begin', 'last_event_end', 'limit', 'partial_cause_long', 'partial_event_type', 'partial_eventgroup_id', 'resolved', 'resolver', 'resume', 'severity', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_eventgroup_occurrences" % key
                )
            params[key] = val
        del params['kwargs']

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `get_event_eventgroup_occurrences`, length must be greater than or equal to `0`")  # noqa: E501
        if 'last_event_begin' in params and params['last_event_begin'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `last_event_begin` when calling `get_event_eventgroup_occurrences`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'last_event_begin' in params and params['last_event_begin'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `last_event_begin` when calling `get_event_eventgroup_occurrences`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'last_event_end' in params and params['last_event_end'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `last_event_end` when calling `get_event_eventgroup_occurrences`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'last_event_end' in params and params['last_event_end'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `last_event_end` when calling `get_event_eventgroup_occurrences`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_event_eventgroup_occurrences`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_event_eventgroup_occurrences`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('partial_cause_long' in params and
                len(params['partial_cause_long']) > 255):
            raise ValueError("Invalid value for parameter `partial_cause_long` when calling `get_event_eventgroup_occurrences`, length must be less than or equal to `255`")  # noqa: E501
        if ('partial_cause_long' in params and
                len(params['partial_cause_long']) < 0):
            raise ValueError("Invalid value for parameter `partial_cause_long` when calling `get_event_eventgroup_occurrences`, length must be greater than or equal to `0`")  # noqa: E501
        if ('partial_event_type' in params and
                len(params['partial_event_type']) > 255):
            raise ValueError("Invalid value for parameter `partial_event_type` when calling `get_event_eventgroup_occurrences`, length must be less than or equal to `255`")  # noqa: E501
        if ('partial_event_type' in params and
                len(params['partial_event_type']) < 0):
            raise ValueError("Invalid value for parameter `partial_event_type` when calling `get_event_eventgroup_occurrences`, length must be greater than or equal to `0`")  # noqa: E501
        if ('partial_eventgroup_id' in params and
                len(params['partial_eventgroup_id']) > 255):
            raise ValueError("Invalid value for parameter `partial_eventgroup_id` when calling `get_event_eventgroup_occurrences`, length must be less than or equal to `255`")  # noqa: E501
        if ('partial_eventgroup_id' in params and
                len(params['partial_eventgroup_id']) < 0):
            raise ValueError("Invalid value for parameter `partial_eventgroup_id` when calling `get_event_eventgroup_occurrences`, length must be greater than or equal to `0`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_event_eventgroup_occurrences`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_event_eventgroup_occurrences`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `get_event_eventgroup_occurrences`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `get_event_eventgroup_occurrences`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'begin' in params:
            query_params.append(('begin', params['begin']))  # noqa: E501
        if 'cause' in params:
            query_params.append(('cause', params['cause']))  # noqa: E501
        if 'devid' in params:
            query_params.append(('devid', params['devid']))  # noqa: E501
            collection_formats['devid'] = 'csv'  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'end' in params:
            query_params.append(('end', params['end']))  # noqa: E501
        if 'event_count' in params:
            query_params.append(('event_count', params['event_count']))  # noqa: E501
        if 'ignore' in params:
            query_params.append(('ignore', params['ignore']))  # noqa: E501
        if 'last_event_begin' in params:
            query_params.append(('last_event_begin', params['last_event_begin']))  # noqa: E501
        if 'last_event_end' in params:
            query_params.append(('last_event_end', params['last_event_end']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'partial_cause_long' in params:
            query_params.append(('partial_cause_long', params['partial_cause_long']))  # noqa: E501
        if 'partial_event_type' in params:
            query_params.append(('partial_event_type', params['partial_event_type']))  # noqa: E501
        if 'partial_eventgroup_id' in params:
            query_params.append(('partial_eventgroup_id', params['partial_eventgroup_id']))  # noqa: E501
        if 'resolved' in params:
            query_params.append(('resolved', params['resolved']))  # noqa: E501
        if 'resolver' in params:
            query_params.append(('resolver', params['resolver']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'severity' in params:
            query_params.append(('severity', params['severity']))  # noqa: E501
            collection_formats['severity'] = 'csv'  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/eventgroup-occurrences', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventEventgroupOccurrencesExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_eventlist(self, event_eventlist_id, **kwargs):  # noqa: E501
        """get_event_eventlist  # noqa: E501

        Retrieve the list of events for an eventgroup occurrence.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_eventlist(event_eventlist_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_eventlist_id: Retrieve the list of events for an eventgroup occurrence. (required)
        :return: EventEventlists
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_event_eventlist_with_http_info(event_eventlist_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_event_eventlist_with_http_info(event_eventlist_id, **kwargs)  # noqa: E501
            return data

    def get_event_eventlist_with_http_info(self, event_eventlist_id, **kwargs):  # noqa: E501
        """get_event_eventlist  # noqa: E501

        Retrieve the list of events for an eventgroup occurrence.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_eventlist_with_http_info(event_eventlist_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_eventlist_id: Retrieve the list of events for an eventgroup occurrence. (required)
        :return: EventEventlists
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_eventlist_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_eventlist" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_eventlist_id' is set
        if ('event_eventlist_id' not in params or
                params['event_eventlist_id'] is None):
            raise ValueError("Missing the required parameter `event_eventlist_id` when calling `get_event_eventlist`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_eventlist_id' in params:
            path_params['EventEventlistId'] = params['event_eventlist_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/event/eventlists/{EventEventlistId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventEventlists',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_eventlists(self, **kwargs):  # noqa: E501
        """get_event_eventlists  # noqa: E501

        List all event occurrences grouped by eventgroup occurrence.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_eventlists(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_instance: Return only this event occurrence
        :param list[int] eventgroup_id: Filter by eventgroup id.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: EventEventlistsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_event_eventlists_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_event_eventlists_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_event_eventlists_with_http_info(self, **kwargs):  # noqa: E501
        """get_event_eventlists  # noqa: E501

        List all event occurrences grouped by eventgroup occurrence.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_eventlists_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str event_instance: Return only this event occurrence
        :param list[int] eventgroup_id: Filter by eventgroup id.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :return: EventEventlistsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_instance', 'eventgroup_id', 'limit', 'resume']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_eventlists" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_event_eventlists`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_event_eventlists`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `get_event_eventlists`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `get_event_eventlists`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'event_instance' in params:
            query_params.append(('event_instance', params['event_instance']))  # noqa: E501
        if 'eventgroup_id' in params:
            query_params.append(('eventgroup_id', params['eventgroup_id']))  # noqa: E501
            collection_formats['eventgroup_id'] = 'csv'  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/event/eventlists', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventEventlistsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_event_settings(self, **kwargs):  # noqa: E501
        """get_event_settings  # noqa: E501

        Retrieve the settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_settings(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: EventSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_event_settings_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_event_settings_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_event_settings_with_http_info(self, **kwargs):  # noqa: E501
        """get_event_settings  # noqa: E501

        Retrieve the settings.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_event_settings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: EventSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_event_settings" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/settings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventSettings',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_event_alert_conditions(self, **kwargs):  # noqa: E501
        """list_event_alert_conditions  # noqa: E501

        List all alert conditions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_event_alert_conditions(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str channels: Return only conditions for the specified channel:
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: EventAlertConditionsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_event_alert_conditions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_event_alert_conditions_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_event_alert_conditions_with_http_info(self, **kwargs):  # noqa: E501
        """list_event_alert_conditions  # noqa: E501

        List all alert conditions.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_event_alert_conditions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str channels: Return only conditions for the specified channel:
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: EventAlertConditionsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['channels', 'dir', 'limit', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_event_alert_conditions" % key
                )
            params[key] = val
        del params['kwargs']

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_event_alert_conditions`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_event_alert_conditions`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_event_alert_conditions`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_event_alert_conditions`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_event_alert_conditions`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_event_alert_conditions`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_event_alert_conditions`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'channels' in params:
            query_params.append(('channels', params['channels']))  # noqa: E501
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/event/alert-conditions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventAlertConditionsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_event_channels(self, **kwargs):  # noqa: E501
        """list_event_channels  # noqa: E501

        List all channels.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_event_channels(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: EventChannelsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_event_channels_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_event_channels_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_event_channels_with_http_info(self, **kwargs):  # noqa: E501
        """list_event_channels  # noqa: E501

        List all channels.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_event_channels_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str dir: The direction of the sort.
        :param int limit: Return no more than this many results at once (see resume).
        :param str resume: Continue returning results from previous call using this token (token should come from the previous call, resume cannot be used with other options).
        :param str sort: The field that will be used for sorting.
        :return: EventChannelsExtended
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dir', 'limit', 'resume', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_event_channels" % key
                )
            params[key] = val
        del params['kwargs']

        if ('dir' in params and
                len(params['dir']) < 0):
            raise ValueError("Invalid value for parameter `dir` when calling `list_event_channels`, length must be greater than or equal to `0`")  # noqa: E501
        if 'limit' in params and params['limit'] > 4294967295:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_event_channels`, must be a value less than or equal to `4294967295`")  # noqa: E501
        if 'limit' in params and params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `list_event_channels`, must be a value greater than or equal to `1`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) > 8192):
            raise ValueError("Invalid value for parameter `resume` when calling `list_event_channels`, length must be less than or equal to `8192`")  # noqa: E501
        if ('resume' in params and
                len(params['resume']) < 0):
            raise ValueError("Invalid value for parameter `resume` when calling `list_event_channels`, length must be greater than or equal to `0`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) > 255):
            raise ValueError("Invalid value for parameter `sort` when calling `list_event_channels`, length must be less than or equal to `255`")  # noqa: E501
        if ('sort' in params and
                len(params['sort']) < 0):
            raise ValueError("Invalid value for parameter `sort` when calling `list_event_channels`, length must be greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dir' in params:
            query_params.append(('dir', params['dir']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'resume' in params:
            query_params.append(('resume', params['resume']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/event/channels', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EventChannelsExtended',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_event_alert_condition(self, event_alert_condition, event_alert_condition_id, **kwargs):  # noqa: E501
        """update_event_alert_condition  # noqa: E501

        Modify the alert-condition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_event_alert_condition(event_alert_condition, event_alert_condition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventAlertCondition event_alert_condition: (required)
        :param str event_alert_condition_id: Modify the alert-condition (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_event_alert_condition_with_http_info(event_alert_condition, event_alert_condition_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_event_alert_condition_with_http_info(event_alert_condition, event_alert_condition_id, **kwargs)  # noqa: E501
            return data

    def update_event_alert_condition_with_http_info(self, event_alert_condition, event_alert_condition_id, **kwargs):  # noqa: E501
        """update_event_alert_condition  # noqa: E501

        Modify the alert-condition  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_event_alert_condition_with_http_info(event_alert_condition, event_alert_condition_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventAlertCondition event_alert_condition: (required)
        :param str event_alert_condition_id: Modify the alert-condition (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_alert_condition', 'event_alert_condition_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_event_alert_condition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_alert_condition' is set
        if ('event_alert_condition' not in params or
                params['event_alert_condition'] is None):
            raise ValueError("Missing the required parameter `event_alert_condition` when calling `update_event_alert_condition`")  # noqa: E501
        # verify the required parameter 'event_alert_condition_id' is set
        if ('event_alert_condition_id' not in params or
                params['event_alert_condition_id'] is None):
            raise ValueError("Missing the required parameter `event_alert_condition_id` when calling `update_event_alert_condition`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_alert_condition_id' in params:
            path_params['EventAlertConditionId'] = params['event_alert_condition_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'event_alert_condition' in params:
            body_params = params['event_alert_condition']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/4/event/alert-conditions/{EventAlertConditionId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_event_channel(self, event_channel, event_channel_id, **kwargs):  # noqa: E501
        """update_event_channel  # noqa: E501

        Modify the channel.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_event_channel(event_channel, event_channel_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventChannel event_channel: (required)
        :param str event_channel_id: Modify the channel. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_event_channel_with_http_info(event_channel, event_channel_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_event_channel_with_http_info(event_channel, event_channel_id, **kwargs)  # noqa: E501
            return data

    def update_event_channel_with_http_info(self, event_channel, event_channel_id, **kwargs):  # noqa: E501
        """update_event_channel  # noqa: E501

        Modify the channel.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_event_channel_with_http_info(event_channel, event_channel_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventChannel event_channel: (required)
        :param str event_channel_id: Modify the channel. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_channel', 'event_channel_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_event_channel" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_channel' is set
        if ('event_channel' not in params or
                params['event_channel'] is None):
            raise ValueError("Missing the required parameter `event_channel` when calling `update_event_channel`")  # noqa: E501
        # verify the required parameter 'event_channel_id' is set
        if ('event_channel_id' not in params or
                params['event_channel_id'] is None):
            raise ValueError("Missing the required parameter `event_channel_id` when calling `update_event_channel`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_channel_id' in params:
            path_params['EventChannelId'] = params['event_channel_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'event_channel' in params:
            body_params = params['event_channel']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/7/event/channels/{EventChannelId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_event_eventgroup_occurrence(self, event_eventgroup_occurrence, event_eventgroup_occurrence_id, **kwargs):  # noqa: E501
        """update_event_eventgroup_occurrence  # noqa: E501

        modify eventgroup occurrence.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_event_eventgroup_occurrence(event_eventgroup_occurrence, event_eventgroup_occurrence_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventEventgroupOccurrence event_eventgroup_occurrence: (required)
        :param str event_eventgroup_occurrence_id: modify eventgroup occurrence. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_event_eventgroup_occurrence_with_http_info(event_eventgroup_occurrence, event_eventgroup_occurrence_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_event_eventgroup_occurrence_with_http_info(event_eventgroup_occurrence, event_eventgroup_occurrence_id, **kwargs)  # noqa: E501
            return data

    def update_event_eventgroup_occurrence_with_http_info(self, event_eventgroup_occurrence, event_eventgroup_occurrence_id, **kwargs):  # noqa: E501
        """update_event_eventgroup_occurrence  # noqa: E501

        modify eventgroup occurrence.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_event_eventgroup_occurrence_with_http_info(event_eventgroup_occurrence, event_eventgroup_occurrence_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventEventgroupOccurrence event_eventgroup_occurrence: (required)
        :param str event_eventgroup_occurrence_id: modify eventgroup occurrence. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_eventgroup_occurrence', 'event_eventgroup_occurrence_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_event_eventgroup_occurrence" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_eventgroup_occurrence' is set
        if ('event_eventgroup_occurrence' not in params or
                params['event_eventgroup_occurrence'] is None):
            raise ValueError("Missing the required parameter `event_eventgroup_occurrence` when calling `update_event_eventgroup_occurrence`")  # noqa: E501
        # verify the required parameter 'event_eventgroup_occurrence_id' is set
        if ('event_eventgroup_occurrence_id' not in params or
                params['event_eventgroup_occurrence_id'] is None):
            raise ValueError("Missing the required parameter `event_eventgroup_occurrence_id` when calling `update_event_eventgroup_occurrence`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'event_eventgroup_occurrence_id' in params:
            path_params['EventEventgroupOccurrenceId'] = params['event_eventgroup_occurrence_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'event_eventgroup_occurrence' in params:
            body_params = params['event_eventgroup_occurrence']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/eventgroup-occurrences/{EventEventgroupOccurrenceId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_event_eventgroup_occurrences(self, event_eventgroup_occurrences, **kwargs):  # noqa: E501
        """update_event_eventgroup_occurrences  # noqa: E501

        Modify all eventgroup occurrences, resolve or ignore all.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_event_eventgroup_occurrences(event_eventgroup_occurrences, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventEventgroupOccurrence event_eventgroup_occurrences: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_event_eventgroup_occurrences_with_http_info(event_eventgroup_occurrences, **kwargs)  # noqa: E501
        else:
            (data) = self.update_event_eventgroup_occurrences_with_http_info(event_eventgroup_occurrences, **kwargs)  # noqa: E501
            return data

    def update_event_eventgroup_occurrences_with_http_info(self, event_eventgroup_occurrences, **kwargs):  # noqa: E501
        """update_event_eventgroup_occurrences  # noqa: E501

        Modify all eventgroup occurrences, resolve or ignore all.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_event_eventgroup_occurrences_with_http_info(event_eventgroup_occurrences, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventEventgroupOccurrence event_eventgroup_occurrences: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_eventgroup_occurrences']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_event_eventgroup_occurrences" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_eventgroup_occurrences' is set
        if ('event_eventgroup_occurrences' not in params or
                params['event_eventgroup_occurrences'] is None):
            raise ValueError("Missing the required parameter `event_eventgroup_occurrences` when calling `update_event_eventgroup_occurrences`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'event_eventgroup_occurrences' in params:
            body_params = params['event_eventgroup_occurrences']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/eventgroup-occurrences', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_event_settings(self, event_settings, **kwargs):  # noqa: E501
        """update_event_settings  # noqa: E501

        Update settings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_event_settings(event_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventSettings event_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_event_settings_with_http_info(event_settings, **kwargs)  # noqa: E501
        else:
            (data) = self.update_event_settings_with_http_info(event_settings, **kwargs)  # noqa: E501
            return data

    def update_event_settings_with_http_info(self, event_settings, **kwargs):  # noqa: E501
        """update_event_settings  # noqa: E501

        Update settings  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_event_settings_with_http_info(event_settings, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EventSettings event_settings: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_settings']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_event_settings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'event_settings' is set
        if ('event_settings' not in params or
                params['event_settings'] is None):
            raise ValueError("Missing the required parameter `event_settings` when calling `update_event_settings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'event_settings' in params:
            body_params = params['event_settings']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/platform/3/event/settings', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
