# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['DnsSearchPathsArgs', 'DnsSearchPaths']

@pulumi.input_type
class DnsSearchPathsArgs:
    def __init__(__self__, *,
                 search_paths: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        The set of arguments for constructing a DnsSearchPaths resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] search_paths: Devices on your network will use these domain suffixes to resolve DNS names.
        """
        pulumi.set(__self__, "search_paths", search_paths)

    @property
    @pulumi.getter(name="searchPaths")
    def search_paths(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Devices on your network will use these domain suffixes to resolve DNS names.
        """
        return pulumi.get(self, "search_paths")

    @search_paths.setter
    def search_paths(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "search_paths", value)


@pulumi.input_type
class _DnsSearchPathsState:
    def __init__(__self__, *,
                 search_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering DnsSearchPaths resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] search_paths: Devices on your network will use these domain suffixes to resolve DNS names.
        """
        if search_paths is not None:
            pulumi.set(__self__, "search_paths", search_paths)

    @property
    @pulumi.getter(name="searchPaths")
    def search_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Devices on your network will use these domain suffixes to resolve DNS names.
        """
        return pulumi.get(self, "search_paths")

    @search_paths.setter
    def search_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "search_paths", value)


class DnsSearchPaths(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 search_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        The search_paths resource allows you to configure DNS search paths for your Tailscale network. See the
        [Tailscale DNS documentation](https://tailscale.com/kb/1054/dns) for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_tailscale as tailscale

        sample_search_paths = tailscale.DnsSearchPaths("sampleSearchPaths", search_paths=["example.com"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] search_paths: Devices on your network will use these domain suffixes to resolve DNS names.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DnsSearchPathsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The search_paths resource allows you to configure DNS search paths for your Tailscale network. See the
        [Tailscale DNS documentation](https://tailscale.com/kb/1054/dns) for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_tailscale as tailscale

        sample_search_paths = tailscale.DnsSearchPaths("sampleSearchPaths", search_paths=["example.com"])
        ```

        :param str resource_name: The name of the resource.
        :param DnsSearchPathsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DnsSearchPathsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 search_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DnsSearchPathsArgs.__new__(DnsSearchPathsArgs)

            if search_paths is None and not opts.urn:
                raise TypeError("Missing required property 'search_paths'")
            __props__.__dict__["search_paths"] = search_paths
        super(DnsSearchPaths, __self__).__init__(
            'tailscale:index/dnsSearchPaths:DnsSearchPaths',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            search_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'DnsSearchPaths':
        """
        Get an existing DnsSearchPaths resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] search_paths: Devices on your network will use these domain suffixes to resolve DNS names.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DnsSearchPathsState.__new__(_DnsSearchPathsState)

        __props__.__dict__["search_paths"] = search_paths
        return DnsSearchPaths(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="searchPaths")
    def search_paths(self) -> pulumi.Output[Sequence[str]]:
        """
        Devices on your network will use these domain suffixes to resolve DNS names.
        """
        return pulumi.get(self, "search_paths")

