# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/supersetConnection.json
#   timestamp: 2023-03-03T14:23:48+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional, Union

from pydantic import AnyUrl, BaseModel, Extra, Field

from ....utils import supersetApiConnection
from .. import connectionBasicType
from ..database import mysqlConnection, postgresConnection


class SupersetType(Enum):
    Superset = 'Superset'


class SupersetConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[SupersetType] = Field(
        SupersetType.Superset, description='Service Type', title='Service Type'
    )
    hostPort: AnyUrl = Field(
        ..., description='URL for the superset instance.', title='Host and Port'
    )
    connection: Union[
        supersetApiConnection.SupersetAPIConnection,
        postgresConnection.PostgresConnection,
        mysqlConnection.MysqlConnection,
    ] = Field(
        ...,
        description='Choose between API or database connection fetch metadata from superset.',
        title='Superset Connection',
    )
    connectionOptions: Optional[Dict[str, Any]] = Field(
        None,
        description='Additional connection options that can be sent to service during the connection.',
        title='Connection Options',
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
