# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/quickSightConnection.json
#   timestamp: 2023-03-03T14:23:48+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field

from .....security.credentials import awsCredentials
from .. import connectionBasicType


class IdentityType(Enum):
    IAM = 'IAM'
    QUICKSIGHT = 'QUICKSIGHT'
    ANONYMOUS = 'ANONYMOUS'


class QuickSightType(Enum):
    QuickSight = 'QuickSight'


class QuickSightConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[QuickSightType] = Field(
        QuickSightType.QuickSight, description='Service Type', title='Service Type'
    )
    awsConfig: awsCredentials.AWSCredentials = Field(
        ..., title='AWS Credentials Configuration'
    )
    awsAccountId: str = Field(..., description='AWS Account ID', title='AWS Account ID')
    identityType: Optional[IdentityType] = Field(
        IdentityType.IAM,
        description='The authentication method that the user uses to sign in.',
        title='Identity Type',
    )
    namespace: Optional[str] = Field(
        None,
        description='The Amazon QuickSight namespace that contains the dashboard IDs in this request ( To be provided when identityType is `ANONYMOUS` )',
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
