# generated by datamodel-codegen:
#   filename:  entity/policies/policy.json
#   timestamp: 2023-03-03T14:23:48+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...type import basic, entityHistory, entityReference
from .accessControl import rule


class Rules(BaseModel):
    __root__: List[rule.Rule] = Field(
        ..., description='A set of rules associated with the Policy.'
    )


class Policy(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(
        ..., description='Unique identifier that identifies this Policy.'
    )
    name: basic.EntityName = Field(
        ..., description='Name that uniquely identifies this Policy.'
    )
    fullyQualifiedName: Optional[basic.EntityName] = Field(
        None, description='Name that uniquely identifies a Policy.'
    )
    displayName: Optional[str] = Field(
        None, description='Display name for this Policy.'
    )
    description: Optional[basic.Markdown] = Field(
        None,
        description='A short description of the Policy, comprehensible to regular users.',
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this Policy.'
    )
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    enabled: Optional[bool] = Field(True, description='Is the policy enabled.')
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the Policy.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the Policy in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that led to this version of the Policy.'
    )
    rules: Rules = Field(..., description='Set of rules that the policy contains.')
    teams: Optional[entityReference.EntityReferenceList] = Field(
        None, description='Teams that use this policy directly and not through roles.'
    )
    roles: Optional[entityReference.EntityReferenceList] = Field(
        None, description='Roles that use this policy.'
    )
    location: Optional[entityReference.EntityReference] = Field(
        None,
        description='Location to which a policy is applied. This field is relevant only for `lifeCycle` policies.',
    )
    allowDelete: Optional[bool] = Field(
        None, description="Some system policies can't be deleted"
    )
    allowEdit: Optional[bool] = Field(
        None, description="Some system roles can't be edited"
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    disabled: Optional[bool] = Field(
        None,
        description="System policy can't be deleted. Use this flag to disable them.",
    )
