# generated by datamodel-codegen:
#   filename:  entity/data/databaseSchema.json
#   timestamp: 2023-03-03T14:23:48+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Extra, Field, constr

from ...type import basic, entityHistory, entityReference, usageDetails
from ..services import databaseService


class EntityName(BaseModel):
    __root__: constr(regex=r'^((?!::).)*$', min_length=1, max_length=128) = Field(
        ..., description='Name of a table. Expected to be unique within a database.'
    )


class DatabaseSchema(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[basic.Uuid] = Field(
        None, description='Unique identifier that identifies this schema instance.'
    )
    name: EntityName = Field(..., description='Name that identifies the schema.')
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None,
        description="Name that uniquely identifies a schema in the format 'ServiceName.DatabaseName.SchemaName'.",
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this schema.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the schema instance.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this schema.'
    )
    service: entityReference.EntityReference = Field(
        ...,
        description='Link to the database cluster/service where this schema is hosted in.',
    )
    serviceType: Optional[databaseService.DatabaseServiceType] = Field(
        None, description='Service type where this schema is hosted in.'
    )
    database: entityReference.EntityReference = Field(
        ..., description='Reference to Database that contains this table.'
    )
    tables: Optional[entityReference.EntityReferenceList] = Field(
        None, description='References to tables in the schema.'
    )
    usageSummary: Optional[usageDetails.TypeUsedToReturnUsageDetailsOfAnEntity] = Field(
        None, description='Latest usage information for this database.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
