# generated by datamodel-codegen:
#   filename:  entity/classification/classification.json
#   timestamp: 2023-03-03T14:23:48+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Extra, Field, conint

from ...type import basic, entityHistory
from . import tag


class Classification(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[basic.Uuid] = Field(
        None, description='Unique identifier of this entity instance.'
    )
    name: tag.TagName
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='FullyQualifiedName same as `name`.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this entity.'
    )
    description: basic.Markdown = Field(
        ..., description='Description of the classification.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    termCount: Optional[conint(ge=0)] = Field(
        None,
        description='Total number of children tag terms under this classification. This includes all the children in the hierarchy.',
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to the classification.'
    )
    usageCount: Optional[int] = Field(
        None,
        description='Count of how many times the tags from this classification are used.',
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    disabled: Optional[bool] = Field(
        None,
        description="System classifications can't be deleted. Use this flag to disable them.",
    )
    mutuallyExclusive: Optional[bool] = Field(
        'false',
        description='Tags under this classification are mutually exclusive. When mutually exclusive is `true` the tags from this classification are used to **classify** an entity. An entity can only be in one class - example, it can only be either `tier1` or `tier2` and not both. When mutually exclusive is `false`, the tags from this classification are used to **categorize** an entity. An entity have multiple tags simultaneously - example a customer can be `newCustomer` and `atRisk` simultaneously.',
    )
