# generated by datamodel-codegen:
#   filename:  dataInsight/kpi/basic.json
#   timestamp: 2023-03-03T14:23:48+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, List, Optional

from pydantic import BaseModel, Extra, Field

from ...type import basic


class Basic(BaseModel):
    __root__: Any = Field(
        ...,
        description='This schema defines basic types that are used by other Kpi Definitions',
        title='Basic',
    )


class KpiTargetType(Enum):
    NUMBER = 'NUMBER'
    PERCENTAGE = 'PERCENTAGE'


class KpiTarget(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str = Field(
        ...,
        description='name of the parameter. Must match the parameter names in metrics of the chart this objective refers',
    )
    value: str = Field(
        ...,
        description='value to be passed for the Parameters. These are input from Users. We capture this in in string and convert during the runtime.',
    )
    targetMet: Optional[bool] = Field(
        None, description='whether the target value was met or not.'
    )


class KpiResult(BaseModel):
    class Config:
        extra = Extra.forbid

    timestamp: basic.Timestamp = Field(
        ..., description='Data one which result is updated'
    )
    kpiFqn: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='KPI FQN'
    )
    targetResult: List[KpiTarget] = Field(
        ..., description='Metric and their corresponding current results'
    )
