# generated by datamodel-codegen:
#   filename:  configuration/airflowConfiguration.json
#   timestamp: 2023-03-03T14:23:48+00:00

from __future__ import annotations

from typing import Optional

from pydantic import BaseModel, Extra, Field

from . import authConfig, sslConfig


class AirflowConfiguration(BaseModel):
    class Config:
        extra = Extra.forbid

    apiEndpoint: str = Field(..., description='API host endpoint for Airflow')
    hostIp: Optional[str] = Field(
        None, description='Airflow host IP that will be used to connect to the sources.'
    )
    username: str = Field(..., description='Username for Login')
    password: str = Field(..., description='Password for Login')
    metadataApiEndpoint: str = Field(..., description='Metadata api endpoint')
    authProvider: Optional[str] = Field(
        None,
        description='Auth Provider like no-auth, azure , google, okta, auth0, customOidc, openmetadata',
    )
    timeout: Optional[int] = Field(10, description='Timeout')
    authConfig: Optional[authConfig.AuthConfiguration] = Field(
        None, description='Auth Provider Configuration.'
    )
    verifySSL: Optional[str] = Field(
        'no-ssl',
        description='Client SSL verification policy: no-ssl, ignore, validate.',
    )
    sslConfig: Optional[sslConfig.SSLConfig] = Field(
        None, description='OpenMetadata Client SSL configuration.'
    )
