# generated by datamodel-codegen:
#   filename:  api/teams/createTeam.json
#   timestamp: 2023-03-03T14:23:48+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...entity.teams import team
from ...type import basic, entityReference, profile


class CreateTeamRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    teamType: team.TeamType = Field(..., description='Team type')
    name: basic.EntityName
    displayName: Optional[str] = Field(
        None,
        description="Optional name used for display purposes. Example 'Marketing Team'.",
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Optional description of the team.'
    )
    profile: Optional[profile.Profile] = Field(
        None, description='Optional team profile information.'
    )
    parents: Optional[List[basic.Uuid]] = Field(
        None,
        description='Parent teams. For an `Organization` the `parent` is always null. A `BusinessUnit` always has only one parent of type `BusinessUnit` or an `Organization`. A `Division` can have multiple parents of type `BusinessUnit` or `Division`. A `Department` can have multiple parents of type `Division` or `Department`.',
    )
    children: Optional[List[basic.Uuid]] = Field(
        None,
        description='Children teams. An `Organization` can have `BusinessUnit`, `Division` or `Department` as children. A `BusinessUnit` can have `BusinessUnit`, `Division`, or `Department` as children. A `Division` can have `Division` or `Department` as children. A `Department` can have can have `Department` as children.',
    )
    users: Optional[List[basic.Uuid]] = Field(
        None, description='Optional IDs of users that are part of the team.'
    )
    defaultRoles: Optional[List[basic.Uuid]] = Field(
        None,
        description='Roles to be assigned to all users that are part of this team.',
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this team. '
    )
    isJoinable: Optional[bool] = Field(
        True,
        description='Can any user join this team during sign up? Value of true indicates yes, and false no.',
    )
    policies: Optional[List[basic.Uuid]] = Field(
        None, description='Policies that is attached to this team.'
    )
