""" Constant values """
from typing import FrozenSet

from typing_extensions import Final, Literal

# Data types
NUMBER: Final[Literal["N"]] = "N"
STRING: Final[Literal["S"]] = "S"
BINARY: Final[Literal["B"]] = "B"
NUMBER_SET: Final[Literal["NS"]] = "NS"
STRING_SET: Final[Literal["SS"]] = "SS"
BINARY_SET: Final[Literal["BS"]] = "BS"
LIST: Final[Literal["L"]] = "L"
BOOL: Final[Literal["BOOL"]] = "BOOL"
MAP: Final[Literal["M"]] = "M"
NULL: Final[Literal["NULL"]] = "NULL"
KeyType = Literal[Literal["S"], Literal["N"], Literal["B"]]

NONE: Final[Literal["NONE"]] = "NONE"

# SELECT
COUNT: Final[Literal["COUNT"]] = "COUNT"
ALL_ATTRIBUTES: Final[Literal["ALL_ATTRIBUTES"]] = "ALL_ATTRIBUTES"
ALL_PROJECTED_ATTRIBUTES: Final[
    Literal["ALL_PROJECTED_ATTRIBUTES"]
] = "ALL_PROJECTED_ATTRIBUTES"
SPECIFIC_ATTRIBUTES: Final[Literal["SPECIFIC_ATTRIBUTES"]] = "SPECIFIC_ATTRIBUTES"
SelectType = Literal[
    Literal["COUNT"],
    Literal["ALL_ATTRIBUTES"],
    Literal["ALL_PROJECTED_ATTRIBUTES"],
    Literal["SPECIFIC_ATTRIBUTES"],
]
NonCountSelectType = Literal[
    Literal["ALL_ATTRIBUTES"],
    Literal["ALL_PROJECTED_ATTRIBUTES"],
    Literal["SPECIFIC_ATTRIBUTES"],
]

# ReturnValues
ALL_OLD: Final[Literal["ALL_OLD"]] = "ALL_OLD"
ALL_NEW: Final[Literal["ALL_NEW"]] = "ALL_NEW"
UPDATED_OLD: Final[Literal["UPDATED_OLD"]] = "UPDATED_OLD"
UPDATED_NEW: Final[Literal["UPDATED_NEW"]] = "UPDATED_NEW"

# ReturnConsumedCapacity
INDEXES: Final[Literal["INDEXES"]] = "INDEXES"
TOTAL: Final[Literal["TOTAL"]] = "TOTAL"
ReturnCapacityType = Literal[Literal["NONE"], Literal["INDEXES"], Literal["TOTAL"]]

# ReturnItemCollectionMetrics
SIZE: Final[Literal["SIZE"]] = "SIZE"
ReturnItemCollectionMetricsType = Literal[Literal["SIZE"], Literal["NONE"]]

TableStatusType = Literal[
    Literal["CREATING"],
    Literal["UPDATING"],
    Literal["DELETING"],
    Literal["ACTIVE"],
    Literal["INACCESSIBLE_ENCRYPTION_CREDENTIALS"],
    Literal["ARCHIVING"],
    Literal["ARCHIVED"],
]

IndexStatusType = Literal[
    Literal["CREATING"],
    Literal["UPDATING"],
    Literal["DELETING"],
    Literal["ACTIVE"],
]

# Billing mode
PROVISIONED: Final[Literal["PROVISIONED"]] = "PROVISIONED"
PAY_PER_REQUEST: Final[Literal["PAY_PER_REQUEST"]] = "PAY_PER_REQUEST"
BillingModeType = Literal[Literal["PROVISIONED"], Literal["PAY_PER_REQUEST"]]

# Stream view type
KEYS_ONLY: Final[Literal["KEYS_ONLY"]] = "KEYS_ONLY"
NEW_IMAGE: Final[Literal["NEW_IMAGE"]] = "NEW_IMAGE"
OLD_IMAGE: Final[Literal["OLD_IMAGE"]] = "OLD_IMAGE"
NEW_AND_OLD_IMAGES: Final[Literal["NEW_AND_OLD_IMAGES"]] = "NEW_AND_OLD_IMAGES"
StreamViewType = Literal[
    Literal["KEYS_ONLY"],
    Literal["NEW_IMAGE"],
    Literal["OLD_IMAGE"],
    Literal["NEW_AND_OLD_IMAGES"],
]

# TTL
TimeToLiveStatusType = Literal[
    Literal["ENABLING"],
    Literal["DISABLING"],
    Literal["ENABLED"],
    Literal["DISABLED"],
]

# Maximum number of keys in a BatchGetItem request
MAX_GET_BATCH: Final[Literal[100]] = 100
# Maximum number of items in a BatchWriteItem request
MAX_WRITE_BATCH: Final[Literal[25]] = 25

READ_COMMANDS: Final[FrozenSet[str]] = frozenset(
    ["batch_get_item", "get_item", "query", "scan", "transact_get_items"]
)

# Last fetched on 2015-11-10
# http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html
RESERVED_WORDS: Final[FrozenSet[str]] = frozenset(
    [
        "ABORT",
        "ABSOLUTE",
        "ACTION",
        "ADD",
        "AFTER",
        "AGENT",
        "AGGREGATE",
        "ALL",
        "ALLOCATE",
        "ALTER",
        "ANALYZE",
        "AND",
        "ANY",
        "ARCHIVE",
        "ARE",
        "ARRAY",
        "AS",
        "ASC",
        "ASCII",
        "ASENSITIVE",
        "ASSERTION",
        "ASYMMETRIC",
        "AT",
        "ATOMIC",
        "ATTACH",
        "ATTRIBUTE",
        "AUTH",
        "AUTHORIZATION",
        "AUTHORIZE",
        "AUTO",
        "AVG",
        "BACK",
        "BACKUP",
        "BASE",
        "BATCH",
        "BEFORE",
        "BEGIN",
        "BETWEEN",
        "BIGINT",
        "BINARY",
        "BIT",
        "BLOB",
        "BLOCK",
        "BOOLEAN",
        "BOTH",
        "BREADTH",
        "BUCKET",
        "BULK",
        "BY",
        "BYTE",
        "CALL",
        "CALLED",
        "CALLING",
        "CAPACITY",
        "CASCADE",
        "CASCADED",
        "CASE",
        "CAST",
        "CATALOG",
        "CHAR",
        "CHARACTER",
        "CHECK",
        "CLASS",
        "CLOB",
        "CLOSE",
        "CLUSTER",
        "CLUSTERED",
        "CLUSTERING",
        "CLUSTERS",
        "COALESCE",
        "COLLATE",
        "COLLATION",
        "COLLECTION",
        "COLUMN",
        "COLUMNS",
        "COMBINE",
        "COMMENT",
        "COMMIT",
        "COMPACT",
        "COMPILE",
        "COMPRESS",
        "CONDITION",
        "CONFLICT",
        "CONNECT",
        "CONNECTION",
        "CONSISTENCY",
        "CONSISTENT",
        "CONSTRAINT",
        "CONSTRAINTS",
        "CONSTRUCTOR",
        "CONSUMED",
        "CONTINUE",
        "CONVERT",
        "COPY",
        "CORRESPONDING",
        "COUNT",
        "COUNTER",
        "CREATE",
        "CROSS",
        "CUBE",
        "CURRENT",
        "CURSOR",
        "CYCLE",
        "DATA",
        "DATABASE",
        "DATE",
        "DATETIME",
        "DAY",
        "DEALLOCATE",
        "DEC",
        "DECIMAL",
        "DECLARE",
        "DEFAULT",
        "DEFERRABLE",
        "DEFERRED",
        "DEFINE",
        "DEFINED",
        "DEFINITION",
        "DELETE",
        "DELIMITED",
        "DEPTH",
        "DEREF",
        "DESC",
        "DESCRIBE",
        "DESCRIPTOR",
        "DETACH",
        "DETERMINISTIC",
        "DIAGNOSTICS",
        "DIRECTORIES",
        "DISABLE",
        "DISCONNECT",
        "DISTINCT",
        "DISTRIBUTE",
        "DO",
        "DOMAIN",
        "DOUBLE",
        "DROP",
        "DUMP",
        "DURATION",
        "DYNAMIC",
        "EACH",
        "ELEMENT",
        "ELSE",
        "ELSEIF",
        "EMPTY",
        "ENABLE",
        "END",
        "EQUAL",
        "EQUALS",
        "ERROR",
        "ESCAPE",
        "ESCAPED",
        "EVAL",
        "EVALUATE",
        "EXCEEDED",
        "EXCEPT",
        "EXCEPTION",
        "EXCEPTIONS",
        "EXCLUSIVE",
        "EXEC",
        "EXECUTE",
        "EXISTS",
        "EXIT",
        "EXPLAIN",
        "EXPLODE",
        "EXPORT",
        "EXPRESSION",
        "EXTENDED",
        "EXTERNAL",
        "EXTRACT",
        "FAIL",
        "FALSE",
        "FAMILY",
        "FETCH",
        "FIELDS",
        "FILE",
        "FILTER",
        "FILTERING",
        "FINAL",
        "FINISH",
        "FIRST",
        "FIXED",
        "FLATTERN",
        "FLOAT",
        "FOR",
        "FORCE",
        "FOREIGN",
        "FORMAT",
        "FORWARD",
        "FOUND",
        "FREE",
        "FROM",
        "FULL",
        "FUNCTION",
        "FUNCTIONS",
        "GENERAL",
        "GENERATE",
        "GET",
        "GLOB",
        "GLOBAL",
        "GO",
        "GOTO",
        "GRANT",
        "GREATER",
        "GROUP",
        "GROUPING",
        "HANDLER",
        "HASH",
        "HAVE",
        "HAVING",
        "HEAP",
        "HIDDEN",
        "HOLD",
        "HOUR",
        "IDENTIFIED",
        "IDENTITY",
        "IF",
        "IGNORE",
        "IMMEDIATE",
        "IMPORT",
        "IN",
        "INCLUDING",
        "INCLUSIVE",
        "INCREMENT",
        "INCREMENTAL",
        "INDEX",
        "INDEXED",
        "INDEXES",
        "INDICATOR",
        "INFINITE",
        "INITIALLY",
        "INLINE",
        "INNER",
        "INNTER",
        "INOUT",
        "INPUT",
        "INSENSITIVE",
        "INSERT",
        "INSTEAD",
        "INT",
        "INTEGER",
        "INTERSECT",
        "INTERVAL",
        "INTO",
        "INVALIDATE",
        "IS",
        "ISOLATION",
        "ITEM",
        "ITEMS",
        "ITERATE",
        "JOIN",
        "KEY",
        "KEYS",
        "LAG",
        "LANGUAGE",
        "LARGE",
        "LAST",
        "LATERAL",
        "LEAD",
        "LEADING",
        "LEAVE",
        "LEFT",
        "LENGTH",
        "LESS",
        "LEVEL",
        "LIKE",
        "LIMIT",
        "LIMITED",
        "LINES",
        "LIST",
        "LOAD",
        "LOCAL",
        "LOCALTIME",
        "LOCALTIMESTAMP",
        "LOCATION",
        "LOCATOR",
        "LOCK",
        "LOCKS",
        "LOG",
        "LOGED",
        "LONG",
        "LOOP",
        "LOWER",
        "MAP",
        "MATCH",
        "MATERIALIZED",
        "MAX",
        "MAXLEN",
        "MEMBER",
        "MERGE",
        "METHOD",
        "METRICS",
        "MIN",
        "MINUS",
        "MINUTE",
        "MISSING",
        "MOD",
        "MODE",
        "MODIFIES",
        "MODIFY",
        "MODULE",
        "MONTH",
        "MULTI",
        "MULTISET",
        "NAME",
        "NAMES",
        "NATIONAL",
        "NATURAL",
        "NCHAR",
        "NCLOB",
        "NEW",
        "NEXT",
        "NO",
        "NONE",
        "NOT",
        "NULL",
        "NULLIF",
        "NUMBER",
        "NUMERIC",
        "OBJECT",
        "OF",
        "OFFLINE",
        "OFFSET",
        "OLD",
        "ON",
        "ONLINE",
        "ONLY",
        "OPAQUE",
        "OPEN",
        "OPERATOR",
        "OPTION",
        "OR",
        "ORDER",
        "ORDINALITY",
        "OTHER",
        "OTHERS",
        "OUT",
        "OUTER",
        "OUTPUT",
        "OVER",
        "OVERLAPS",
        "OVERRIDE",
        "OWNER",
        "PAD",
        "PARALLEL",
        "PARAMETER",
        "PARAMETERS",
        "PARTIAL",
        "PARTITION",
        "PARTITIONED",
        "PARTITIONS",
        "PATH",
        "PERCENT",
        "PERCENTILE",
        "PERMISSION",
        "PERMISSIONS",
        "PIPE",
        "PIPELINED",
        "PLAN",
        "POOL",
        "POSITION",
        "PRECISION",
        "PREPARE",
        "PRESERVE",
        "PRIMARY",
        "PRIOR",
        "PRIVATE",
        "PRIVILEGES",
        "PROCEDURE",
        "PROCESSED",
        "PROJECT",
        "PROJECTION",
        "PROPERTY",
        "PROVISIONING",
        "PUBLIC",
        "PUT",
        "QUERY",
        "QUIT",
        "QUORUM",
        "RAISE",
        "RANDOM",
        "RANGE",
        "RANK",
        "RAW",
        "READ",
        "READS",
        "REAL",
        "REBUILD",
        "RECORD",
        "RECURSIVE",
        "REDUCE",
        "REF",
        "REFERENCE",
        "REFERENCES",
        "REFERENCING",
        "REGEXP",
        "REGION",
        "REINDEX",
        "RELATIVE",
        "RELEASE",
        "REMAINDER",
        "RENAME",
        "REPEAT",
        "REPLACE",
        "REQUEST",
        "RESET",
        "RESIGNAL",
        "RESOURCE",
        "RESPONSE",
        "RESTORE",
        "RESTRICT",
        "RESULT",
        "RETURN",
        "RETURNING",
        "RETURNS",
        "REVERSE",
        "REVOKE",
        "RIGHT",
        "ROLE",
        "ROLES",
        "ROLLBACK",
        "ROLLUP",
        "ROUTINE",
        "ROW",
        "ROWS",
        "RULE",
        "RULES",
        "SAMPLE",
        "SATISFIES",
        "SAVE",
        "SAVEPOINT",
        "SCAN",
        "SCHEMA",
        "SCOPE",
        "SCROLL",
        "SEARCH",
        "SECOND",
        "SECTION",
        "SEGMENT",
        "SEGMENTS",
        "SELECT",
        "SELF",
        "SEMI",
        "SENSITIVE",
        "SEPARATE",
        "SEQUENCE",
        "SERIALIZABLE",
        "SESSION",
        "SET",
        "SETS",
        "SHARD",
        "SHARE",
        "SHARED",
        "SHORT",
        "SHOW",
        "SIGNAL",
        "SIMILAR",
        "SIZE",
        "SKEWED",
        "SMALLINT",
        "SNAPSHOT",
        "SOME",
        "SOURCE",
        "SPACE",
        "SPACES",
        "SPARSE",
        "SPECIFIC",
        "SPECIFICTYPE",
        "SPLIT",
        "SQL",
        "SQLCODE",
        "SQLERROR",
        "SQLEXCEPTION",
        "SQLSTATE",
        "SQLWARNING",
        "START",
        "STATE",
        "STATIC",
        "STATUS",
        "STORAGE",
        "STORE",
        "STORED",
        "STREAM",
        "STRING",
        "STRUCT",
        "STYLE",
        "SUB",
        "SUBMULTISET",
        "SUBPARTITION",
        "SUBSTRING",
        "SUBTYPE",
        "SUM",
        "SUPER",
        "SYMMETRIC",
        "SYNONYM",
        "SYSTEM",
        "TABLE",
        "TABLESAMPLE",
        "TEMP",
        "TEMPORARY",
        "TERMINATED",
        "TEXT",
        "THAN",
        "THEN",
        "THROUGHPUT",
        "TIME",
        "TIMESTAMP",
        "TIMEZONE",
        "TINYINT",
        "TO",
        "TOKEN",
        "TOTAL",
        "TOUCH",
        "TRAILING",
        "TRANSACTION",
        "TRANSFORM",
        "TRANSLATE",
        "TRANSLATION",
        "TREAT",
        "TRIGGER",
        "TRIM",
        "TRUE",
        "TRUNCATE",
        "TTL",
        "TUPLE",
        "TYPE",
        "UNDER",
        "UNDO",
        "UNION",
        "UNIQUE",
        "UNIT",
        "UNKNOWN",
        "UNLOGGED",
        "UNNEST",
        "UNPROCESSED",
        "UNSIGNED",
        "UNTIL",
        "UPDATE",
        "UPPER",
        "URL",
        "USAGE",
        "USE",
        "USER",
        "USERS",
        "USING",
        "UUID",
        "VACUUM",
        "VALUE",
        "VALUED",
        "VALUES",
        "VARCHAR",
        "VARIABLE",
        "VARIANCE",
        "VARINT",
        "VARYING",
        "VIEW",
        "VIEWS",
        "VIRTUAL",
        "VOID",
        "WAIT",
        "WHEN",
        "WHENEVER",
        "WHERE",
        "WHILE",
        "WINDOW",
        "WITH",
        "WITHIN",
        "WITHOUT",
        "WORK",
        "WRAPPED",
        "WRITE",
        "YEAR",
        "ZONE",
    ]
)
