#!/usr/bin/python3

"""
CVE checker for libpng

References:
http://www.cvedetails.com/vulnerability-list/vendor_id-7294/Libpng.html

RSS feed: http://www.cvedetails.com/vulnerability-feed.php?vendor_id=7294&product_id=0&version_id=&orderby=3&cvssscoremin=0
"""
from . import Checker


class PngChecker(Checker):
    CONTAINS_PATTERNS = [
        r"libpng error: %s, offset=%d",
        r"Application uses deprecated png_write_init\(\) and should be recompiled",
        r"libpng version ",
    ]
    FILENAME_PATTERNS = [r"libpng.so.", r"libpng16.so."]
    VERSION_PATTERNS = [r"libpng version ([0-9]+\.[0-9]+\.[0-9]+) -"]
    VENDOR_PRODUCT = [("libpng", "libpng")]
