import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .Texture_autogen import Texture


@register
class DepthTexture(Texture):
    """DepthTexture

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/textures/DepthTexture
    """

    def __init__(self, width=0, height=0, type="UnsignedShortType", wrapS="ClampToEdgeWrapping", wrapT="ClampToEdgeWrapping", magFilter="NearestFilter", minFilter="NearestFilter", anisotropy=1, format="DepthFormat", **kwargs):
        kwargs['width'] = width
        kwargs['height'] = height
        kwargs['type'] = type
        kwargs['wrapS'] = wrapS
        kwargs['wrapT'] = wrapT
        kwargs['magFilter'] = magFilter
        kwargs['minFilter'] = minFilter
        kwargs['anisotropy'] = anisotropy
        kwargs['format'] = format
        super(DepthTexture, self).__init__(**kwargs)

    _model_name = Unicode('DepthTextureModel').tag(sync=True)

    width = CInt(0, allow_none=False).tag(sync=True)

    height = CInt(0, allow_none=False).tag(sync=True)

    format = Enum(DepthFormats, "DepthFormat", allow_none=False).tag(sync=True)

    type = Enum(DataTypes, "UnsignedShortType", allow_none=False).tag(sync=True)

    minFilter = Enum(Filters, "NearestFilter", allow_none=False).tag(sync=True)

    magFilter = Enum(Filters, "NearestFilter", allow_none=False).tag(sync=True)

    flipY = Bool(False, allow_none=False).tag(sync=True)

    generateMipmaps = Bool(False, allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    DepthTexture.__signature__ = inspect.signature(DepthTexture.__init__)
