import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.Object3D import Object3D

from ..materials.SpriteMaterial_autogen import SpriteMaterial

@register
class Sprite(Object3D):
    """Sprite

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/objects/Sprite
    """

    def __init__(self, material=None, **kwargs):
        kwargs['material'] = material
        super(Sprite, self).__init__(**kwargs)

    _model_name = Unicode('SpriteModel').tag(sync=True)

    material = Instance(SpriteMaterial, allow_none=True).tag(sync=True, **widget_serialization)

    center = Vector2(default_value=[0.5, 0.5]).tag(sync=True)

    type = Unicode("Sprite", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    Sprite.__signature__ = inspect.signature(Sprite.__init__)
