import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .Line_autogen import Line


@register
class LineSegments(Line):
    """LineSegments

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/objects/LineSegments
    """

    def __init__(self, geometry=None, material=None, **kwargs):
        kwargs['geometry'] = geometry
        kwargs['material'] = material
        super(LineSegments, self).__init__(**kwargs)

    _model_name = Unicode('LineSegmentsModel').tag(sync=True)

    type = Unicode("LineSegments", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    LineSegments.__signature__ = inspect.signature(LineSegments.__init__)
