import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget


@register
class Box3(ThreeWidget):
    """Box3

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/math/Box3
    """

    def __init__(self, min=[0, 0, 0], max=[0, 0, 0], **kwargs):
        kwargs['min'] = min
        kwargs['max'] = max
        super(Box3, self).__init__(**kwargs)

    _model_name = Unicode('Box3Model').tag(sync=True)

    min = Vector3(default_value=[0, 0, 0]).tag(sync=True)

    max = Vector3(default_value=[0, 0, 0]).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    Box3.__signature__ = inspect.signature(Box3.__init__)
