import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .Material import Material

from ..textures.Texture_autogen import Texture

@register
class SpriteMaterial(Material):
    """SpriteMaterial

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/materials/SpriteMaterial
    """

    _model_name = Unicode('SpriteMaterialModel').tag(sync=True)

    color = Color("#ffffff", allow_none=False).tag(sync=True)

    fog = Bool(False, allow_none=False).tag(sync=True)

    lights = Bool(False, allow_none=False).tag(sync=True)

    map = Instance(Texture, allow_none=True).tag(sync=True, **widget_serialization)

    rotation = CFloat(0, allow_none=False).tag(sync=True)

    sizeAttenuation = Bool(True, allow_none=False).tag(sync=True)

    type = Unicode("SpriteMaterial", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    SpriteMaterial.__signature__ = inspect.signature(SpriteMaterial.__init__)
