import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget


@register
class BaseBufferGeometry(ThreeWidget):
    """BaseBufferGeometry

    Autogenerated by generate-wrappers.js
    This class is a custom class for pythreejs, with no
    direct corresponding class in three.js.
    """

    def __init__(self, **kwargs):
        super(BaseBufferGeometry, self).__init__(**kwargs)

    _model_name = Unicode('BaseBufferGeometryModel').tag(sync=True)

    name = Unicode("", allow_none=False).tag(sync=True)

    type = Unicode("BaseBufferGeometry", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    BaseBufferGeometry.__signature__ = inspect.signature(BaseBufferGeometry.__init__)
