"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFormationInputHandler = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const aws_lambda_python_alpha_1 = require("@aws-cdk/aws-lambda-python-alpha");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const _1 = require(".");
const interfaces_1 = require("../interfaces");
class CloudFormationInputHandler extends _1.BaseInputHandler {
    constructor(scope, id) {
        super(scope, id);
        this.integrationTargetType = interfaces_1.IntegrationTargetType.LAMBDA;
        this.handler = new aws_lambda_python_alpha_1.PythonFunction(this, `${id}CloudFormationInputHandler`, {
            entry: path_1.join(__dirname, 'lambda-function-code/cloudformation-input-handler'),
            runtime: aws_lambda_1.Runtime.PYTHON_3_9,
            index: 'lambda_function.py',
            handler: 'lambda_handler',
            timeout: aws_cdk_lib_1.Duration.seconds(60),
        });
    }
    get evalEngineCallerPrincipalArn() {
        return this.handler.functionArn;
    }
    get urlSafeName() {
        return 'CloudFormation';
    }
}
exports.CloudFormationInputHandler = CloudFormationInputHandler;
_a = JSII_RTTI_SYMBOL_1;
CloudFormationInputHandler[_a] = { fqn: "control-broker.inputHandlers.CloudFormationInputHandler", version: "0.12.0" };
//# sourceMappingURL=data:application/json;base64,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