import { Construct } from 'constructs';
import { IIntegrationTarget, IntegrationTargetType } from '../interfaces';
export declare abstract class BaseInputHandler extends Construct implements IIntegrationTarget {
    abstract readonly integrationTargetType: IntegrationTargetType;
    /**
     * Return a name for this input handler that is safe for use in the
     * path of a URL.
     */
    abstract get urlSafeName(): string;
    /**
     * ARN of the principal that will call the EvalEngine endpoint.
     */
    abstract get evalEngineCallerPrincipalArn(): string;
}
