"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpaEvalEngine = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const aws_lambda_python_alpha_1 = require("@aws-cdk/aws-lambda-python-alpha");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const _1 = require(".");
const interfaces_1 = require("../interfaces");
class OpaEvalEngine extends _1.BaseEvalEngine {
    constructor(scope, id) {
        super(scope, id);
        this.integrationTargetType = interfaces_1.IntegrationTargetType.LAMBDA;
        this.handler = new aws_lambda_python_alpha_1.PythonFunction(this, `${id}OpaEvalEngineLambdaFunction`, {
            entry: path_1.join(__dirname, 'lambda-function-code/opa-eval-engine/'),
            runtime: aws_lambda_1.Runtime.PYTHON_3_9,
            index: 'lambda_function.py',
            handler: 'lambda_handler',
            timeout: aws_cdk_lib_1.Duration.seconds(60),
        });
    }
}
exports.OpaEvalEngine = OpaEvalEngine;
_a = JSII_RTTI_SYMBOL_1;
OpaEvalEngine[_a] = { fqn: "control-broker.OpaEvalEngine", version: "0.12.0" };
//# sourceMappingURL=data:application/json;base64,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