"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Api = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const constructs_1 = require("constructs");
;
class Api extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.id = id;
        this.accessLogRetention = aws_logs_1.RetentionDays.ONE_DAY;
        this.inputHandlerBindings = {};
        this.evalEngineBinding = { evalEngine: undefined, binding: undefined };
        if (props.apiAccessLogGroup) {
            this.apiAccessLogGroup = props.apiAccessLogGroup;
        }
        else {
            this.apiAccessLogGroup = new aws_logs_1.LogGroup(this, `${id}AccessLogGroup`, { retention: this.accessLogRetention });
            this.apiAccessLogGroup.grantWrite(new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'));
        }
        this.awsApiGatewayHTTPApi = new aws_apigatewayv2_alpha_1.HttpApi(this, `${id}HttpApi`, { createDefaultStage: true });
        this.configureAwsApiGatewayHTTPApiLogging();
        this.awsApiGatewayRestApi = new aws_apigateway_1.RestApi(this, `${id}RestApi`);
    }
    configureAwsApiGatewayHTTPApiLogging() {
        const cfnDefaultStage = this.awsApiGatewayHTTPApi.node.defaultChild;
        cfnDefaultStage.addOverride('AccessLogSettings', {
            DestinationArn: this.apiAccessLogGroup.logGroupArn,
            Format: JSON.stringify({
                requestId: '$context.requestId',
                ip: '$context.identity.sourceIp',
                requestTime: '$context.requestTime',
                httpMethod: '$context.httpMethod',
                routeKey: '$context.routeKey',
                status: '$context.status',
                protocol: '$context.protocol',
                responseLength: '$context.responseLength',
                integrationErrorMessage: '$context.integrationErrorMessage',
            }),
        });
    }
    setEvalEngine(evalEngine, binding) {
        this.evalEngineBinding = { evalEngine, binding };
    }
    get evalEngineUrl() {
        if (this.evalEngineBinding.binding === undefined) {
            throw new Error('You must add an eval engine binding before trying to get its URL');
        }
        return this.evalEngineBinding.binding.url;
    }
    addInputHandler(inputHandler, binding) {
        if (this.evalEngineBinding.binding === undefined) {
            throw new Error('You must add an eval engine binding before trying to add input handlers');
        }
        this.evalEngineBinding.binding.authorizePrincipalArn(inputHandler.evalEngineCallerPrincipalArn);
        this.inputHandlerBindings[inputHandler.urlSafeName] = { inputHandler, binding };
    }
    getUrlForInputHandler(inputHandler) {
        return this.inputHandlerBindings[inputHandler.urlSafeName].binding.url;
    }
}
exports.Api = Api;
_a = JSII_RTTI_SYMBOL_1;
Api[_a] = { fqn: "control-broker.Api", version: "0.12.0" };
//# sourceMappingURL=data:application/json;base64,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