import { HttpApi } from '@aws-cdk/aws-apigatewayv2-alpha';
import { RestApi } from 'aws-cdk-lib/aws-apigateway';
import { LogGroup, RetentionDays } from 'aws-cdk-lib/aws-logs';
import { Construct } from 'constructs';
import { BaseEvalEngine } from '.';
import { BaseApiBinding } from './api-bindings';
import { BaseInputHandler } from './input-handlers';
export interface ApiProps {
    readonly apiAccessLogGroup?: LogGroup;
}
export interface InputHandlerBindingConfiguration {
    readonly inputHandler: BaseInputHandler;
    readonly binding: BaseApiBinding<any>;
}
export interface InputHandlerBindingConfigurations {
    [inputHandlerName: string]: InputHandlerBindingConfiguration;
}
export interface EvalEngineBindingConfiguration {
    readonly evalEngine: BaseEvalEngine | undefined;
    readonly binding: BaseApiBinding<any> | undefined;
}
export declare class Api extends Construct {
    readonly id: string;
    readonly awsApiGatewayRestApi: RestApi;
    readonly awsApiGatewayHTTPApi: HttpApi;
    readonly accessLogRetention: RetentionDays;
    readonly apiAccessLogGroup: LogGroup;
    protected inputHandlerBindings: InputHandlerBindingConfigurations;
    protected evalEngineBinding: EvalEngineBindingConfiguration;
    constructor(scope: Construct, id: string, props: ApiProps);
    protected configureAwsApiGatewayHTTPApiLogging(): void;
    setEvalEngine(evalEngine: BaseEvalEngine, binding: BaseApiBinding<any>): void;
    protected get evalEngineUrl(): string;
    addInputHandler(inputHandler: BaseInputHandler, binding: BaseApiBinding<any>): void;
    getUrlForInputHandler(inputHandler: BaseInputHandler): string;
}
