"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpApiBinding = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const aws_apigatewayv2_authorizers_alpha_1 = require("@aws-cdk/aws-apigatewayv2-authorizers-alpha");
const aws_apigatewayv2_integrations_alpha_1 = require("@aws-cdk/aws-apigatewayv2-integrations-alpha");
const aws_events_1 = require("aws-cdk-lib/aws-events");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const _1 = require(".");
const constants_1 = require("./constants");
const type_guards_1 = require("./type-guards");
class HttpApiBinding extends _1.BaseApiBinding {
    constructor(urlSafeName, api, integrationTarget) {
        super(urlSafeName, api, integrationTarget);
        this.apiType = constants_1.AwsApiType.HTTP;
        this.routes = [];
        this.authorizedPrincipalArns = [];
        this.path = path_1.join('/', this.urlSafeName);
        this.route = api.awsApiGatewayHTTPApi.addRoutes({
            authorizer: new aws_apigatewayv2_authorizers_alpha_1.HttpIamAuthorizer(),
            methods: [aws_events_1.HttpMethod.POST],
            integration: this.makeIntegrationForIntegrationTarget(),
            path: this.path,
        })[0];
        this.method = aws_events_1.HttpMethod.POST;
    }
    /**
     *
     *
     * Note: JSII complains if we make the return type HTTPRouteIntegration,
     * ostensibly because of its restrictions on Generics.
     */
    makeIntegrationForIntegrationTarget() {
        if (type_guards_1.isLambdaIntegrationTarget(this.integrationTarget)) {
            return new aws_apigatewayv2_integrations_alpha_1.HttpLambdaIntegration(`${this.urlSafeName}LambdaIntegration`, this.integrationTarget.handler);
        }
        else {
            throw new Error('Only Lambda integrations are supported right now');
        }
    }
    authorizePrincipalArn(principalArn) {
        this.authorizedPrincipalArns.push(principalArn);
        this.routes.forEach((r) => {
            r.grantInvoke(new aws_iam_1.ArnPrincipal(principalArn));
        });
    }
}
exports.HttpApiBinding = HttpApiBinding;
_a = JSII_RTTI_SYMBOL_1;
HttpApiBinding[_a] = { fqn: "control-broker.HttpApiBinding", version: "0.12.0" };
//# sourceMappingURL=data:application/json;base64,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