import { HttpRoute, HttpRouteIntegration } from '@aws-cdk/aws-apigatewayv2-alpha';
import { BaseApiBinding } from '.';
import { Api } from '../api';
import { IIntegrationTarget } from '../interfaces/integration-target-interface';
import { AwsApiType } from './constants';
export interface HttpApiBindingAddToApiOptions {
}
export declare class HttpApiBinding extends BaseApiBinding<HttpRouteIntegration> {
    readonly apiType: AwsApiType;
    protected routes: HttpRoute[];
    protected authorizedPrincipalArns: string[];
    readonly route: HttpRoute;
    readonly path: string;
    readonly method: string;
    constructor(urlSafeName: string, api: Api, integrationTarget: IIntegrationTarget);
    /**
     *
     *
     * Note: JSII complains if we make the return type HTTPRouteIntegration,
     * ostensibly because of its restrictions on Generics.
     */
    protected makeIntegrationForIntegrationTarget(): any;
    authorizePrincipalArn(principalArn: string): void;
}
