"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseApiBinding = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const _1 = require(".");
/**
 * Base class for an API Binding, which attaches an integration to an API and
 * authorizes principals to invoke the integration via the API attachment.
 *
 * Defined abstractly since there are different types of APIs to attach integrations with
 * and different principals to allow.
 */
class BaseApiBinding {
    /**
     *
     * This should create an invocable URL with the given integration.
     *
     * @param urlSafeName A name suitable for use in an integration's URL. Can contain slashes.
     * @param api The API to bind to.
     * @param integrationTarget The integration target to bind to the API via an integration.
     */
    constructor(urlSafeName, api, integrationTarget) {
        this.urlSafeName = urlSafeName;
        this.api = api;
        this.integrationTarget = integrationTarget;
        this.makeIntegrationForIntegrationTarget();
    }
    get url() {
        if (this.apiType === _1.AwsApiType.HTTP) {
            if (this.api.awsApiGatewayHTTPApi.url === undefined) {
                throw new Error('No default stage defined for the HTTP API');
            }
            return path_1.join(this.api.awsApiGatewayHTTPApi.url, this.path);
        }
        else if (this.apiType === _1.AwsApiType.REST) {
            return this.api.awsApiGatewayRestApi.urlForPath(this.path);
        }
        else {
            throw new Error(`API type ${this.apiType} is not yet supported`);
        }
    }
}
exports.BaseApiBinding = BaseApiBinding;
_a = JSII_RTTI_SYMBOL_1;
BaseApiBinding[_a] = { fqn: "control-broker.BaseApiBinding", version: "0.12.0" };
//# sourceMappingURL=data:application/json;base64,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