import { AwsApiType } from '.';
import { Api } from '../api';
import { IIntegrationTarget } from '../interfaces/integration-target-interface';
export interface BaseApiBindingProps<IntegrationType> {
    readonly integration: IntegrationType;
}
/**
 * Base class for an API Binding, which attaches an integration to an API and
 * authorizes principals to invoke the integration via the API attachment.
 *
 * Defined abstractly since there are different types of APIs to attach integrations with
 * and different principals to allow.
 */
export declare abstract class BaseApiBinding<IntegrationType> {
    readonly urlSafeName: string;
    readonly api: Api;
    readonly integrationTarget: IIntegrationTarget;
    abstract readonly apiType: AwsApiType;
    abstract readonly method: string;
    abstract readonly path: string;
    /**
     *
     * This should create an invocable URL with the given integration.
     *
     * @param urlSafeName A name suitable for use in an integration's URL. Can contain slashes.
     * @param api The API to bind to.
     * @param integrationTarget The integration target to bind to the API via an integration.
     */
    constructor(urlSafeName: string, api: Api, integrationTarget: IIntegrationTarget);
    /**
     * Give permission to a principal to call this API using this binding.
     *
     * This should be called after the binding has been added to all APIs.
     *
     * @param principalArn Principal to give calling permissions to.
     */
    abstract authorizePrincipalArn(principalArn: string): void;
    get url(): string;
    /***
     * Return an integration built for the integration target.
     */
    protected abstract makeIntegrationForIntegrationTarget(): IntegrationType;
}
