## Getting Started

When you first clone the repo, the first command to run is `yarn install`. If you don't have [`yarn`](https://yarnpkg.com/), install that first.

Next, run `npx projen build` to run your first build, tests, etc.

## `projen`

We use `projen`, and in particular the [`projen` AWS CDK Construct Library project](https://projen.io/awscdk-construct.html) to configure this project in a way that's compatible with [the `constructs.dev` Construct Hub](https://constructs.dev).

This has significant consequences for how you should update the dependencies, build scripts, etc. for this project.

### Using `projen` for configuration changes

Please do not edit `package.json` or any other file with a "Generated by projen." message in it. Instead, edit `.projenrc.js` and run `npx projen` to generate those files.

`projen` allows us to easily stay up to date with project configuration from the CDK team and to comply with [Construct Hub](https://constructs.dev/) requirements.

See [A Beginner's Guide to Create AWS CDK Construct Library with Projen](https://dev.to/aws-builders/a-beginner-s-guide-to-create-aws-cdk-construct-library-with-projen-5eh4) and the [Construct Hub contribution documentation](https://constructs.dev/contribute) for more information.