# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class NodeResponse(Model):
    """NodeResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: long
    :param receiver:
    :type receiver: ~smartdiagnostics_sdk.models.ReceiverChild
    :param location: Required.
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    :param corporation: Required.
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param serial_number: Required.
    :type serial_number: str
    :param nickname:
    :type nickname: str
    :param firmware_version:
    :type firmware_version: str
    :param node_type_code: Required. Possible values include: 'Invalid',
     'KcfFlow', 'KcfPressureVoltage', 'KcfPressureCurrent', 'KcfPower',
     'KcfVibration', 'KcfVibrationV1', 'KcfVoltage', 'KcfCurrent',
     'KcfAtoDVoltage', 'KcfAtoDCurrent', 'KcfOilQuality', 'Generic',
     'KcfAgnostic', 'KcfHumidity', 'KcfExtendedTemperatureVibration',
     'KcfHubVibrationV1'
    :type node_type_code: str or ~smartdiagnostics_sdk.models.enum
    :param active: Required.
    :type active: bool
    :param created: Required.
    :type created: datetime
    :param updated: Required.
    :type updated: datetime
    :param battery_voltage:
    :type battery_voltage: float
    :param burst_success_rate:
    :type burst_success_rate: float
    :param is_online:
    :type is_online: bool
    :param last_update_time:
    :type last_update_time: datetime
    :param packet_success_rate:
    :type packet_success_rate: float
    :param temperature:
    :type temperature: float
    :param wireless_efficiency:
    :type wireless_efficiency: float
    """

    _validation = {
        'id': {'required': True},
        'location': {'required': True},
        'corporation': {'required': True},
        'serial_number': {'required': True, 'max_length': 8},
        'nickname': {'max_length': 30},
        'node_type_code': {'required': True},
        'active': {'required': True},
        'created': {'required': True},
        'updated': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'long'},
        'receiver': {'key': 'Receiver', 'type': 'ReceiverChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'serial_number': {'key': 'SerialNumber', 'type': 'str'},
        'nickname': {'key': 'Nickname', 'type': 'str'},
        'firmware_version': {'key': 'FirmwareVersion', 'type': 'str'},
        'node_type_code': {'key': 'NodeTypeCode', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'updated': {'key': 'Updated', 'type': 'iso-8601'},
        'battery_voltage': {'key': 'BatteryVoltage', 'type': 'float'},
        'burst_success_rate': {'key': 'BurstSuccessRate', 'type': 'float'},
        'is_online': {'key': 'IsOnline', 'type': 'bool'},
        'last_update_time': {'key': 'LastUpdateTime', 'type': 'iso-8601'},
        'packet_success_rate': {'key': 'PacketSuccessRate', 'type': 'float'},
        'temperature': {'key': 'Temperature', 'type': 'float'},
        'wireless_efficiency': {'key': 'WirelessEfficiency', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(NodeResponse, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.receiver = kwargs.get('receiver', None)
        self.location = kwargs.get('location', None)
        self.corporation = kwargs.get('corporation', None)
        self.serial_number = kwargs.get('serial_number', None)
        self.nickname = kwargs.get('nickname', None)
        self.firmware_version = kwargs.get('firmware_version', None)
        self.node_type_code = kwargs.get('node_type_code', None)
        self.active = kwargs.get('active', None)
        self.created = kwargs.get('created', None)
        self.updated = kwargs.get('updated', None)
        self.battery_voltage = kwargs.get('battery_voltage', None)
        self.burst_success_rate = kwargs.get('burst_success_rate', None)
        self.is_online = kwargs.get('is_online', None)
        self.last_update_time = kwargs.get('last_update_time', None)
        self.packet_success_rate = kwargs.get('packet_success_rate', None)
        self.temperature = kwargs.get('temperature', None)
        self.wireless_efficiency = kwargs.get('wireless_efficiency', None)
