"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StreamEventSource = void 0;
/**
 * Use an stream as an event source for AWS Lambda.
 */
class StreamEventSource {
    constructor(props) {
        this.props = props;
    }
    enrichMappingOptions(options) {
        return {
            ...options,
            batchSize: this.props.batchSize || 100,
            bisectBatchOnError: this.props.bisectBatchOnError,
            startingPosition: this.props.startingPosition,
            maxBatchingWindow: this.props.maxBatchingWindow,
            maxRecordAge: this.props.maxRecordAge,
            retryAttempts: this.props.retryAttempts,
            parallelizationFactor: this.props.parallelizationFactor,
            onFailure: this.props.onFailure,
        };
    }
}
exports.StreamEventSource = StreamEventSource;
//# sourceMappingURL=data:application/json;base64,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