from pathlib import Path

TEST_DIR = Path(__file__).parent
INPUT_DATA_DIR = TEST_DIR / "input_data"
GENERATED_DATA_DIR = TEST_DIR / "generated_data"

DATA_NAME = "data"
JSON_PATH = INPUT_DATA_DIR / (DATA_NAME + ".json")
JSON_WITH_SCHEMA_PATH = INPUT_DATA_DIR / (DATA_NAME + "-with-schema" + ".json")
YAML_PATH = INPUT_DATA_DIR / (DATA_NAME + ".yaml")
YAML_WITH_SCHEMA_PATH = INPUT_DATA_DIR / (DATA_NAME + "-with-schema" + ".yaml")
TOML_PATH = INPUT_DATA_DIR / (DATA_NAME + ".toml")
PY_CONFIG_PATH = INPUT_DATA_DIR / (DATA_NAME + ".py")

PYPROJECT_TOML_DIR = INPUT_DATA_DIR / "pyproject"
PYPROJECT_TOML_CLEAN_DIR = PYPROJECT_TOML_DIR / "clean"
PYPROJECT_TOML_CLEAN_CONFIG_PATH = PYPROJECT_TOML_CLEAN_DIR / "pyproject.toml"
PYPROJECT_TOML_MIXED_DIR = PYPROJECT_TOML_DIR / "mixed"
PYPROJECT_TOML_MIXED_CONFIG_PATH = PYPROJECT_TOML_MIXED_DIR / "pyproject.toml"

NON_EXISTENT_NAME = "woo"
NON_EXISTENT_IN_PATH = INPUT_DATA_DIR / NON_EXISTENT_NAME
NON_EXISTENT_INPUT_JSON_PATH = INPUT_DATA_DIR / (NON_EXISTENT_NAME + ".json")
CUSTOM_CONFIG_IN_PATH = INPUT_DATA_DIR / DATA_NAME
ENV_PATH = GENERATED_DATA_DIR / ".env"

RECURSIVE_INPUT_FOLDER = INPUT_DATA_DIR / "recursive"
RECURSIVE_CONFIG_1_PATH = RECURSIVE_INPUT_FOLDER / "1" / "recursive-config.toml"
RECURSIVE_CONFIG_ROOT_PATH = RECURSIVE_INPUT_FOLDER / "recursive-config.toml"

SCHEMA_JSON_PATH = INPUT_DATA_DIR / "schema.json"

PYDANTIC_PY_CONFIG_PATH = INPUT_DATA_DIR / "pydantic_py_config.py"

if not INPUT_DATA_DIR.exists():
    INPUT_DATA_DIR.mkdir()
if not GENERATED_DATA_DIR.exists():
    GENERATED_DATA_DIR.mkdir()
