"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Grafana = void 0;
// generated by cdk8s
const cdk8s_1 = require("cdk8s");
/**
 *
 *
 * @schema Grafana
 */
class Grafana extends cdk8s_1.ApiObject {
    /**
     * Defines a "Grafana" API object
     * @param scope the scope in which to define this object
     * @param id a scope-local name for the object
     * @param props initialization props
     */
    constructor(scope, id, props) {
        super(scope, id, Grafana.manifest(props));
    }
    /**
     * Renders a Kubernetes manifest for "Grafana".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props
     */
    static manifest(props) {
        return {
            ...Grafana.GVK,
            ...props,
        };
    }
}
exports.Grafana = Grafana;
/**
 * Returns the apiVersion and kind for "Grafana"
 */
Grafana.GVK = {
    apiVersion: 'integreatly.org/v1alpha1',
    kind: 'Grafana',
};
//# sourceMappingURL=data:application/json;base64,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