"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataSource = exports.AccessType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const grafana_datasource_1 = require("./imports/grafana-datasource");
/**
 * Mode for accessing a data source.
 * @see https://grafana.com/docs/grafana/latest/administration/provisioning/#example-data-source-config-file
 */
var AccessType;
(function (AccessType) {
    /**
     * Access via proxy.
     */
    AccessType["PROXY"] = "proxy";
    /**
     * Access directly (via server or browser in UI).
     */
    AccessType["DIRECT"] = "direct";
})(AccessType = exports.AccessType || (exports.AccessType = {}));
/**
 * A Grafana data source.
 * @see https://grafana.com/docs/grafana/latest/administration/provisioning/#example-data-source-config-file
 */
class DataSource extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.name = props.name;
        new grafana_datasource_1.GrafanaDataSource(this, 'Resource', {
            metadata: {
                labels: props.labels,
                namespace: props.namespace,
            },
            spec: {
                name: props.name,
                datasources: [{
                        name: props.name,
                        type: props.type,
                        access: props.access,
                        url: props.url,
                    }],
            },
        });
    }
}
exports.DataSource = DataSource;
_a = JSII_RTTI_SYMBOL_1;
DataSource[_a] = { fqn: "cdk8s-grafana.DataSource", version: "0.1.192" };
//# sourceMappingURL=data:application/json;base64,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