'''
exceptions.py: exceptions defined by Pokapi

Authors
-------

Michael Hucka <mhucka@caltech.edu> -- Caltech Library

Copyright
---------

Copyright (c) 2021-2023 by the California Institute of Technology.  This code is
open-source software released under a 3-clause BSD license.  Please see the
file "LICENSE" for more information.
'''


# Base class.
# .............................................................................
# The base class makes it possible to use a single test to distinguish between
# exceptions generated by Pokapi and exceptions generated by something else.

class PokapiException(Exception):
    '''Base class for Pokapi exceptions.'''


# Exception classes.
# .............................................................................

class FolioError(PokapiException):
    '''Unrecoverable problem involving interactions with the FOLIO server.'''


class FolioPermissionError(PokapiException):
    '''Problem with permissions or tokens accessing the FOLIO server.'''


class DataMismatchError(PokapiException):
    '''Unrecoverable problem involving Pokapi.'''


class NotFound(PokapiException):
    '''A requested item was not found in the FOLIO server.'''
