/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.url;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.util.url.URLHandler$URLInfo;
import org.apache.ivy.util.url.URLHandlerRegistry;

public final class URLResource
implements Resource {
    private URL url;
    private boolean init = false;
    private long lastModified;
    private long contentLength;
    private boolean exists;

    public URLResource(URL uRL) {
        this.url = uRL;
    }

    public final String getName() {
        return this.url.toExternalForm();
    }

    public final Resource clone(String string) {
        try {
            return new URLResource(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("bad clone name provided: not suitable for an URLResource: " + string);
        }
    }

    public final long getLastModified() {
        if (!this.init) {
            this.init();
        }
        return this.lastModified;
    }

    private void init() {
        URLHandler$URLInfo uRLHandler$URLInfo = URLHandlerRegistry.getDefault().getURLInfo(this.url);
        this.contentLength = uRLHandler$URLInfo.getContentLength();
        this.lastModified = uRLHandler$URLInfo.getLastModified();
        this.exists = uRLHandler$URLInfo.isReachable();
        this.init = true;
    }

    public final long getContentLength() {
        if (!this.init) {
            this.init();
        }
        return this.contentLength;
    }

    public final boolean exists() {
        if (!this.init) {
            this.init();
        }
        return this.exists;
    }

    public final URL getURL() {
        return this.url;
    }

    public final String toString() {
        return this.url.toExternalForm();
    }

    public final boolean isLocal() {
        return false;
    }

    public final InputStream openStream() {
        return URLHandlerRegistry.getDefault().openStream(this.url);
    }
}

