from .packaging import *
import abc
from abc import ABC, abstractmethod
from typing import Any, Union

class InvalidHash(ValueError): ...

class StorageMethod:
    def __init__(self, packaging) -> None: ...
    def __get__(self, instance: Storage, owner): ...
    def __set__(self, instance, value) -> None: ...
    key: Any
    def __set_name__(self, owner, name) -> None: ...

class Storage(ABC, metaclass=abc.ABCMeta):
    compression: Any
    pickling: Any
    encryption: Any
    base64: Any
    def __init__(self, *, hashing: str = ..., compression: int = ..., encryption_key: Union[str, bytes] = ..., encryption_password: Union[str, bytes] = ..., encryption_seed: int = ...) -> None: ...
    @abstractmethod
    def exists(self, key: str) -> bool: ...
    @abstractmethod
    def save(self, key: str, data: bytes): ...
    @abstractmethod
    def load(self, key: str) -> bytes: ...
    @abstractmethod
    def delete(self, key: str) -> None: ...
    def hash(self, data: bytes) -> str: ...
    def push(self, data: bytes) -> str: ...
    def pop(self, key: str) -> bytes: ...
    def link(self, *markers) -> Link: ...

class Pipe(Storage):
    def __init__(self, storage, wrapper: Packaging) -> None: ...
    def __call__(self, **kwargs): ...
    def exists(self, key: str) -> bool: ...
    def save(self, key: str, data: bytes): ...
    def load(self, key: str): ...
    def delete(self, key: str): ...
    def hash(self, data: bytes) -> str: ...
    def push(self, data: bytes) -> str: ...
    def pop(self, key: str) -> bytes: ...

class Link:
    def __init__(self, *markers, storage: Storage) -> None: ...
    def exists(self) -> bool: ...
    def load(self) -> bytes: ...
    def delete(self) -> None: ...
    def hash(self, data: bytes) -> str: ...
    def push(self, data: bytes) -> str: ...
    def pop(self) -> bytes: ...
