from .core import Storage
from pathlib import Path
from typing import Union

class BridgeStorage(Storage):
    def __init__(self, src: Storage, dst: Storage, **kwargs) -> None: ...
    @property
    def src(self) -> Storage: ...
    @property
    def dst(self) -> Storage: ...
    def exists(self, key: str) -> bool: ...
    def save(self, key: str, data: bytes): ...
    def load(self, key: str) -> bytes: ...
    def delete(self, key: str) -> None: ...
    def hash(self, data: bytes) -> str: ...
    def push(self, data: bytes) -> str: ...
    def pop(self, key: str) -> bytes: ...

class DriveCacheStorage(BridgeStorage):
    def __init__(self, src: Storage, root: Union[Path, str], create: bool = ..., **kwargs) -> None: ...

class MemoryCacheStorage(BridgeStorage):
    def __init__(self, src: Storage, **kwargs) -> None: ...
