from typing import Any, Dict, Type, TypeVar, Union

import attr

from ..types import UNSET, Unset

T = TypeVar("T", bound="UserProductVersionDto")


@attr.s(auto_attribs=True)
class UserProductVersionDto:
    """ """

    display_name: Union[Unset, None, str] = UNSET

    def to_dict(self) -> Dict[str, Any]:
        display_name = self.display_name

        field_dict: Dict[str, Any] = {}
        field_dict.update({})
        if display_name is not UNSET:
            field_dict["displayName"] = display_name

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        display_name = d.pop("displayName", UNSET)

        user_product_version_dto = cls(
            display_name=display_name,
        )

        return user_product_version_dto
