# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class BlobAuditingPolicyName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DEFAULT = "default"

class BlobAuditingPolicyState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies the state of the policy. If state is Enabled, storageEndpoint or
    isAzureMonitorTargetEnabled are required.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class ColumnDataType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The column data type.
    """

    IMAGE = "image"
    TEXT = "text"
    UNIQUEIDENTIFIER = "uniqueidentifier"
    DATE = "date"
    TIME = "time"
    DATETIME2 = "datetime2"
    DATETIMEOFFSET = "datetimeoffset"
    TINYINT = "tinyint"
    SMALLINT = "smallint"
    INT = "int"
    SMALLDATETIME = "smalldatetime"
    REAL = "real"
    MONEY = "money"
    DATETIME = "datetime"
    FLOAT = "float"
    SQL_VARIANT = "sql_variant"
    NTEXT = "ntext"
    BIT = "bit"
    DECIMAL = "decimal"
    NUMERIC = "numeric"
    SMALLMONEY = "smallmoney"
    BIGINT = "bigint"
    HIERARCHYID = "hierarchyid"
    GEOMETRY = "geometry"
    GEOGRAPHY = "geography"
    VARBINARY = "varbinary"
    VARCHAR = "varchar"
    BINARY = "binary"
    CHAR = "char"
    TIMESTAMP = "timestamp"
    NVARCHAR = "nvarchar"
    NCHAR = "nchar"
    XML = "xml"
    SYSNAME = "sysname"

class ConnectionPolicyName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DEFAULT = "default"

class DataFlowComputeType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Compute type of the cluster which will execute data flow job.
    """

    GENERAL = "General"
    MEMORY_OPTIMIZED = "MemoryOptimized"
    COMPUTE_OPTIMIZED = "ComputeOptimized"

class DataMaskingFunction(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The masking function that is used for the data masking rule.
    """

    DEFAULT = "Default"
    CCN = "CCN"
    EMAIL = "Email"
    NUMBER = "Number"
    SSN = "SSN"
    TEXT = "Text"

class DataMaskingRuleState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The rule state. Used to delete a rule. To delete an existing rule, specify the schemaName,
    tableName, columnName, maskingFunction, and specify ruleState as disabled. However, if the rule
    doesn't already exist, the rule will be created with ruleState set to enabled, regardless of
    the provided value of ruleState.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class DataMaskingState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of the data masking policy.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class DataWarehouseUserActivityName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    CURRENT = "current"

class DayOfWeek(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Day of maintenance window.
    """

    SUNDAY = "Sunday"
    MONDAY = "Monday"
    TUESDAY = "Tuesday"
    WEDNESDAY = "Wednesday"
    THURSDAY = "Thursday"
    FRIDAY = "Friday"
    SATURDAY = "Saturday"

class EncryptionProtectorName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    CURRENT = "current"

class GeoBackupPolicyName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DEFAULT = "Default"

class GeoBackupPolicyState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of the geo backup policy.
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"

class IntegrationRuntimeAuthKeyName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The name of the authentication key to regenerate.
    """

    AUTH_KEY1 = "authKey1"
    AUTH_KEY2 = "authKey2"

class IntegrationRuntimeAutoUpdate(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of integration runtime auto update.
    """

    ON = "On"
    OFF = "Off"

class IntegrationRuntimeEdition(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The edition for the SSIS Integration Runtime
    """

    STANDARD = "Standard"
    ENTERPRISE = "Enterprise"

class IntegrationRuntimeEntityReferenceType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of this referenced entity.
    """

    INTEGRATION_RUNTIME_REFERENCE = "IntegrationRuntimeReference"
    LINKED_SERVICE_REFERENCE = "LinkedServiceReference"

class IntegrationRuntimeInternalChannelEncryptionMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """It is used to set the encryption mode for node-node communication channel (when more than 2
    self-hosted integration runtime nodes exist).
    """

    NOT_SET = "NotSet"
    SSL_ENCRYPTED = "SslEncrypted"
    NOT_ENCRYPTED = "NotEncrypted"

class IntegrationRuntimeLicenseType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """License type for bringing your own license scenario.
    """

    BASE_PRICE = "BasePrice"
    LICENSE_INCLUDED = "LicenseIncluded"

class IntegrationRuntimeSsisCatalogPricingTier(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The pricing tier for the catalog database. The valid values could be found in
    https://azure.microsoft.com/en-us/pricing/details/sql-database/
    """

    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"
    PREMIUM_RS = "PremiumRS"

class IntegrationRuntimeState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The state of integration runtime.
    """

    INITIAL = "Initial"
    STOPPED = "Stopped"
    STARTED = "Started"
    STARTING = "Starting"
    STOPPING = "Stopping"
    NEED_REGISTRATION = "NeedRegistration"
    ONLINE = "Online"
    LIMITED = "Limited"
    OFFLINE = "Offline"
    ACCESS_DENIED = "AccessDenied"

class IntegrationRuntimeType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of integration runtime.
    """

    MANAGED = "Managed"
    SELF_HOSTED = "SelfHosted"

class IntegrationRuntimeUpdateResult(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The result of the last integration runtime node update.
    """

    NONE = "None"
    SUCCEED = "Succeed"
    FAIL = "Fail"

class ManagedIdentitySqlControlSettingsModelPropertiesGrantSqlControlToManagedIdentityActualState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Actual state
    """

    ENABLING = "Enabling"
    ENABLED = "Enabled"
    DISABLING = "Disabling"
    DISABLED = "Disabled"
    UNKNOWN = "Unknown"

class ManagedIdentitySqlControlSettingsModelPropertiesGrantSqlControlToManagedIdentityDesiredState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Desired state
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class ManagedIntegrationRuntimeNodeStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The managed integration runtime node status.
    """

    STARTING = "Starting"
    AVAILABLE = "Available"
    RECYCLING = "Recycling"
    UNAVAILABLE = "Unavailable"

class ManagementOperationState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The operation state.
    """

    PENDING = "Pending"
    IN_PROGRESS = "InProgress"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCEL_IN_PROGRESS = "CancelInProgress"
    CANCELLED = "Cancelled"

class NodeSize(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The level of compute power that each node in the Big Data pool has.
    """

    NONE = "None"
    SMALL = "Small"
    MEDIUM = "Medium"
    LARGE = "Large"
    X_LARGE = "XLarge"
    XX_LARGE = "XXLarge"
    XXX_LARGE = "XXXLarge"

class NodeSizeFamily(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The kind of nodes that the Big Data pool provides.
    """

    NONE = "None"
    MEMORY_OPTIMIZED = "MemoryOptimized"

class OperationStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Operation status
    """

    IN_PROGRESS = "InProgress"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"

class ProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Resource provisioning state
    """

    PROVISIONING = "Provisioning"
    SUCCEEDED = "Succeeded"
    DELETING = "Deleting"
    FAILED = "Failed"
    DELETE_ERROR = "DeleteError"

class QueryAggregationFunction(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The function that is used to aggregate each query's metrics.
    """

    MIN = "min"
    MAX = "max"
    AVG = "avg"
    SUM = "sum"

class QueryExecutionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The execution type that is used to filter the query instances that are returned.
    """

    ANY = "any"
    REGULAR = "regular"
    IRREGULAR = "irregular"
    ABORTED = "aborted"
    EXCEPTION = "exception"

class QueryMetricUnit(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The unit of measurement
    """

    PERCENTAGE = "percentage"
    KB = "KB"
    MICROSECONDS = "microseconds"

class QueryObservedMetricType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of metric to use for ordering the top metrics.
    """

    CPU = "cpu"
    IO = "io"
    LOGIO = "logio"
    DURATION = "duration"
    EXECUTION_COUNT = "executionCount"

class RecommendedSensitivityLabelUpdateKind(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    ENABLE = "enable"
    DISABLE = "disable"

class ReplicationRole(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The role of the Sql pool in the replication link.
    """

    PRIMARY = "Primary"
    SECONDARY = "Secondary"
    NON_READABLE_SECONDARY = "NonReadableSecondary"
    SOURCE = "Source"
    COPY = "Copy"

class ReplicationState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The replication state for the replication link.
    """

    PENDING = "PENDING"
    SEEDING = "SEEDING"
    CATCH_UP = "CATCH_UP"
    SUSPENDED = "SUSPENDED"

class ResourceIdentityType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of managed identity for the workspace
    """

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"

class RestorePointType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of restore point
    """

    CONTINUOUS = "CONTINUOUS"
    DISCRETE = "DISCRETE"

class SecurityAlertPolicyName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DEFAULT = "default"

class SecurityAlertPolicyNameAutoGenerated(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DEFAULT = "Default"

class SecurityAlertPolicyState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies the state of the policy, whether it is enabled or disabled or a policy has not been
    applied yet on the specific Sql pool.
    """

    NEW = "New"
    ENABLED = "Enabled"
    DISABLED = "Disabled"

class SelfHostedIntegrationRuntimeNodeStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Status of the integration runtime node.
    """

    NEED_REGISTRATION = "NeedRegistration"
    ONLINE = "Online"
    LIMITED = "Limited"
    OFFLINE = "Offline"
    UPGRADING = "Upgrading"
    INITIALIZING = "Initializing"
    INITIALIZE_FAILED = "InitializeFailed"

class SensitivityLabelRank(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    NONE = "None"
    LOW = "Low"
    MEDIUM = "Medium"
    HIGH = "High"
    CRITICAL = "Critical"

class SensitivityLabelSource(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    CURRENT = "current"
    RECOMMENDED = "recommended"

class SensitivityLabelUpdateKind(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    SET = "set"
    REMOVE = "remove"

class ServerKeyType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
    """

    SERVICE_MANAGED = "ServiceManaged"
    AZURE_KEY_VAULT = "AzureKeyVault"

class SsisObjectMetadataType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of SSIS object metadata.
    """

    FOLDER = "Folder"
    PROJECT = "Project"
    PACKAGE = "Package"
    ENVIRONMENT = "Environment"

class StorageAccountType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The storage account type used to store backups for this sql pool.
    """

    GRS = "GRS"
    LRS = "LRS"
    ZRS = "ZRS"

class TransparentDataEncryptionName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    CURRENT = "current"

class TransparentDataEncryptionStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The status of the database transparent data encryption.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class VulnerabilityAssessmentName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DEFAULT = "default"

class VulnerabilityAssessmentPolicyBaselineName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    MASTER = "master"
    DEFAULT = "default"

class VulnerabilityAssessmentScanState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The scan status.
    """

    PASSED = "Passed"
    FAILED = "Failed"
    FAILED_TO_RUN = "FailedToRun"
    IN_PROGRESS = "InProgress"

class VulnerabilityAssessmentScanTriggerType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The scan trigger type.
    """

    ON_DEMAND = "OnDemand"
    RECURRING = "Recurring"

class WorkspacePublicNetworkAccess(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Enable or Disable pubic network access to workspace
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"
