# Generated by Django 3.0.2 on 2020-01-29 08:36

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='GoogleExperiment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('experiment_id', models.CharField(max_length=50, unique=True)),
                ('experiment_alias', models.CharField(blank=True, max_length=30, null=True, unique=True)),
                ('active', models.BooleanField()),
            ],
        ),
        migrations.CreateModel(
            name='ExperimentVariant',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('index', models.IntegerField()),
                ('alias', models.CharField(default='', max_length=50)),
                ('experiment', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='experiment_variant', to='django_google_optimize.GoogleExperiment')),
            ],
        ),
        migrations.CreateModel(
            name='ExperimentCookie',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('active_variant_index', models.IntegerField(help_text='Overrides or adds the cookie and sets the active variant for this experiment\nNOTE: ONLY WORKS IN DEBUG MODE')),
                ('active', models.BooleanField()),
                ('experiment', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='experiment_cookie', to='django_google_optimize.GoogleExperiment')),
            ],
        ),
        migrations.AddConstraint(
            model_name='experimentvariant',
            constraint=models.UniqueConstraint(fields=('alias', 'experiment'), name='Can not have the same alias within an experiment_variant'),
        ),
        migrations.AddConstraint(
            model_name='experimentvariant',
            constraint=models.UniqueConstraint(fields=('index', 'experiment'), name='Can not have the same index within an experiment_variant'),
        ),
    ]
