# packaging tutorial

This is a tutorial on setting up python packages for PyPi. Steps were learned from:
[Publishing (Perfect) Python Packages on PyPi](https://www.youtube.com/watch?v=GIF3LaRqgXo&t=1281s)

# Installation

# Executable function
 
def say_hello():
    print('Hello World')
    
name = input('What is your name?\n')
print ('Hi, %s.' % name)

# Notes

1)	From the folder level with setup.py : **python setup.py sdist bdist_wheel**
    a.	Builds a wheel that is appropriate to upload to PyPi
    b. The name used in the setup.py file is added. This was a point of confusion for me. **this name is what you pip install not necessarily the name of the pythjon code that will be imported**
2)	From the folder level with setup.py : **pip install –e .**
    a.	**installs it locally**. Tests packaging and makes it useful to your system.
    b.	The ‘–e’ allows it to link to the code you are working on rather than building copies . The ‘ .’ means install in the current directory. Everytime you change the setup.py file you need to run this
    c. The name used in the setup.py file is added. This was a point of confusion for me
3)	Test it:
    a.	from python environment in any folder **from hellototi import say_hello**
        i.	**‘hellototi’** is the python module
        ii.	The name ‘hellototiname’ is from setup.py -> name=’hellototiname’. It is the name of the python script in the src folder. Within this script is the function say_hello
4)	Remove excessive files with gitignore.io
5)	Pip install twine
    a.	Twine upload dist/*

# Folder structure
packaging_tutorial
|-LICENSE.txt         **MIT**
|-README.md           **edited in markdown**
|-setup.py            **name=PyPipackaging, package=src, python module=hellototi**
|-src
    |-hellototi.py    **contains a function called say_hello()**
    |-__init__.py     ** empty**
