"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.filter = exports.isEmpty = exports.ConfigurationMapper = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const toml_1 = require("@iarna/toml");
const param_case_1 = require("param-case");
const pascal_case_1 = require("pascal-case");
const snake_case_1 = require("snake-case");
class ConfigurationMapper {
    constructor(props) {
        this.props = props;
    }
    static withDefaults(props) {
        const { globalConfiguration, runnersConfiguration } = props;
        return new ConfigurationMapper({
            globalConfiguration: {
                concurrent: 10,
                checkInterval: 0,
                logFormat: "runner",
                logLevel: "info",
                ...globalConfiguration,
            },
            runnersConfiguration: runnersConfiguration.map((item) => {
                var _b, _c, _d, _e, _f;
                return {
                    url: "https://gitlab.com",
                    limit: 10,
                    outputLimit: 52428800,
                    executor: "docker+machine",
                    environment: ["DOCKER_DRIVER=overlay2", "DOCKER_TLS_CERTDIR=/certs"],
                    ...item,
                    docker: {
                        tlsVerify: false,
                        image: "docker:19.03.5",
                        privileged: true,
                        capAdd: ["CAP_SYS_ADMIN"],
                        waitForServicesTimeout: 300,
                        disableCache: false,
                        volumes: ["/certs/client", "/cache"],
                        shmSize: 0,
                        ...item.docker,
                    },
                    machine: {
                        idleCount: 0,
                        idleTime: 300,
                        maxBuilds: 20,
                        machineDriver: "amazonec2",
                        machineName: "gitlab-runner-%s",
                        ...item.machine,
                        machineOptions: {
                            requestSpotInstance: true,
                            spotPrice: 0.03,
                            ...(_b = item.machine) === null || _b === void 0 ? void 0 : _b.machineOptions,
                        },
                        autoscaling: ((_c = item.machine) === null || _c === void 0 ? void 0 : _c.autoscaling) ? (_d = item.machine) === null || _d === void 0 ? void 0 : _d.autoscaling : [
                            {
                                periods: ["* * 7-22 * * mon-fri *"],
                                idleCount: 1,
                                idleTime: 1800,
                                timezone: "Etc/UTC",
                            },
                        ],
                    },
                    cache: ((_e = item.cache) === null || _e === void 0 ? void 0 : _e.s3) && Object.keys((_f = item.cache) === null || _f === void 0 ? void 0 : _f.s3).length
                        ? {
                            type: "s3",
                            shared: true,
                            ...item.cache,
                        }
                        : undefined,
                };
            }),
        });
    }
    static fromProps(props) {
        return new ConfigurationMapper(props);
    }
    toToml() {
        return toml_1.stringify(this._toJsonMap());
    }
    /**
     * @internal
     */
    _toJsonMap() {
        var _b, _c, _d, _e, _f, _g;
        const { globalConfiguration, runnersConfiguration } = this.props;
        const result = toJsonMap(globalConfiguration, snake_case_1.snakeCase);
        result.runners = [];
        for (const config of runnersConfiguration) {
            const runner = toJsonMap(config, snake_case_1.snakeCase);
            // Fix naming convention inconsistencies
            runner["tls-ca-file"] = runner.tls_ca_file;
            delete runner.tls_ca_file;
            runner["tls-cert-file"] = runner.tls_cert_file;
            delete runner.tls_ca_file;
            runner["tls-key-file"] = runner.tls_key_file;
            delete runner.tls_ca_file;
            if (config.docker) {
                runner.docker = toJsonMap(config.docker, snake_case_1.snakeCase);
            }
            runner.machine = toJsonMap(config.machine, pascal_case_1.pascalCase);
            if ((_b = config.machine) === null || _b === void 0 ? void 0 : _b.machineOptions) {
                runner.machine.MachineOptions = this._mapMachineOptions((_c = config.machine) === null || _c === void 0 ? void 0 : _c.machineOptions);
            }
            if ((_e = (_d = config.machine) === null || _d === void 0 ? void 0 : _d.autoscaling) === null || _e === void 0 ? void 0 : _e.length) {
                runner.machine.autoscaling = (_f = config.machine) === null || _f === void 0 ? void 0 : _f.autoscaling.map((autoscaling) => toJsonMap(autoscaling, pascal_case_1.pascalCase));
            }
            delete runner.machine.Autoscaling;
            if (((_g = config === null || config === void 0 ? void 0 : config.cache) === null || _g === void 0 ? void 0 : _g.s3) && Object.keys(config.cache.s3).length) {
                runner.cache = toJsonMap(config.cache, pascal_case_1.pascalCase);
                runner.cache.s3 = toJsonMap(config.cache.s3, pascal_case_1.pascalCase);
                delete runner.cache.s3;
            }
            else {
                delete runner.cache;
            }
            result.runners.push(runner);
        }
        return filter(result, (item) => !isEmpty(item));
    }
    _mapMachineOptions(machineOptions) {
        return toProperties(machineOptions, (key) => `amazonec2-${param_case_1.paramCase(key)}`);
    }
}
exports.ConfigurationMapper = ConfigurationMapper;
_a = JSII_RTTI_SYMBOL_1;
ConfigurationMapper[_a] = { fqn: "@pepperize/cdk-autoscaling-gitlab-runner.ConfigurationMapper", version: "0.1.43" };
/**
 * Transforms configuration objects to JsonMap. Pass an inflector function to transform object keys.
 *
 * @param configuration
 * @param inflector A function to transform the object key
 */
function toJsonMap(configuration, inflector) {
    const result = {};
    for (const key in configuration) {
        const value = configuration[key];
        if (value === undefined) {
            continue;
        }
        result[inflector(key)] = value;
    }
    return result;
}
/**
 * Transforms configuration objects to a property array. Pass an inflector function to transform object keys.
 *
 * @param configuration
 * @param inflector A function to transform the object key
 * @example
 * // returns ["foo=bar"]
 * toProperties({foo: "bar", (s) => s});
 */
function toProperties(configuration, inflector) {
    const result = [];
    for (const key in configuration) {
        const value = configuration[key];
        if (value === undefined) {
            continue;
        }
        result.push(`${inflector(key)}=${value}`);
    }
    return result;
}
function isEmpty(subject) {
    if (Array.isArray(subject)) {
        return !subject.length;
    }
    if (typeof subject === "object" && !(subject instanceof Date)) {
        return !Object.keys(subject).length;
    }
    if (subject === undefined) {
        return true;
    }
    if (subject === null) {
        return true;
    }
    return false;
}
exports.isEmpty = isEmpty;
function filter(subject, predicate) {
    if (Array.isArray(subject)) {
        const result = [];
        subject.forEach((element) => {
            const filtered = filter(element, predicate);
            if (predicate.call(subject, filtered)) {
                result.push(filtered);
            }
        });
        return result;
    }
    if (typeof subject === "object" && !(subject instanceof Date)) {
        const result = {};
        for (const key in subject) {
            const value = subject[key];
            const filtered = filter(value, predicate);
            if (predicate.call(subject, filtered)) {
                result[key] = filtered;
            }
        }
        return result;
    }
    return subject;
}
exports.filter = filter;
//# sourceMappingURL=data:application/json;base64,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