# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AccessUrlsResponse',
    'AllowedKeyTypeResponse',
    'AuditConfigResponse',
    'AuditLogConfigResponse',
    'BindingResponse',
    'CaOptionsResponse',
    'CertificateConfigResponse',
    'CertificateDescriptionResponse',
    'CertificateExtensionConstraintsResponse',
    'CertificateFingerprintResponse',
    'CertificateIdentityConstraintsResponse',
    'EcKeyTypeResponse',
    'ExprResponse',
    'ExtendedKeyUsageOptionsResponse',
    'IssuanceModesResponse',
    'IssuancePolicyResponse',
    'KeyIdResponse',
    'KeyUsageOptionsResponse',
    'KeyUsageResponse',
    'KeyVersionSpecResponse',
    'ObjectIdResponse',
    'PublicKeyResponse',
    'PublishingOptionsResponse',
    'RevocationDetailsResponse',
    'RsaKeyTypeResponse',
    'SubjectAltNamesResponse',
    'SubjectConfigResponse',
    'SubjectDescriptionResponse',
    'SubjectResponse',
    'SubordinateConfigChainResponse',
    'SubordinateConfigResponse',
    'X509ExtensionResponse',
    'X509ParametersResponse',
]

@pulumi.output_type
class AccessUrlsResponse(dict):
    """
    URLs where a CertificateAuthority will publish content.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCertificateAccessUrl":
            suggest = "ca_certificate_access_url"
        elif key == "crlAccessUrls":
            suggest = "crl_access_urls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccessUrlsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccessUrlsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccessUrlsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_certificate_access_url: str,
                 crl_access_urls: Sequence[str]):
        """
        URLs where a CertificateAuthority will publish content.
        :param str ca_certificate_access_url: The URL where this CertificateAuthority's CA certificate is published. This will only be set for CAs that have been activated.
        :param Sequence[str] crl_access_urls: The URLs where this CertificateAuthority's CRLs are published. This will only be set for CAs that have been activated.
        """
        pulumi.set(__self__, "ca_certificate_access_url", ca_certificate_access_url)
        pulumi.set(__self__, "crl_access_urls", crl_access_urls)

    @property
    @pulumi.getter(name="caCertificateAccessUrl")
    def ca_certificate_access_url(self) -> str:
        """
        The URL where this CertificateAuthority's CA certificate is published. This will only be set for CAs that have been activated.
        """
        return pulumi.get(self, "ca_certificate_access_url")

    @property
    @pulumi.getter(name="crlAccessUrls")
    def crl_access_urls(self) -> Sequence[str]:
        """
        The URLs where this CertificateAuthority's CRLs are published. This will only be set for CAs that have been activated.
        """
        return pulumi.get(self, "crl_access_urls")


@pulumi.output_type
class AllowedKeyTypeResponse(dict):
    """
    Describes a "type" of key that may be used in a Certificate issued from a CaPool. Note that a single AllowedKeyType may refer to either a fully-qualified key algorithm, such as RSA 4096, or a family of key algorithms, such as any RSA key.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ellipticCurve":
            suggest = "elliptic_curve"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AllowedKeyTypeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AllowedKeyTypeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AllowedKeyTypeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 elliptic_curve: 'outputs.EcKeyTypeResponse',
                 rsa: 'outputs.RsaKeyTypeResponse'):
        """
        Describes a "type" of key that may be used in a Certificate issued from a CaPool. Note that a single AllowedKeyType may refer to either a fully-qualified key algorithm, such as RSA 4096, or a family of key algorithms, such as any RSA key.
        :param 'EcKeyTypeResponse' elliptic_curve: Represents an allowed Elliptic Curve key type.
        :param 'RsaKeyTypeResponse' rsa: Represents an allowed RSA key type.
        """
        pulumi.set(__self__, "elliptic_curve", elliptic_curve)
        pulumi.set(__self__, "rsa", rsa)

    @property
    @pulumi.getter(name="ellipticCurve")
    def elliptic_curve(self) -> 'outputs.EcKeyTypeResponse':
        """
        Represents an allowed Elliptic Curve key type.
        """
        return pulumi.get(self, "elliptic_curve")

    @property
    @pulumi.getter
    def rsa(self) -> 'outputs.RsaKeyTypeResponse':
        """
        Represents an allowed RSA key type.
        """
        return pulumi.get(self, "rsa")


@pulumi.output_type
class AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param Sequence['AuditLogConfigResponse'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class CaOptionsResponse(dict):
    """
    Describes values that are relevant in a CA certificate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isCa":
            suggest = "is_ca"
        elif key == "maxIssuerPathLength":
            suggest = "max_issuer_path_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CaOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CaOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CaOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_ca: bool,
                 max_issuer_path_length: int):
        """
        Describes values that are relevant in a CA certificate.
        :param bool is_ca: Optional. Refers to the "CA" X.509 extension, which is a boolean value. When this value is missing, the extension will be omitted from the CA certificate.
        :param int max_issuer_path_length: Optional. Refers to the path length restriction X.509 extension. For a CA certificate, this value describes the depth of subordinate CA certificates that are allowed. If this value is less than 0, the request will fail. If this value is missing, the max path length will be omitted from the CA certificate.
        """
        pulumi.set(__self__, "is_ca", is_ca)
        pulumi.set(__self__, "max_issuer_path_length", max_issuer_path_length)

    @property
    @pulumi.getter(name="isCa")
    def is_ca(self) -> bool:
        """
        Optional. Refers to the "CA" X.509 extension, which is a boolean value. When this value is missing, the extension will be omitted from the CA certificate.
        """
        return pulumi.get(self, "is_ca")

    @property
    @pulumi.getter(name="maxIssuerPathLength")
    def max_issuer_path_length(self) -> int:
        """
        Optional. Refers to the path length restriction X.509 extension. For a CA certificate, this value describes the depth of subordinate CA certificates that are allowed. If this value is less than 0, the request will fail. If this value is missing, the max path length will be omitted from the CA certificate.
        """
        return pulumi.get(self, "max_issuer_path_length")


@pulumi.output_type
class CertificateConfigResponse(dict):
    """
    A CertificateConfig describes an X.509 certificate or CSR that is to be created, as an alternative to using ASN.1.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKey":
            suggest = "public_key"
        elif key == "subjectConfig":
            suggest = "subject_config"
        elif key == "x509Config":
            suggest = "x509_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_key: 'outputs.PublicKeyResponse',
                 subject_config: 'outputs.SubjectConfigResponse',
                 x509_config: 'outputs.X509ParametersResponse'):
        """
        A CertificateConfig describes an X.509 certificate or CSR that is to be created, as an alternative to using ASN.1.
        :param 'PublicKeyResponse' public_key: Optional. The public key that corresponds to this config. This is, for example, used when issuing Certificates, but not when creating a self-signed CertificateAuthority or CertificateAuthority CSR.
        :param 'SubjectConfigResponse' subject_config: Specifies some of the values in a certificate that are related to the subject.
        :param 'X509ParametersResponse' x509_config: Describes how some of the technical X.509 fields in a certificate should be populated.
        """
        pulumi.set(__self__, "public_key", public_key)
        pulumi.set(__self__, "subject_config", subject_config)
        pulumi.set(__self__, "x509_config", x509_config)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> 'outputs.PublicKeyResponse':
        """
        Optional. The public key that corresponds to this config. This is, for example, used when issuing Certificates, but not when creating a self-signed CertificateAuthority or CertificateAuthority CSR.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="subjectConfig")
    def subject_config(self) -> 'outputs.SubjectConfigResponse':
        """
        Specifies some of the values in a certificate that are related to the subject.
        """
        return pulumi.get(self, "subject_config")

    @property
    @pulumi.getter(name="x509Config")
    def x509_config(self) -> 'outputs.X509ParametersResponse':
        """
        Describes how some of the technical X.509 fields in a certificate should be populated.
        """
        return pulumi.get(self, "x509_config")


@pulumi.output_type
class CertificateDescriptionResponse(dict):
    """
    A CertificateDescription describes an X.509 certificate or CSR that has been issued, as an alternative to using ASN.1 / X.509.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aiaIssuingCertificateUrls":
            suggest = "aia_issuing_certificate_urls"
        elif key == "authorityKeyId":
            suggest = "authority_key_id"
        elif key == "certFingerprint":
            suggest = "cert_fingerprint"
        elif key == "crlDistributionPoints":
            suggest = "crl_distribution_points"
        elif key == "publicKey":
            suggest = "public_key"
        elif key == "subjectDescription":
            suggest = "subject_description"
        elif key == "subjectKeyId":
            suggest = "subject_key_id"
        elif key == "x509Description":
            suggest = "x509_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aia_issuing_certificate_urls: Sequence[str],
                 authority_key_id: 'outputs.KeyIdResponse',
                 cert_fingerprint: 'outputs.CertificateFingerprintResponse',
                 crl_distribution_points: Sequence[str],
                 public_key: 'outputs.PublicKeyResponse',
                 subject_description: 'outputs.SubjectDescriptionResponse',
                 subject_key_id: 'outputs.KeyIdResponse',
                 x509_description: 'outputs.X509ParametersResponse'):
        """
        A CertificateDescription describes an X.509 certificate or CSR that has been issued, as an alternative to using ASN.1 / X.509.
        :param Sequence[str] aia_issuing_certificate_urls: Describes lists of issuer CA certificate URLs that appear in the "Authority Information Access" extension in the certificate.
        :param 'KeyIdResponse' authority_key_id: Identifies the subject_key_id of the parent certificate, per https://tools.ietf.org/html/rfc5280#section-4.2.1.1
        :param 'CertificateFingerprintResponse' cert_fingerprint: The hash of the x.509 certificate.
        :param Sequence[str] crl_distribution_points: Describes a list of locations to obtain CRL information, i.e. the DistributionPoint.fullName described by https://tools.ietf.org/html/rfc5280#section-4.2.1.13
        :param 'PublicKeyResponse' public_key: The public key that corresponds to an issued certificate.
        :param 'SubjectDescriptionResponse' subject_description: Describes some of the values in a certificate that are related to the subject and lifetime.
        :param 'KeyIdResponse' subject_key_id: Provides a means of identifiying certificates that contain a particular public key, per https://tools.ietf.org/html/rfc5280#section-4.2.1.2.
        :param 'X509ParametersResponse' x509_description: Describes some of the technical X.509 fields in a certificate.
        """
        pulumi.set(__self__, "aia_issuing_certificate_urls", aia_issuing_certificate_urls)
        pulumi.set(__self__, "authority_key_id", authority_key_id)
        pulumi.set(__self__, "cert_fingerprint", cert_fingerprint)
        pulumi.set(__self__, "crl_distribution_points", crl_distribution_points)
        pulumi.set(__self__, "public_key", public_key)
        pulumi.set(__self__, "subject_description", subject_description)
        pulumi.set(__self__, "subject_key_id", subject_key_id)
        pulumi.set(__self__, "x509_description", x509_description)

    @property
    @pulumi.getter(name="aiaIssuingCertificateUrls")
    def aia_issuing_certificate_urls(self) -> Sequence[str]:
        """
        Describes lists of issuer CA certificate URLs that appear in the "Authority Information Access" extension in the certificate.
        """
        return pulumi.get(self, "aia_issuing_certificate_urls")

    @property
    @pulumi.getter(name="authorityKeyId")
    def authority_key_id(self) -> 'outputs.KeyIdResponse':
        """
        Identifies the subject_key_id of the parent certificate, per https://tools.ietf.org/html/rfc5280#section-4.2.1.1
        """
        return pulumi.get(self, "authority_key_id")

    @property
    @pulumi.getter(name="certFingerprint")
    def cert_fingerprint(self) -> 'outputs.CertificateFingerprintResponse':
        """
        The hash of the x.509 certificate.
        """
        return pulumi.get(self, "cert_fingerprint")

    @property
    @pulumi.getter(name="crlDistributionPoints")
    def crl_distribution_points(self) -> Sequence[str]:
        """
        Describes a list of locations to obtain CRL information, i.e. the DistributionPoint.fullName described by https://tools.ietf.org/html/rfc5280#section-4.2.1.13
        """
        return pulumi.get(self, "crl_distribution_points")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> 'outputs.PublicKeyResponse':
        """
        The public key that corresponds to an issued certificate.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="subjectDescription")
    def subject_description(self) -> 'outputs.SubjectDescriptionResponse':
        """
        Describes some of the values in a certificate that are related to the subject and lifetime.
        """
        return pulumi.get(self, "subject_description")

    @property
    @pulumi.getter(name="subjectKeyId")
    def subject_key_id(self) -> 'outputs.KeyIdResponse':
        """
        Provides a means of identifiying certificates that contain a particular public key, per https://tools.ietf.org/html/rfc5280#section-4.2.1.2.
        """
        return pulumi.get(self, "subject_key_id")

    @property
    @pulumi.getter(name="x509Description")
    def x509_description(self) -> 'outputs.X509ParametersResponse':
        """
        Describes some of the technical X.509 fields in a certificate.
        """
        return pulumi.get(self, "x509_description")


@pulumi.output_type
class CertificateExtensionConstraintsResponse(dict):
    """
    Describes a set of X.509 extensions that may be part of some certificate issuance controls.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalExtensions":
            suggest = "additional_extensions"
        elif key == "knownExtensions":
            suggest = "known_extensions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateExtensionConstraintsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateExtensionConstraintsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateExtensionConstraintsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_extensions: Sequence['outputs.ObjectIdResponse'],
                 known_extensions: Sequence[str]):
        """
        Describes a set of X.509 extensions that may be part of some certificate issuance controls.
        :param Sequence['ObjectIdResponse'] additional_extensions: Optional. A set of ObjectIds identifying custom X.509 extensions. Will be combined with known_extensions to determine the full set of X.509 extensions.
        :param Sequence[str] known_extensions: Optional. A set of named X.509 extensions. Will be combined with additional_extensions to determine the full set of X.509 extensions.
        """
        pulumi.set(__self__, "additional_extensions", additional_extensions)
        pulumi.set(__self__, "known_extensions", known_extensions)

    @property
    @pulumi.getter(name="additionalExtensions")
    def additional_extensions(self) -> Sequence['outputs.ObjectIdResponse']:
        """
        Optional. A set of ObjectIds identifying custom X.509 extensions. Will be combined with known_extensions to determine the full set of X.509 extensions.
        """
        return pulumi.get(self, "additional_extensions")

    @property
    @pulumi.getter(name="knownExtensions")
    def known_extensions(self) -> Sequence[str]:
        """
        Optional. A set of named X.509 extensions. Will be combined with additional_extensions to determine the full set of X.509 extensions.
        """
        return pulumi.get(self, "known_extensions")


@pulumi.output_type
class CertificateFingerprintResponse(dict):
    """
    A group of fingerprints for the x509 certificate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sha256Hash":
            suggest = "sha256_hash"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateFingerprintResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateFingerprintResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateFingerprintResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sha256_hash: str):
        """
        A group of fingerprints for the x509 certificate.
        :param str sha256_hash: The SHA 256 hash, encoded in hexadecimal, of the DER x509 certificate.
        """
        pulumi.set(__self__, "sha256_hash", sha256_hash)

    @property
    @pulumi.getter(name="sha256Hash")
    def sha256_hash(self) -> str:
        """
        The SHA 256 hash, encoded in hexadecimal, of the DER x509 certificate.
        """
        return pulumi.get(self, "sha256_hash")


@pulumi.output_type
class CertificateIdentityConstraintsResponse(dict):
    """
    Describes constraints on a Certificate's Subject and SubjectAltNames.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowSubjectAltNamesPassthrough":
            suggest = "allow_subject_alt_names_passthrough"
        elif key == "allowSubjectPassthrough":
            suggest = "allow_subject_passthrough"
        elif key == "celExpression":
            suggest = "cel_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateIdentityConstraintsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateIdentityConstraintsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateIdentityConstraintsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_subject_alt_names_passthrough: bool,
                 allow_subject_passthrough: bool,
                 cel_expression: 'outputs.ExprResponse'):
        """
        Describes constraints on a Certificate's Subject and SubjectAltNames.
        :param bool allow_subject_alt_names_passthrough: If this is true, the SubjectAltNames extension may be copied from a certificate request into the signed certificate. Otherwise, the requested SubjectAltNames will be discarded.
        :param bool allow_subject_passthrough: If this is true, the Subject field may be copied from a certificate request into the signed certificate. Otherwise, the requested Subject will be discarded.
        :param 'ExprResponse' cel_expression: Optional. A CEL expression that may be used to validate the resolved X.509 Subject and/or Subject Alternative Name before a certificate is signed. To see the full allowed syntax and some examples, see https://cloud.google.com/certificate-authority-service/docs/using-cel
        """
        pulumi.set(__self__, "allow_subject_alt_names_passthrough", allow_subject_alt_names_passthrough)
        pulumi.set(__self__, "allow_subject_passthrough", allow_subject_passthrough)
        pulumi.set(__self__, "cel_expression", cel_expression)

    @property
    @pulumi.getter(name="allowSubjectAltNamesPassthrough")
    def allow_subject_alt_names_passthrough(self) -> bool:
        """
        If this is true, the SubjectAltNames extension may be copied from a certificate request into the signed certificate. Otherwise, the requested SubjectAltNames will be discarded.
        """
        return pulumi.get(self, "allow_subject_alt_names_passthrough")

    @property
    @pulumi.getter(name="allowSubjectPassthrough")
    def allow_subject_passthrough(self) -> bool:
        """
        If this is true, the Subject field may be copied from a certificate request into the signed certificate. Otherwise, the requested Subject will be discarded.
        """
        return pulumi.get(self, "allow_subject_passthrough")

    @property
    @pulumi.getter(name="celExpression")
    def cel_expression(self) -> 'outputs.ExprResponse':
        """
        Optional. A CEL expression that may be used to validate the resolved X.509 Subject and/or Subject Alternative Name before a certificate is signed. To see the full allowed syntax and some examples, see https://cloud.google.com/certificate-authority-service/docs/using-cel
        """
        return pulumi.get(self, "cel_expression")


@pulumi.output_type
class EcKeyTypeResponse(dict):
    """
    Describes an Elliptic Curve key that may be used in a Certificate issued from a CaPool.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "signatureAlgorithm":
            suggest = "signature_algorithm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EcKeyTypeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EcKeyTypeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EcKeyTypeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 signature_algorithm: str):
        """
        Describes an Elliptic Curve key that may be used in a Certificate issued from a CaPool.
        :param str signature_algorithm: Optional. A signature algorithm that must be used. If this is omitted, any EC-based signature algorithm will be allowed.
        """
        pulumi.set(__self__, "signature_algorithm", signature_algorithm)

    @property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> str:
        """
        Optional. A signature algorithm that must be used. If this is omitted, any EC-based signature algorithm will be allowed.
        """
        return pulumi.get(self, "signature_algorithm")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class ExtendedKeyUsageOptionsResponse(dict):
    """
    KeyUsage.ExtendedKeyUsageOptions has fields that correspond to certain common OIDs that could be specified as an extended key usage value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientAuth":
            suggest = "client_auth"
        elif key == "codeSigning":
            suggest = "code_signing"
        elif key == "emailProtection":
            suggest = "email_protection"
        elif key == "ocspSigning":
            suggest = "ocsp_signing"
        elif key == "serverAuth":
            suggest = "server_auth"
        elif key == "timeStamping":
            suggest = "time_stamping"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtendedKeyUsageOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtendedKeyUsageOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtendedKeyUsageOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_auth: bool,
                 code_signing: bool,
                 email_protection: bool,
                 ocsp_signing: bool,
                 server_auth: bool,
                 time_stamping: bool):
        """
        KeyUsage.ExtendedKeyUsageOptions has fields that correspond to certain common OIDs that could be specified as an extended key usage value.
        :param bool client_auth: Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
        :param bool code_signing: Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
        :param bool email_protection: Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
        :param bool ocsp_signing: Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
        :param bool server_auth: Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
        :param bool time_stamping: Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
        """
        pulumi.set(__self__, "client_auth", client_auth)
        pulumi.set(__self__, "code_signing", code_signing)
        pulumi.set(__self__, "email_protection", email_protection)
        pulumi.set(__self__, "ocsp_signing", ocsp_signing)
        pulumi.set(__self__, "server_auth", server_auth)
        pulumi.set(__self__, "time_stamping", time_stamping)

    @property
    @pulumi.getter(name="clientAuth")
    def client_auth(self) -> bool:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
        """
        return pulumi.get(self, "client_auth")

    @property
    @pulumi.getter(name="codeSigning")
    def code_signing(self) -> bool:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
        """
        return pulumi.get(self, "code_signing")

    @property
    @pulumi.getter(name="emailProtection")
    def email_protection(self) -> bool:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
        """
        return pulumi.get(self, "email_protection")

    @property
    @pulumi.getter(name="ocspSigning")
    def ocsp_signing(self) -> bool:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
        """
        return pulumi.get(self, "ocsp_signing")

    @property
    @pulumi.getter(name="serverAuth")
    def server_auth(self) -> bool:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
        """
        return pulumi.get(self, "server_auth")

    @property
    @pulumi.getter(name="timeStamping")
    def time_stamping(self) -> bool:
        """
        Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
        """
        return pulumi.get(self, "time_stamping")


@pulumi.output_type
class IssuanceModesResponse(dict):
    """
    IssuanceModes specifies the allowed ways in which Certificates may be requested from this CaPool.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowConfigBasedIssuance":
            suggest = "allow_config_based_issuance"
        elif key == "allowCsrBasedIssuance":
            suggest = "allow_csr_based_issuance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IssuanceModesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IssuanceModesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IssuanceModesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_config_based_issuance: bool,
                 allow_csr_based_issuance: bool):
        """
        IssuanceModes specifies the allowed ways in which Certificates may be requested from this CaPool.
        :param bool allow_config_based_issuance: Optional. When true, allows callers to create Certificates by specifying a CertificateConfig.
        :param bool allow_csr_based_issuance: Optional. When true, allows callers to create Certificates by specifying a CSR.
        """
        pulumi.set(__self__, "allow_config_based_issuance", allow_config_based_issuance)
        pulumi.set(__self__, "allow_csr_based_issuance", allow_csr_based_issuance)

    @property
    @pulumi.getter(name="allowConfigBasedIssuance")
    def allow_config_based_issuance(self) -> bool:
        """
        Optional. When true, allows callers to create Certificates by specifying a CertificateConfig.
        """
        return pulumi.get(self, "allow_config_based_issuance")

    @property
    @pulumi.getter(name="allowCsrBasedIssuance")
    def allow_csr_based_issuance(self) -> bool:
        """
        Optional. When true, allows callers to create Certificates by specifying a CSR.
        """
        return pulumi.get(self, "allow_csr_based_issuance")


@pulumi.output_type
class IssuancePolicyResponse(dict):
    """
    Defines controls over all certificate issuance within a CaPool.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedIssuanceModes":
            suggest = "allowed_issuance_modes"
        elif key == "allowedKeyTypes":
            suggest = "allowed_key_types"
        elif key == "baselineValues":
            suggest = "baseline_values"
        elif key == "identityConstraints":
            suggest = "identity_constraints"
        elif key == "maximumLifetime":
            suggest = "maximum_lifetime"
        elif key == "passthroughExtensions":
            suggest = "passthrough_extensions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IssuancePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IssuancePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IssuancePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_issuance_modes: 'outputs.IssuanceModesResponse',
                 allowed_key_types: Sequence['outputs.AllowedKeyTypeResponse'],
                 baseline_values: 'outputs.X509ParametersResponse',
                 identity_constraints: 'outputs.CertificateIdentityConstraintsResponse',
                 maximum_lifetime: str,
                 passthrough_extensions: 'outputs.CertificateExtensionConstraintsResponse'):
        """
        Defines controls over all certificate issuance within a CaPool.
        :param 'IssuanceModesResponse' allowed_issuance_modes: Optional. If specified, then only methods allowed in the IssuanceModes may be used to issue Certificates.
        :param Sequence['AllowedKeyTypeResponse'] allowed_key_types: Optional. If any AllowedKeyType is specified, then the certificate request's public key must match one of the key types listed here. Otherwise, any key may be used.
        :param 'X509ParametersResponse' baseline_values: Optional. A set of X.509 values that will be applied to all certificates issued through this CaPool. If a certificate request includes conflicting values for the same properties, they will be overwritten by the values defined here. If a certificate request uses a CertificateTemplate that defines conflicting predefined_values for the same properties, the certificate issuance request will fail.
        :param 'CertificateIdentityConstraintsResponse' identity_constraints: Optional. Describes constraints on identities that may appear in Certificates issued through this CaPool. If this is omitted, then this CaPool will not add restrictions on a certificate's identity.
        :param str maximum_lifetime: Optional. The maximum lifetime allowed for issued Certificates. Note that if the issuing CertificateAuthority expires before a Certificate's requested maximum_lifetime, the effective lifetime will be explicitly truncated to match it.
        :param 'CertificateExtensionConstraintsResponse' passthrough_extensions: Optional. Describes the set of X.509 extensions that may appear in a Certificate issued through this CaPool. If a certificate request sets extensions that don't appear in the passthrough_extensions, those extensions will be dropped. If a certificate request uses a CertificateTemplate with predefined_values that don't appear here, the certificate issuance request will fail. If this is omitted, then this CaPool will not add restrictions on a certificate's X.509 extensions. These constraints do not apply to X.509 extensions set in this CaPool's baseline_values.
        """
        pulumi.set(__self__, "allowed_issuance_modes", allowed_issuance_modes)
        pulumi.set(__self__, "allowed_key_types", allowed_key_types)
        pulumi.set(__self__, "baseline_values", baseline_values)
        pulumi.set(__self__, "identity_constraints", identity_constraints)
        pulumi.set(__self__, "maximum_lifetime", maximum_lifetime)
        pulumi.set(__self__, "passthrough_extensions", passthrough_extensions)

    @property
    @pulumi.getter(name="allowedIssuanceModes")
    def allowed_issuance_modes(self) -> 'outputs.IssuanceModesResponse':
        """
        Optional. If specified, then only methods allowed in the IssuanceModes may be used to issue Certificates.
        """
        return pulumi.get(self, "allowed_issuance_modes")

    @property
    @pulumi.getter(name="allowedKeyTypes")
    def allowed_key_types(self) -> Sequence['outputs.AllowedKeyTypeResponse']:
        """
        Optional. If any AllowedKeyType is specified, then the certificate request's public key must match one of the key types listed here. Otherwise, any key may be used.
        """
        return pulumi.get(self, "allowed_key_types")

    @property
    @pulumi.getter(name="baselineValues")
    def baseline_values(self) -> 'outputs.X509ParametersResponse':
        """
        Optional. A set of X.509 values that will be applied to all certificates issued through this CaPool. If a certificate request includes conflicting values for the same properties, they will be overwritten by the values defined here. If a certificate request uses a CertificateTemplate that defines conflicting predefined_values for the same properties, the certificate issuance request will fail.
        """
        return pulumi.get(self, "baseline_values")

    @property
    @pulumi.getter(name="identityConstraints")
    def identity_constraints(self) -> 'outputs.CertificateIdentityConstraintsResponse':
        """
        Optional. Describes constraints on identities that may appear in Certificates issued through this CaPool. If this is omitted, then this CaPool will not add restrictions on a certificate's identity.
        """
        return pulumi.get(self, "identity_constraints")

    @property
    @pulumi.getter(name="maximumLifetime")
    def maximum_lifetime(self) -> str:
        """
        Optional. The maximum lifetime allowed for issued Certificates. Note that if the issuing CertificateAuthority expires before a Certificate's requested maximum_lifetime, the effective lifetime will be explicitly truncated to match it.
        """
        return pulumi.get(self, "maximum_lifetime")

    @property
    @pulumi.getter(name="passthroughExtensions")
    def passthrough_extensions(self) -> 'outputs.CertificateExtensionConstraintsResponse':
        """
        Optional. Describes the set of X.509 extensions that may appear in a Certificate issued through this CaPool. If a certificate request sets extensions that don't appear in the passthrough_extensions, those extensions will be dropped. If a certificate request uses a CertificateTemplate with predefined_values that don't appear here, the certificate issuance request will fail. If this is omitted, then this CaPool will not add restrictions on a certificate's X.509 extensions. These constraints do not apply to X.509 extensions set in this CaPool's baseline_values.
        """
        return pulumi.get(self, "passthrough_extensions")


@pulumi.output_type
class KeyIdResponse(dict):
    """
    A KeyId identifies a specific public key, usually by hashing the public key.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyIdResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyIdResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyIdResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_id: str):
        """
        A KeyId identifies a specific public key, usually by hashing the public key.
        :param str key_id: Optional. The value of this KeyId encoded in lowercase hexadecimal. This is most likely the 160 bit SHA-1 hash of the public key.
        """
        pulumi.set(__self__, "key_id", key_id)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        Optional. The value of this KeyId encoded in lowercase hexadecimal. This is most likely the 160 bit SHA-1 hash of the public key.
        """
        return pulumi.get(self, "key_id")


@pulumi.output_type
class KeyUsageOptionsResponse(dict):
    """
    KeyUsage.KeyUsageOptions corresponds to the key usage values described in https://tools.ietf.org/html/rfc5280#section-4.2.1.3.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certSign":
            suggest = "cert_sign"
        elif key == "contentCommitment":
            suggest = "content_commitment"
        elif key == "crlSign":
            suggest = "crl_sign"
        elif key == "dataEncipherment":
            suggest = "data_encipherment"
        elif key == "decipherOnly":
            suggest = "decipher_only"
        elif key == "digitalSignature":
            suggest = "digital_signature"
        elif key == "encipherOnly":
            suggest = "encipher_only"
        elif key == "keyAgreement":
            suggest = "key_agreement"
        elif key == "keyEncipherment":
            suggest = "key_encipherment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyUsageOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyUsageOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyUsageOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_sign: bool,
                 content_commitment: bool,
                 crl_sign: bool,
                 data_encipherment: bool,
                 decipher_only: bool,
                 digital_signature: bool,
                 encipher_only: bool,
                 key_agreement: bool,
                 key_encipherment: bool):
        """
        KeyUsage.KeyUsageOptions corresponds to the key usage values described in https://tools.ietf.org/html/rfc5280#section-4.2.1.3.
        :param bool cert_sign: The key may be used to sign certificates.
        :param bool content_commitment: The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
        :param bool crl_sign: The key may be used sign certificate revocation lists.
        :param bool data_encipherment: The key may be used to encipher data.
        :param bool decipher_only: The key may be used to decipher only.
        :param bool digital_signature: The key may be used for digital signatures.
        :param bool encipher_only: The key may be used to encipher only.
        :param bool key_agreement: The key may be used in a key agreement protocol.
        :param bool key_encipherment: The key may be used to encipher other keys.
        """
        pulumi.set(__self__, "cert_sign", cert_sign)
        pulumi.set(__self__, "content_commitment", content_commitment)
        pulumi.set(__self__, "crl_sign", crl_sign)
        pulumi.set(__self__, "data_encipherment", data_encipherment)
        pulumi.set(__self__, "decipher_only", decipher_only)
        pulumi.set(__self__, "digital_signature", digital_signature)
        pulumi.set(__self__, "encipher_only", encipher_only)
        pulumi.set(__self__, "key_agreement", key_agreement)
        pulumi.set(__self__, "key_encipherment", key_encipherment)

    @property
    @pulumi.getter(name="certSign")
    def cert_sign(self) -> bool:
        """
        The key may be used to sign certificates.
        """
        return pulumi.get(self, "cert_sign")

    @property
    @pulumi.getter(name="contentCommitment")
    def content_commitment(self) -> bool:
        """
        The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
        """
        return pulumi.get(self, "content_commitment")

    @property
    @pulumi.getter(name="crlSign")
    def crl_sign(self) -> bool:
        """
        The key may be used sign certificate revocation lists.
        """
        return pulumi.get(self, "crl_sign")

    @property
    @pulumi.getter(name="dataEncipherment")
    def data_encipherment(self) -> bool:
        """
        The key may be used to encipher data.
        """
        return pulumi.get(self, "data_encipherment")

    @property
    @pulumi.getter(name="decipherOnly")
    def decipher_only(self) -> bool:
        """
        The key may be used to decipher only.
        """
        return pulumi.get(self, "decipher_only")

    @property
    @pulumi.getter(name="digitalSignature")
    def digital_signature(self) -> bool:
        """
        The key may be used for digital signatures.
        """
        return pulumi.get(self, "digital_signature")

    @property
    @pulumi.getter(name="encipherOnly")
    def encipher_only(self) -> bool:
        """
        The key may be used to encipher only.
        """
        return pulumi.get(self, "encipher_only")

    @property
    @pulumi.getter(name="keyAgreement")
    def key_agreement(self) -> bool:
        """
        The key may be used in a key agreement protocol.
        """
        return pulumi.get(self, "key_agreement")

    @property
    @pulumi.getter(name="keyEncipherment")
    def key_encipherment(self) -> bool:
        """
        The key may be used to encipher other keys.
        """
        return pulumi.get(self, "key_encipherment")


@pulumi.output_type
class KeyUsageResponse(dict):
    """
    A KeyUsage describes key usage values that may appear in an X.509 certificate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseKeyUsage":
            suggest = "base_key_usage"
        elif key == "extendedKeyUsage":
            suggest = "extended_key_usage"
        elif key == "unknownExtendedKeyUsages":
            suggest = "unknown_extended_key_usages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyUsageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyUsageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyUsageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_key_usage: 'outputs.KeyUsageOptionsResponse',
                 extended_key_usage: 'outputs.ExtendedKeyUsageOptionsResponse',
                 unknown_extended_key_usages: Sequence['outputs.ObjectIdResponse']):
        """
        A KeyUsage describes key usage values that may appear in an X.509 certificate.
        :param 'KeyUsageOptionsResponse' base_key_usage: Describes high-level ways in which a key may be used.
        :param 'ExtendedKeyUsageOptionsResponse' extended_key_usage: Detailed scenarios in which a key may be used.
        :param Sequence['ObjectIdResponse'] unknown_extended_key_usages: Used to describe extended key usages that are not listed in the KeyUsage.ExtendedKeyUsageOptions message.
        """
        pulumi.set(__self__, "base_key_usage", base_key_usage)
        pulumi.set(__self__, "extended_key_usage", extended_key_usage)
        pulumi.set(__self__, "unknown_extended_key_usages", unknown_extended_key_usages)

    @property
    @pulumi.getter(name="baseKeyUsage")
    def base_key_usage(self) -> 'outputs.KeyUsageOptionsResponse':
        """
        Describes high-level ways in which a key may be used.
        """
        return pulumi.get(self, "base_key_usage")

    @property
    @pulumi.getter(name="extendedKeyUsage")
    def extended_key_usage(self) -> 'outputs.ExtendedKeyUsageOptionsResponse':
        """
        Detailed scenarios in which a key may be used.
        """
        return pulumi.get(self, "extended_key_usage")

    @property
    @pulumi.getter(name="unknownExtendedKeyUsages")
    def unknown_extended_key_usages(self) -> Sequence['outputs.ObjectIdResponse']:
        """
        Used to describe extended key usages that are not listed in the KeyUsage.ExtendedKeyUsageOptions message.
        """
        return pulumi.get(self, "unknown_extended_key_usages")


@pulumi.output_type
class KeyVersionSpecResponse(dict):
    """
    A Cloud KMS key configuration that a CertificateAuthority will use.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudKmsKeyVersion":
            suggest = "cloud_kms_key_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KeyVersionSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KeyVersionSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KeyVersionSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: str,
                 cloud_kms_key_version: str):
        """
        A Cloud KMS key configuration that a CertificateAuthority will use.
        :param str algorithm: The algorithm to use for creating a managed Cloud KMS key for a for a simplified experience. All managed keys will be have their ProtectionLevel as `HSM`.
        :param str cloud_kms_key_version: The resource name for an existing Cloud KMS CryptoKeyVersion in the format `projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*`. This option enables full flexibility in the key's capabilities and properties.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "cloud_kms_key_version", cloud_kms_key_version)

    @property
    @pulumi.getter
    def algorithm(self) -> str:
        """
        The algorithm to use for creating a managed Cloud KMS key for a for a simplified experience. All managed keys will be have their ProtectionLevel as `HSM`.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="cloudKmsKeyVersion")
    def cloud_kms_key_version(self) -> str:
        """
        The resource name for an existing Cloud KMS CryptoKeyVersion in the format `projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*`. This option enables full flexibility in the key's capabilities and properties.
        """
        return pulumi.get(self, "cloud_kms_key_version")


@pulumi.output_type
class ObjectIdResponse(dict):
    """
    An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectIdPath":
            suggest = "object_id_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectIdResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectIdResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectIdResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id_path: Sequence[int]):
        """
        An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
        :param Sequence[int] object_id_path: The parts of an OID path. The most significant parts of the path come first.
        """
        pulumi.set(__self__, "object_id_path", object_id_path)

    @property
    @pulumi.getter(name="objectIdPath")
    def object_id_path(self) -> Sequence[int]:
        """
        The parts of an OID path. The most significant parts of the path come first.
        """
        return pulumi.get(self, "object_id_path")


@pulumi.output_type
class PublicKeyResponse(dict):
    """
    A PublicKey describes a public key.
    """
    def __init__(__self__, *,
                 format: str,
                 key: str):
        """
        A PublicKey describes a public key.
        :param str format: The format of the public key.
        :param str key: A public key. The padding and encoding must match with the `KeyFormat` value specified for the `format` field.
        """
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def format(self) -> str:
        """
        The format of the public key.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        A public key. The padding and encoding must match with the `KeyFormat` value specified for the `format` field.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class PublishingOptionsResponse(dict):
    """
    Options relating to the publication of each CertificateAuthority's CA certificate and CRLs and their inclusion as extensions in issued Certificates. The options set here apply to certificates issued by any CertificateAuthority in the CaPool.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publishCaCert":
            suggest = "publish_ca_cert"
        elif key == "publishCrl":
            suggest = "publish_crl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PublishingOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PublishingOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PublishingOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 publish_ca_cert: bool,
                 publish_crl: bool):
        """
        Options relating to the publication of each CertificateAuthority's CA certificate and CRLs and their inclusion as extensions in issued Certificates. The options set here apply to certificates issued by any CertificateAuthority in the CaPool.
        :param bool publish_ca_cert: Optional. When true, publishes each CertificateAuthority's CA certificate and includes its URL in the "Authority Information Access" X.509 extension in all issued Certificates. If this is false, the CA certificate will not be published and the corresponding X.509 extension will not be written in issued certificates.
        :param bool publish_crl: Optional. When true, publishes each CertificateAuthority's CRL and includes its URL in the "CRL Distribution Points" X.509 extension in all issued Certificates. If this is false, CRLs will not be published and the corresponding X.509 extension will not be written in issued certificates. CRLs will expire 7 days from their creation. However, we will rebuild daily. CRLs are also rebuilt shortly after a certificate is revoked.
        """
        pulumi.set(__self__, "publish_ca_cert", publish_ca_cert)
        pulumi.set(__self__, "publish_crl", publish_crl)

    @property
    @pulumi.getter(name="publishCaCert")
    def publish_ca_cert(self) -> bool:
        """
        Optional. When true, publishes each CertificateAuthority's CA certificate and includes its URL in the "Authority Information Access" X.509 extension in all issued Certificates. If this is false, the CA certificate will not be published and the corresponding X.509 extension will not be written in issued certificates.
        """
        return pulumi.get(self, "publish_ca_cert")

    @property
    @pulumi.getter(name="publishCrl")
    def publish_crl(self) -> bool:
        """
        Optional. When true, publishes each CertificateAuthority's CRL and includes its URL in the "CRL Distribution Points" X.509 extension in all issued Certificates. If this is false, CRLs will not be published and the corresponding X.509 extension will not be written in issued certificates. CRLs will expire 7 days from their creation. However, we will rebuild daily. CRLs are also rebuilt shortly after a certificate is revoked.
        """
        return pulumi.get(self, "publish_crl")


@pulumi.output_type
class RevocationDetailsResponse(dict):
    """
    Describes fields that are relavent to the revocation of a Certificate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "revocationState":
            suggest = "revocation_state"
        elif key == "revocationTime":
            suggest = "revocation_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RevocationDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RevocationDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RevocationDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 revocation_state: str,
                 revocation_time: str):
        """
        Describes fields that are relavent to the revocation of a Certificate.
        :param str revocation_state: Indicates why a Certificate was revoked.
        :param str revocation_time: The time at which this Certificate was revoked.
        """
        pulumi.set(__self__, "revocation_state", revocation_state)
        pulumi.set(__self__, "revocation_time", revocation_time)

    @property
    @pulumi.getter(name="revocationState")
    def revocation_state(self) -> str:
        """
        Indicates why a Certificate was revoked.
        """
        return pulumi.get(self, "revocation_state")

    @property
    @pulumi.getter(name="revocationTime")
    def revocation_time(self) -> str:
        """
        The time at which this Certificate was revoked.
        """
        return pulumi.get(self, "revocation_time")


@pulumi.output_type
class RsaKeyTypeResponse(dict):
    """
    Describes an RSA key that may be used in a Certificate issued from a CaPool.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxModulusSize":
            suggest = "max_modulus_size"
        elif key == "minModulusSize":
            suggest = "min_modulus_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RsaKeyTypeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RsaKeyTypeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RsaKeyTypeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_modulus_size: str,
                 min_modulus_size: str):
        """
        Describes an RSA key that may be used in a Certificate issued from a CaPool.
        :param str max_modulus_size: Optional. The maximum allowed RSA modulus size (inclusive), in bits. If this is not set, or if set to zero, the service will not enforce an explicit upper bound on RSA modulus sizes.
        :param str min_modulus_size: Optional. The minimum allowed RSA modulus size (inclusive), in bits. If this is not set, or if set to zero, the service-level min RSA modulus size will continue to apply.
        """
        pulumi.set(__self__, "max_modulus_size", max_modulus_size)
        pulumi.set(__self__, "min_modulus_size", min_modulus_size)

    @property
    @pulumi.getter(name="maxModulusSize")
    def max_modulus_size(self) -> str:
        """
        Optional. The maximum allowed RSA modulus size (inclusive), in bits. If this is not set, or if set to zero, the service will not enforce an explicit upper bound on RSA modulus sizes.
        """
        return pulumi.get(self, "max_modulus_size")

    @property
    @pulumi.getter(name="minModulusSize")
    def min_modulus_size(self) -> str:
        """
        Optional. The minimum allowed RSA modulus size (inclusive), in bits. If this is not set, or if set to zero, the service-level min RSA modulus size will continue to apply.
        """
        return pulumi.get(self, "min_modulus_size")


@pulumi.output_type
class SubjectAltNamesResponse(dict):
    """
    SubjectAltNames corresponds to a more modern way of listing what the asserted identity is in a certificate (i.e., compared to the "common name" in the distinguished name).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customSans":
            suggest = "custom_sans"
        elif key == "dnsNames":
            suggest = "dns_names"
        elif key == "emailAddresses":
            suggest = "email_addresses"
        elif key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubjectAltNamesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubjectAltNamesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubjectAltNamesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_sans: Sequence['outputs.X509ExtensionResponse'],
                 dns_names: Sequence[str],
                 email_addresses: Sequence[str],
                 ip_addresses: Sequence[str],
                 uris: Sequence[str]):
        """
        SubjectAltNames corresponds to a more modern way of listing what the asserted identity is in a certificate (i.e., compared to the "common name" in the distinguished name).
        :param Sequence['X509ExtensionResponse'] custom_sans: Contains additional subject alternative name values. For each custom_san, the `value` field must contain an ASN.1 encoded UTF8String.
        :param Sequence[str] dns_names: Contains only valid, fully-qualified host names.
        :param Sequence[str] email_addresses: Contains only valid RFC 2822 E-mail addresses.
        :param Sequence[str] ip_addresses: Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
        :param Sequence[str] uris: Contains only valid RFC 3986 URIs.
        """
        pulumi.set(__self__, "custom_sans", custom_sans)
        pulumi.set(__self__, "dns_names", dns_names)
        pulumi.set(__self__, "email_addresses", email_addresses)
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "uris", uris)

    @property
    @pulumi.getter(name="customSans")
    def custom_sans(self) -> Sequence['outputs.X509ExtensionResponse']:
        """
        Contains additional subject alternative name values. For each custom_san, the `value` field must contain an ASN.1 encoded UTF8String.
        """
        return pulumi.get(self, "custom_sans")

    @property
    @pulumi.getter(name="dnsNames")
    def dns_names(self) -> Sequence[str]:
        """
        Contains only valid, fully-qualified host names.
        """
        return pulumi.get(self, "dns_names")

    @property
    @pulumi.getter(name="emailAddresses")
    def email_addresses(self) -> Sequence[str]:
        """
        Contains only valid RFC 2822 E-mail addresses.
        """
        return pulumi.get(self, "email_addresses")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[str]:
        """
        Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def uris(self) -> Sequence[str]:
        """
        Contains only valid RFC 3986 URIs.
        """
        return pulumi.get(self, "uris")


@pulumi.output_type
class SubjectConfigResponse(dict):
    """
    These values are used to create the distinguished name and subject alternative name fields in an X.509 certificate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subjectAltName":
            suggest = "subject_alt_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubjectConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubjectConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubjectConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subject: 'outputs.SubjectResponse',
                 subject_alt_name: 'outputs.SubjectAltNamesResponse'):
        """
        These values are used to create the distinguished name and subject alternative name fields in an X.509 certificate.
        :param 'SubjectResponse' subject: Contains distinguished name fields such as the common name, location and organization.
        :param 'SubjectAltNamesResponse' subject_alt_name: Optional. The subject alternative name fields.
        """
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "subject_alt_name", subject_alt_name)

    @property
    @pulumi.getter
    def subject(self) -> 'outputs.SubjectResponse':
        """
        Contains distinguished name fields such as the common name, location and organization.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter(name="subjectAltName")
    def subject_alt_name(self) -> 'outputs.SubjectAltNamesResponse':
        """
        Optional. The subject alternative name fields.
        """
        return pulumi.get(self, "subject_alt_name")


@pulumi.output_type
class SubjectDescriptionResponse(dict):
    """
    These values describe fields in an issued X.509 certificate such as the distinguished name, subject alternative names, serial number, and lifetime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hexSerialNumber":
            suggest = "hex_serial_number"
        elif key == "notAfterTime":
            suggest = "not_after_time"
        elif key == "notBeforeTime":
            suggest = "not_before_time"
        elif key == "subjectAltName":
            suggest = "subject_alt_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubjectDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubjectDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubjectDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hex_serial_number: str,
                 lifetime: str,
                 not_after_time: str,
                 not_before_time: str,
                 subject: 'outputs.SubjectResponse',
                 subject_alt_name: 'outputs.SubjectAltNamesResponse'):
        """
        These values describe fields in an issued X.509 certificate such as the distinguished name, subject alternative names, serial number, and lifetime.
        :param str hex_serial_number: The serial number encoded in lowercase hexadecimal.
        :param str lifetime: For convenience, the actual lifetime of an issued certificate.
        :param str not_after_time: The time after which the certificate is expired. Per RFC 5280, the validity period for a certificate is the period of time from not_before_time through not_after_time, inclusive. Corresponds to 'not_before_time' + 'lifetime' - 1 second.
        :param str not_before_time: The time at which the certificate becomes valid.
        :param 'SubjectResponse' subject: Contains distinguished name fields such as the common name, location and / organization.
        :param 'SubjectAltNamesResponse' subject_alt_name: The subject alternative name fields.
        """
        pulumi.set(__self__, "hex_serial_number", hex_serial_number)
        pulumi.set(__self__, "lifetime", lifetime)
        pulumi.set(__self__, "not_after_time", not_after_time)
        pulumi.set(__self__, "not_before_time", not_before_time)
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "subject_alt_name", subject_alt_name)

    @property
    @pulumi.getter(name="hexSerialNumber")
    def hex_serial_number(self) -> str:
        """
        The serial number encoded in lowercase hexadecimal.
        """
        return pulumi.get(self, "hex_serial_number")

    @property
    @pulumi.getter
    def lifetime(self) -> str:
        """
        For convenience, the actual lifetime of an issued certificate.
        """
        return pulumi.get(self, "lifetime")

    @property
    @pulumi.getter(name="notAfterTime")
    def not_after_time(self) -> str:
        """
        The time after which the certificate is expired. Per RFC 5280, the validity period for a certificate is the period of time from not_before_time through not_after_time, inclusive. Corresponds to 'not_before_time' + 'lifetime' - 1 second.
        """
        return pulumi.get(self, "not_after_time")

    @property
    @pulumi.getter(name="notBeforeTime")
    def not_before_time(self) -> str:
        """
        The time at which the certificate becomes valid.
        """
        return pulumi.get(self, "not_before_time")

    @property
    @pulumi.getter
    def subject(self) -> 'outputs.SubjectResponse':
        """
        Contains distinguished name fields such as the common name, location and / organization.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter(name="subjectAltName")
    def subject_alt_name(self) -> 'outputs.SubjectAltNamesResponse':
        """
        The subject alternative name fields.
        """
        return pulumi.get(self, "subject_alt_name")


@pulumi.output_type
class SubjectResponse(dict):
    """
    Subject describes parts of a distinguished name that, in turn, describes the subject of the certificate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "countryCode":
            suggest = "country_code"
        elif key == "organizationalUnit":
            suggest = "organizational_unit"
        elif key == "postalCode":
            suggest = "postal_code"
        elif key == "streetAddress":
            suggest = "street_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubjectResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubjectResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubjectResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 common_name: str,
                 country_code: str,
                 locality: str,
                 organization: str,
                 organizational_unit: str,
                 postal_code: str,
                 province: str,
                 street_address: str):
        """
        Subject describes parts of a distinguished name that, in turn, describes the subject of the certificate.
        :param str common_name: The "common name" of the subject.
        :param str country_code: The country code of the subject.
        :param str locality: The locality or city of the subject.
        :param str organization: The organization of the subject.
        :param str organizational_unit: The organizational_unit of the subject.
        :param str postal_code: The postal code of the subject.
        :param str province: The province, territory, or regional state of the subject.
        :param str street_address: The street address of the subject.
        """
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "country_code", country_code)
        pulumi.set(__self__, "locality", locality)
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "organizational_unit", organizational_unit)
        pulumi.set(__self__, "postal_code", postal_code)
        pulumi.set(__self__, "province", province)
        pulumi.set(__self__, "street_address", street_address)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> str:
        """
        The "common name" of the subject.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> str:
        """
        The country code of the subject.
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def locality(self) -> str:
        """
        The locality or city of the subject.
        """
        return pulumi.get(self, "locality")

    @property
    @pulumi.getter
    def organization(self) -> str:
        """
        The organization of the subject.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="organizationalUnit")
    def organizational_unit(self) -> str:
        """
        The organizational_unit of the subject.
        """
        return pulumi.get(self, "organizational_unit")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> str:
        """
        The postal code of the subject.
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def province(self) -> str:
        """
        The province, territory, or regional state of the subject.
        """
        return pulumi.get(self, "province")

    @property
    @pulumi.getter(name="streetAddress")
    def street_address(self) -> str:
        """
        The street address of the subject.
        """
        return pulumi.get(self, "street_address")


@pulumi.output_type
class SubordinateConfigChainResponse(dict):
    """
    This message describes a subordinate CA's issuer certificate chain. This wrapper exists for compatibility reasons.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pemCertificates":
            suggest = "pem_certificates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubordinateConfigChainResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubordinateConfigChainResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubordinateConfigChainResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pem_certificates: Sequence[str]):
        """
        This message describes a subordinate CA's issuer certificate chain. This wrapper exists for compatibility reasons.
        :param Sequence[str] pem_certificates: Expected to be in leaf-to-root order according to RFC 5246.
        """
        pulumi.set(__self__, "pem_certificates", pem_certificates)

    @property
    @pulumi.getter(name="pemCertificates")
    def pem_certificates(self) -> Sequence[str]:
        """
        Expected to be in leaf-to-root order according to RFC 5246.
        """
        return pulumi.get(self, "pem_certificates")


@pulumi.output_type
class SubordinateConfigResponse(dict):
    """
    Describes a subordinate CA's issuers. This is either a resource name to a known issuing CertificateAuthority, or a PEM issuer certificate chain.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateAuthority":
            suggest = "certificate_authority"
        elif key == "pemIssuerChain":
            suggest = "pem_issuer_chain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SubordinateConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SubordinateConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SubordinateConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_authority: str,
                 pem_issuer_chain: 'outputs.SubordinateConfigChainResponse'):
        """
        Describes a subordinate CA's issuers. This is either a resource name to a known issuing CertificateAuthority, or a PEM issuer certificate chain.
        :param str certificate_authority: This can refer to a CertificateAuthority that was used to create a subordinate CertificateAuthority. This field is used for information and usability purposes only. The resource name is in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
        :param 'SubordinateConfigChainResponse' pem_issuer_chain: Contains the PEM certificate chain for the issuers of this CertificateAuthority, but not pem certificate for this CA itself.
        """
        pulumi.set(__self__, "certificate_authority", certificate_authority)
        pulumi.set(__self__, "pem_issuer_chain", pem_issuer_chain)

    @property
    @pulumi.getter(name="certificateAuthority")
    def certificate_authority(self) -> str:
        """
        This can refer to a CertificateAuthority that was used to create a subordinate CertificateAuthority. This field is used for information and usability purposes only. The resource name is in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
        """
        return pulumi.get(self, "certificate_authority")

    @property
    @pulumi.getter(name="pemIssuerChain")
    def pem_issuer_chain(self) -> 'outputs.SubordinateConfigChainResponse':
        """
        Contains the PEM certificate chain for the issuers of this CertificateAuthority, but not pem certificate for this CA itself.
        """
        return pulumi.get(self, "pem_issuer_chain")


@pulumi.output_type
class X509ExtensionResponse(dict):
    """
    An X509Extension specifies an X.509 extension, which may be used in different parts of X.509 objects like certificates, CSRs, and CRLs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X509ExtensionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X509ExtensionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X509ExtensionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 critical: bool,
                 object_id: 'outputs.ObjectIdResponse',
                 value: str):
        """
        An X509Extension specifies an X.509 extension, which may be used in different parts of X.509 objects like certificates, CSRs, and CRLs.
        :param bool critical: Optional. Indicates whether or not this extension is critical (i.e., if the client does not know how to handle this extension, the client should consider this to be an error).
        :param 'ObjectIdResponse' object_id: The OID for this X.509 extension.
        :param str value: The value of this X.509 extension.
        """
        pulumi.set(__self__, "critical", critical)
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def critical(self) -> bool:
        """
        Optional. Indicates whether or not this extension is critical (i.e., if the client does not know how to handle this extension, the client should consider this to be an error).
        """
        return pulumi.get(self, "critical")

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> 'outputs.ObjectIdResponse':
        """
        The OID for this X.509 extension.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of this X.509 extension.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class X509ParametersResponse(dict):
    """
    An X509Parameters is used to describe certain fields of an X.509 certificate, such as the key usage fields, fields specific to CA certificates, certificate policy extensions and custom extensions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalExtensions":
            suggest = "additional_extensions"
        elif key == "aiaOcspServers":
            suggest = "aia_ocsp_servers"
        elif key == "caOptions":
            suggest = "ca_options"
        elif key == "keyUsage":
            suggest = "key_usage"
        elif key == "policyIds":
            suggest = "policy_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X509ParametersResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X509ParametersResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X509ParametersResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_extensions: Sequence['outputs.X509ExtensionResponse'],
                 aia_ocsp_servers: Sequence[str],
                 ca_options: 'outputs.CaOptionsResponse',
                 key_usage: 'outputs.KeyUsageResponse',
                 policy_ids: Sequence['outputs.ObjectIdResponse']):
        """
        An X509Parameters is used to describe certain fields of an X.509 certificate, such as the key usage fields, fields specific to CA certificates, certificate policy extensions and custom extensions.
        :param Sequence['X509ExtensionResponse'] additional_extensions: Optional. Describes custom X.509 extensions.
        :param Sequence[str] aia_ocsp_servers: Optional. Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the "Authority Information Access" extension in the certificate.
        :param 'CaOptionsResponse' ca_options: Optional. Describes options in this X509Parameters that are relevant in a CA certificate.
        :param 'KeyUsageResponse' key_usage: Optional. Indicates the intended use for keys that correspond to a certificate.
        :param Sequence['ObjectIdResponse'] policy_ids: Optional. Describes the X.509 certificate policy object identifiers, per https://tools.ietf.org/html/rfc5280#section-4.2.1.4.
        """
        pulumi.set(__self__, "additional_extensions", additional_extensions)
        pulumi.set(__self__, "aia_ocsp_servers", aia_ocsp_servers)
        pulumi.set(__self__, "ca_options", ca_options)
        pulumi.set(__self__, "key_usage", key_usage)
        pulumi.set(__self__, "policy_ids", policy_ids)

    @property
    @pulumi.getter(name="additionalExtensions")
    def additional_extensions(self) -> Sequence['outputs.X509ExtensionResponse']:
        """
        Optional. Describes custom X.509 extensions.
        """
        return pulumi.get(self, "additional_extensions")

    @property
    @pulumi.getter(name="aiaOcspServers")
    def aia_ocsp_servers(self) -> Sequence[str]:
        """
        Optional. Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the "Authority Information Access" extension in the certificate.
        """
        return pulumi.get(self, "aia_ocsp_servers")

    @property
    @pulumi.getter(name="caOptions")
    def ca_options(self) -> 'outputs.CaOptionsResponse':
        """
        Optional. Describes options in this X509Parameters that are relevant in a CA certificate.
        """
        return pulumi.get(self, "ca_options")

    @property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> 'outputs.KeyUsageResponse':
        """
        Optional. Indicates the intended use for keys that correspond to a certificate.
        """
        return pulumi.get(self, "key_usage")

    @property
    @pulumi.getter(name="policyIds")
    def policy_ids(self) -> Sequence['outputs.ObjectIdResponse']:
        """
        Optional. Describes the X.509 certificate policy object identifiers, per https://tools.ietf.org/html/rfc5280#section-4.2.1.4.
        """
        return pulumi.get(self, "policy_ids")


