# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetCertificateResult',
    'AwaitableGetCertificateResult',
    'get_certificate',
    'get_certificate_output',
]

@pulumi.output_type
class GetCertificateResult:
    def __init__(__self__, certificate_description=None, certificate_template=None, config=None, create_time=None, issuer_certificate_authority=None, labels=None, lifetime=None, name=None, pem_certificate=None, pem_certificate_chain=None, pem_csr=None, revocation_details=None, subject_mode=None, update_time=None):
        if certificate_description and not isinstance(certificate_description, dict):
            raise TypeError("Expected argument 'certificate_description' to be a dict")
        pulumi.set(__self__, "certificate_description", certificate_description)
        if certificate_template and not isinstance(certificate_template, str):
            raise TypeError("Expected argument 'certificate_template' to be a str")
        pulumi.set(__self__, "certificate_template", certificate_template)
        if config and not isinstance(config, dict):
            raise TypeError("Expected argument 'config' to be a dict")
        pulumi.set(__self__, "config", config)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if issuer_certificate_authority and not isinstance(issuer_certificate_authority, str):
            raise TypeError("Expected argument 'issuer_certificate_authority' to be a str")
        pulumi.set(__self__, "issuer_certificate_authority", issuer_certificate_authority)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if lifetime and not isinstance(lifetime, str):
            raise TypeError("Expected argument 'lifetime' to be a str")
        pulumi.set(__self__, "lifetime", lifetime)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if pem_certificate and not isinstance(pem_certificate, str):
            raise TypeError("Expected argument 'pem_certificate' to be a str")
        pulumi.set(__self__, "pem_certificate", pem_certificate)
        if pem_certificate_chain and not isinstance(pem_certificate_chain, list):
            raise TypeError("Expected argument 'pem_certificate_chain' to be a list")
        pulumi.set(__self__, "pem_certificate_chain", pem_certificate_chain)
        if pem_csr and not isinstance(pem_csr, str):
            raise TypeError("Expected argument 'pem_csr' to be a str")
        pulumi.set(__self__, "pem_csr", pem_csr)
        if revocation_details and not isinstance(revocation_details, dict):
            raise TypeError("Expected argument 'revocation_details' to be a dict")
        pulumi.set(__self__, "revocation_details", revocation_details)
        if subject_mode and not isinstance(subject_mode, str):
            raise TypeError("Expected argument 'subject_mode' to be a str")
        pulumi.set(__self__, "subject_mode", subject_mode)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="certificateDescription")
    def certificate_description(self) -> 'outputs.CertificateDescriptionResponse':
        """
        A structured description of the issued X.509 certificate.
        """
        return pulumi.get(self, "certificate_description")

    @property
    @pulumi.getter(name="certificateTemplate")
    def certificate_template(self) -> str:
        """
        Immutable. The resource name for a CertificateTemplate used to issue this certificate, in the format `projects/*/locations/*/certificateTemplates/*`. If this is specified, the caller must have the necessary permission to use this template. If this is omitted, no template will be used. This template must be in the same location as the Certificate.
        """
        return pulumi.get(self, "certificate_template")

    @property
    @pulumi.getter
    def config(self) -> 'outputs.CertificateConfigResponse':
        """
        Immutable. A description of the certificate and key that does not require X.509 or ASN.1.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time at which this Certificate was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="issuerCertificateAuthority")
    def issuer_certificate_authority(self) -> str:
        """
        The resource name of the issuing CertificateAuthority in the format `projects/*/locations/*/caPools/*/certificateAuthorities/*`.
        """
        return pulumi.get(self, "issuer_certificate_authority")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Optional. Labels with user-defined metadata.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def lifetime(self) -> str:
        """
        Immutable. The desired lifetime of a certificate. Used to create the "not_before_time" and "not_after_time" fields inside an X.509 certificate. Note that the lifetime may be truncated if it would extend past the life of any certificate authority in the issuing chain.
        """
        return pulumi.get(self, "lifetime")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name for this Certificate in the format `projects/*/locations/*/caPools/*/certificates/*`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pemCertificate")
    def pem_certificate(self) -> str:
        """
        The pem-encoded, signed X.509 certificate.
        """
        return pulumi.get(self, "pem_certificate")

    @property
    @pulumi.getter(name="pemCertificateChain")
    def pem_certificate_chain(self) -> Sequence[str]:
        """
        The chain that may be used to verify the X.509 certificate. Expected to be in issuer-to-root order according to RFC 5246.
        """
        return pulumi.get(self, "pem_certificate_chain")

    @property
    @pulumi.getter(name="pemCsr")
    def pem_csr(self) -> str:
        """
        Immutable. A pem-encoded X.509 certificate signing request (CSR).
        """
        return pulumi.get(self, "pem_csr")

    @property
    @pulumi.getter(name="revocationDetails")
    def revocation_details(self) -> 'outputs.RevocationDetailsResponse':
        """
        Details regarding the revocation of this Certificate. This Certificate is considered revoked if and only if this field is present.
        """
        return pulumi.get(self, "revocation_details")

    @property
    @pulumi.getter(name="subjectMode")
    def subject_mode(self) -> str:
        """
        Immutable. Specifies how the Certificate's identity fields are to be decided. If this is omitted, the `DEFAULT` subject mode will be used.
        """
        return pulumi.get(self, "subject_mode")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The time at which this Certificate was updated.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetCertificateResult(GetCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateResult(
            certificate_description=self.certificate_description,
            certificate_template=self.certificate_template,
            config=self.config,
            create_time=self.create_time,
            issuer_certificate_authority=self.issuer_certificate_authority,
            labels=self.labels,
            lifetime=self.lifetime,
            name=self.name,
            pem_certificate=self.pem_certificate,
            pem_certificate_chain=self.pem_certificate_chain,
            pem_csr=self.pem_csr,
            revocation_details=self.revocation_details,
            subject_mode=self.subject_mode,
            update_time=self.update_time)


def get_certificate(ca_pool_id: Optional[str] = None,
                    certificate_id: Optional[str] = None,
                    location: Optional[str] = None,
                    project: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateResult:
    """
    Returns a Certificate.
    """
    __args__ = dict()
    __args__['caPoolId'] = ca_pool_id
    __args__['certificateId'] = certificate_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:privateca/v1:getCertificate', __args__, opts=opts, typ=GetCertificateResult).value

    return AwaitableGetCertificateResult(
        certificate_description=__ret__.certificate_description,
        certificate_template=__ret__.certificate_template,
        config=__ret__.config,
        create_time=__ret__.create_time,
        issuer_certificate_authority=__ret__.issuer_certificate_authority,
        labels=__ret__.labels,
        lifetime=__ret__.lifetime,
        name=__ret__.name,
        pem_certificate=__ret__.pem_certificate,
        pem_certificate_chain=__ret__.pem_certificate_chain,
        pem_csr=__ret__.pem_csr,
        revocation_details=__ret__.revocation_details,
        subject_mode=__ret__.subject_mode,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_certificate)
def get_certificate_output(ca_pool_id: Optional[pulumi.Input[str]] = None,
                           certificate_id: Optional[pulumi.Input[str]] = None,
                           location: Optional[pulumi.Input[str]] = None,
                           project: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCertificateResult]:
    """
    Returns a Certificate.
    """
    ...
