# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AnthosObservabilityFeatureSpecResponse',
    'AnthosObservabilityMembershipSpecResponse',
    'AppDevExperienceFeatureSpecResponse',
    'AppDevExperienceFeatureStateResponse',
    'ApplianceClusterResponse',
    'AuditConfigResponse',
    'AuditLogConfigResponse',
    'AuthorityResponse',
    'BindingResponse',
    'CloudAuditLoggingFeatureSpecResponse',
    'CommonFeatureSpecResponse',
    'CommonFeatureStateResponse',
    'EdgeClusterResponse',
    'ExprResponse',
    'FeatureResourceStateResponse',
    'FeatureSpecResponse',
    'FeatureStateResponse',
    'FleetLifecycleStateResponse',
    'GkeClusterResponse',
    'KubernetesMetadataResponse',
    'KubernetesResourceResponse',
    'MembershipEndpointResponse',
    'MembershipSpecResponse',
    'MembershipStateResponse',
    'MultiCloudClusterResponse',
    'MultiClusterIngressFeatureSpecResponse',
    'OnPremClusterResponse',
    'ResourceManifestResponse',
    'ResourceOptionsResponse',
    'ServiceMeshAnalysisMessageBaseResponse',
    'ServiceMeshAnalysisMessageResponse',
    'ServiceMeshFeatureStateResponse',
    'ServiceMeshTypeResponse',
    'StatusResponse',
]

@pulumi.output_type
class AnthosObservabilityFeatureSpecResponse(dict):
    """
    **Anthos Observability**: Spec
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultMembershipSpec":
            suggest = "default_membership_spec"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnthosObservabilityFeatureSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnthosObservabilityFeatureSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnthosObservabilityFeatureSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_membership_spec: 'outputs.AnthosObservabilityMembershipSpecResponse'):
        """
        **Anthos Observability**: Spec
        :param 'AnthosObservabilityMembershipSpecResponse' default_membership_spec: default membership spec for unconfigured memberships
        """
        pulumi.set(__self__, "default_membership_spec", default_membership_spec)

    @property
    @pulumi.getter(name="defaultMembershipSpec")
    def default_membership_spec(self) -> 'outputs.AnthosObservabilityMembershipSpecResponse':
        """
        default membership spec for unconfigured memberships
        """
        return pulumi.get(self, "default_membership_spec")


@pulumi.output_type
class AnthosObservabilityMembershipSpecResponse(dict):
    """
    **Anthosobservability**: Per-Membership Feature spec.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "doNotOptimizeMetrics":
            suggest = "do_not_optimize_metrics"
        elif key == "enableStackdriverOnApplications":
            suggest = "enable_stackdriver_on_applications"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnthosObservabilityMembershipSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnthosObservabilityMembershipSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnthosObservabilityMembershipSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 do_not_optimize_metrics: bool,
                 enable_stackdriver_on_applications: bool,
                 version: str):
        """
        **Anthosobservability**: Per-Membership Feature spec.
        :param bool do_not_optimize_metrics: use full of metrics rather than optimized metrics. See https://cloud.google.com/anthos/clusters/docs/on-prem/1.8/concepts/logging-and-monitoring#optimized_metrics_default_metrics
        :param bool enable_stackdriver_on_applications: enable collecting and reporting metrics and logs from user apps See go/onyx-application-metrics-logs-user-guide
        :param str version: the version of stackdriver operator used by this feature
        """
        pulumi.set(__self__, "do_not_optimize_metrics", do_not_optimize_metrics)
        pulumi.set(__self__, "enable_stackdriver_on_applications", enable_stackdriver_on_applications)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="doNotOptimizeMetrics")
    def do_not_optimize_metrics(self) -> bool:
        """
        use full of metrics rather than optimized metrics. See https://cloud.google.com/anthos/clusters/docs/on-prem/1.8/concepts/logging-and-monitoring#optimized_metrics_default_metrics
        """
        return pulumi.get(self, "do_not_optimize_metrics")

    @property
    @pulumi.getter(name="enableStackdriverOnApplications")
    def enable_stackdriver_on_applications(self) -> bool:
        """
        enable collecting and reporting metrics and logs from user apps See go/onyx-application-metrics-logs-user-guide
        """
        return pulumi.get(self, "enable_stackdriver_on_applications")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        the version of stackdriver operator used by this feature
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class AppDevExperienceFeatureSpecResponse(dict):
    """
    Spec for App Dev Experience Feature.
    """
    def __init__(__self__):
        """
        Spec for App Dev Experience Feature.
        """
        pass


@pulumi.output_type
class AppDevExperienceFeatureStateResponse(dict):
    """
    State for App Dev Exp Feature.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkingInstallSucceeded":
            suggest = "networking_install_succeeded"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppDevExperienceFeatureStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppDevExperienceFeatureStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppDevExperienceFeatureStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 networking_install_succeeded: 'outputs.StatusResponse'):
        """
        State for App Dev Exp Feature.
        :param 'StatusResponse' networking_install_succeeded: Status of subcomponent that detects configured Service Mesh resources.
        """
        pulumi.set(__self__, "networking_install_succeeded", networking_install_succeeded)

    @property
    @pulumi.getter(name="networkingInstallSucceeded")
    def networking_install_succeeded(self) -> 'outputs.StatusResponse':
        """
        Status of subcomponent that detects configured Service Mesh resources.
        """
        return pulumi.get(self, "networking_install_succeeded")


@pulumi.output_type
class ApplianceClusterResponse(dict):
    """
    ApplianceCluster contains information specific to GDC Edge Appliance Clusters.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceLink":
            suggest = "resource_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplianceClusterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplianceClusterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplianceClusterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_link: str):
        """
        ApplianceCluster contains information specific to GDC Edge Appliance Clusters.
        :param str resource_link: Immutable. Self-link of the GCP resource for the Appliance Cluster. For example: //transferappliance.googleapis.com/projects/my-project/locations/us-west1-a/appliances/my-appliance
        """
        pulumi.set(__self__, "resource_link", resource_link)

    @property
    @pulumi.getter(name="resourceLink")
    def resource_link(self) -> str:
        """
        Immutable. Self-link of the GCP resource for the Appliance Cluster. For example: //transferappliance.googleapis.com/projects/my-project/locations/us-west1-a/appliances/my-appliance
        """
        return pulumi.get(self, "resource_link")


@pulumi.output_type
class AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param Sequence['AuditLogConfigResponse'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class AuthorityResponse(dict):
    """
    Authority encodes how Google will recognize identities from this Membership. See the workload identity documentation for more details: https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityProvider":
            suggest = "identity_provider"
        elif key == "oidcJwks":
            suggest = "oidc_jwks"
        elif key == "workloadIdentityPool":
            suggest = "workload_identity_pool"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_provider: str,
                 issuer: str,
                 oidc_jwks: str,
                 workload_identity_pool: str):
        """
        Authority encodes how Google will recognize identities from this Membership. See the workload identity documentation for more details: https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
        :param str identity_provider: An identity provider that reflects the `issuer` in the workload identity pool.
        :param str issuer: Optional. A JSON Web Token (JWT) issuer URI. `issuer` must start with `https://` and be a valid URL with length <2000 characters. If set, then Google will allow valid OIDC tokens from this issuer to authenticate within the workload_identity_pool. OIDC discovery will be performed on this URI to validate tokens from the issuer. Clearing `issuer` disables Workload Identity. `issuer` cannot be directly modified; it must be cleared (and Workload Identity disabled) before using a new issuer (and re-enabling Workload Identity).
        :param str oidc_jwks: Optional. OIDC verification keys for this Membership in JWKS format (RFC 7517). When this field is set, OIDC discovery will NOT be performed on `issuer`, and instead OIDC tokens will be validated using this field.
        :param str workload_identity_pool: The name of the workload identity pool in which `issuer` will be recognized. There is a single Workload Identity Pool per Hub that is shared between all Memberships that belong to that Hub. For a Hub hosted in {PROJECT_ID}, the workload pool format is `{PROJECT_ID}.hub.id.goog`, although this is subject to change in newer versions of this API.
        """
        pulumi.set(__self__, "identity_provider", identity_provider)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "oidc_jwks", oidc_jwks)
        pulumi.set(__self__, "workload_identity_pool", workload_identity_pool)

    @property
    @pulumi.getter(name="identityProvider")
    def identity_provider(self) -> str:
        """
        An identity provider that reflects the `issuer` in the workload identity pool.
        """
        return pulumi.get(self, "identity_provider")

    @property
    @pulumi.getter
    def issuer(self) -> str:
        """
        Optional. A JSON Web Token (JWT) issuer URI. `issuer` must start with `https://` and be a valid URL with length <2000 characters. If set, then Google will allow valid OIDC tokens from this issuer to authenticate within the workload_identity_pool. OIDC discovery will be performed on this URI to validate tokens from the issuer. Clearing `issuer` disables Workload Identity. `issuer` cannot be directly modified; it must be cleared (and Workload Identity disabled) before using a new issuer (and re-enabling Workload Identity).
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="oidcJwks")
    def oidc_jwks(self) -> str:
        """
        Optional. OIDC verification keys for this Membership in JWKS format (RFC 7517). When this field is set, OIDC discovery will NOT be performed on `issuer`, and instead OIDC tokens will be validated using this field.
        """
        return pulumi.get(self, "oidc_jwks")

    @property
    @pulumi.getter(name="workloadIdentityPool")
    def workload_identity_pool(self) -> str:
        """
        The name of the workload identity pool in which `issuer` will be recognized. There is a single Workload Identity Pool per Hub that is shared between all Memberships that belong to that Hub. For a Hub hosted in {PROJECT_ID}, the workload pool format is `{PROJECT_ID}.hub.id.goog`, although this is subject to change in newer versions of this API.
        """
        return pulumi.get(self, "workload_identity_pool")


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class CloudAuditLoggingFeatureSpecResponse(dict):
    """
    **Cloud Audit Logging**: Spec for Audit Logging Allowlisting.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowlistedServiceAccounts":
            suggest = "allowlisted_service_accounts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudAuditLoggingFeatureSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudAuditLoggingFeatureSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudAuditLoggingFeatureSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowlisted_service_accounts: Sequence[str]):
        """
        **Cloud Audit Logging**: Spec for Audit Logging Allowlisting.
        :param Sequence[str] allowlisted_service_accounts: Service account that should be allowlisted to send the audit logs; eg cloudauditlogging@gcp-project.iam.gserviceaccount.com. These accounts must already exist, but do not need to have any permissions granted to them. The customer's entitlements will be checked prior to allowlisting (i.e. the customer must be an Anthos customer.)
        """
        pulumi.set(__self__, "allowlisted_service_accounts", allowlisted_service_accounts)

    @property
    @pulumi.getter(name="allowlistedServiceAccounts")
    def allowlisted_service_accounts(self) -> Sequence[str]:
        """
        Service account that should be allowlisted to send the audit logs; eg cloudauditlogging@gcp-project.iam.gserviceaccount.com. These accounts must already exist, but do not need to have any permissions granted to them. The customer's entitlements will be checked prior to allowlisting (i.e. the customer must be an Anthos customer.)
        """
        return pulumi.get(self, "allowlisted_service_accounts")


@pulumi.output_type
class CommonFeatureSpecResponse(dict):
    """
    CommonFeatureSpec contains Hub-wide configuration information
    """
    def __init__(__self__, *,
                 anthosobservability: 'outputs.AnthosObservabilityFeatureSpecResponse',
                 appdevexperience: 'outputs.AppDevExperienceFeatureSpecResponse',
                 cloudauditlogging: 'outputs.CloudAuditLoggingFeatureSpecResponse',
                 multiclusteringress: 'outputs.MultiClusterIngressFeatureSpecResponse',
                 workloadcertificate: 'outputs.FeatureSpecResponse'):
        """
        CommonFeatureSpec contains Hub-wide configuration information
        :param 'AnthosObservabilityFeatureSpecResponse' anthosobservability: Anthos Observability spec
        :param 'AppDevExperienceFeatureSpecResponse' appdevexperience: Appdevexperience specific spec.
        :param 'CloudAuditLoggingFeatureSpecResponse' cloudauditlogging: Cloud Audit Logging-specific spec.
        :param 'MultiClusterIngressFeatureSpecResponse' multiclusteringress: Multicluster Ingress-specific spec.
        :param 'FeatureSpecResponse' workloadcertificate: Workload Certificate spec.
        """
        pulumi.set(__self__, "anthosobservability", anthosobservability)
        pulumi.set(__self__, "appdevexperience", appdevexperience)
        pulumi.set(__self__, "cloudauditlogging", cloudauditlogging)
        pulumi.set(__self__, "multiclusteringress", multiclusteringress)
        pulumi.set(__self__, "workloadcertificate", workloadcertificate)

    @property
    @pulumi.getter
    def anthosobservability(self) -> 'outputs.AnthosObservabilityFeatureSpecResponse':
        """
        Anthos Observability spec
        """
        return pulumi.get(self, "anthosobservability")

    @property
    @pulumi.getter
    def appdevexperience(self) -> 'outputs.AppDevExperienceFeatureSpecResponse':
        """
        Appdevexperience specific spec.
        """
        return pulumi.get(self, "appdevexperience")

    @property
    @pulumi.getter
    def cloudauditlogging(self) -> 'outputs.CloudAuditLoggingFeatureSpecResponse':
        """
        Cloud Audit Logging-specific spec.
        """
        return pulumi.get(self, "cloudauditlogging")

    @property
    @pulumi.getter
    def multiclusteringress(self) -> 'outputs.MultiClusterIngressFeatureSpecResponse':
        """
        Multicluster Ingress-specific spec.
        """
        return pulumi.get(self, "multiclusteringress")

    @property
    @pulumi.getter
    def workloadcertificate(self) -> 'outputs.FeatureSpecResponse':
        """
        Workload Certificate spec.
        """
        return pulumi.get(self, "workloadcertificate")


@pulumi.output_type
class CommonFeatureStateResponse(dict):
    """
    CommonFeatureState contains Hub-wide Feature status information.
    """
    def __init__(__self__, *,
                 appdevexperience: 'outputs.AppDevExperienceFeatureStateResponse',
                 servicemesh: 'outputs.ServiceMeshFeatureStateResponse',
                 state: 'outputs.FeatureStateResponse'):
        """
        CommonFeatureState contains Hub-wide Feature status information.
        :param 'AppDevExperienceFeatureStateResponse' appdevexperience: Appdevexperience specific state.
        :param 'ServiceMeshFeatureStateResponse' servicemesh: Service Mesh-specific state.
        :param 'FeatureStateResponse' state: The "running state" of the Feature in this Hub.
        """
        pulumi.set(__self__, "appdevexperience", appdevexperience)
        pulumi.set(__self__, "servicemesh", servicemesh)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def appdevexperience(self) -> 'outputs.AppDevExperienceFeatureStateResponse':
        """
        Appdevexperience specific state.
        """
        return pulumi.get(self, "appdevexperience")

    @property
    @pulumi.getter
    def servicemesh(self) -> 'outputs.ServiceMeshFeatureStateResponse':
        """
        Service Mesh-specific state.
        """
        return pulumi.get(self, "servicemesh")

    @property
    @pulumi.getter
    def state(self) -> 'outputs.FeatureStateResponse':
        """
        The "running state" of the Feature in this Hub.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class EdgeClusterResponse(dict):
    """
    EdgeCluster contains information specific to Google Edge Clusters.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceLink":
            suggest = "resource_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EdgeClusterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EdgeClusterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EdgeClusterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_link: str):
        """
        EdgeCluster contains information specific to Google Edge Clusters.
        :param str resource_link: Immutable. Self-link of the GCP resource for the Edge Cluster. For example: //edgecontainer.googleapis.com/projects/my-project/locations/us-west1-a/clusters/my-cluster
        """
        pulumi.set(__self__, "resource_link", resource_link)

    @property
    @pulumi.getter(name="resourceLink")
    def resource_link(self) -> str:
        """
        Immutable. Self-link of the GCP resource for the Edge Cluster. For example: //edgecontainer.googleapis.com/projects/my-project/locations/us-west1-a/clusters/my-cluster
        """
        return pulumi.get(self, "resource_link")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class FeatureResourceStateResponse(dict):
    """
    FeatureResourceState describes the state of a Feature *resource* in the GkeHub API. See `FeatureState` for the "running state" of the Feature in the Hub and across Memberships.
    """
    def __init__(__self__, *,
                 state: str):
        """
        FeatureResourceState describes the state of a Feature *resource* in the GkeHub API. See `FeatureState` for the "running state" of the Feature in the Hub and across Memberships.
        :param str state: The current state of the Feature resource in the Hub API.
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Feature resource in the Hub API.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class FeatureSpecResponse(dict):
    """
    **Workload Certificate**: The Hub-wide input for the WorkloadCertificate feature.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultConfig":
            suggest = "default_config"
        elif key == "provisionGoogleCa":
            suggest = "provision_google_ca"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_config: 'outputs.MembershipSpecResponse',
                 provision_google_ca: str):
        """
        **Workload Certificate**: The Hub-wide input for the WorkloadCertificate feature.
        :param 'MembershipSpecResponse' default_config: Specifies default membership spec. Users can override the default in the member_configs for each member.
        :param str provision_google_ca: Immutable. Specifies CA configuration.
        """
        pulumi.set(__self__, "default_config", default_config)
        pulumi.set(__self__, "provision_google_ca", provision_google_ca)

    @property
    @pulumi.getter(name="defaultConfig")
    def default_config(self) -> 'outputs.MembershipSpecResponse':
        """
        Specifies default membership spec. Users can override the default in the member_configs for each member.
        """
        return pulumi.get(self, "default_config")

    @property
    @pulumi.getter(name="provisionGoogleCa")
    def provision_google_ca(self) -> str:
        """
        Immutable. Specifies CA configuration.
        """
        return pulumi.get(self, "provision_google_ca")


@pulumi.output_type
class FeatureStateResponse(dict):
    """
    FeatureState describes the high-level state of a Feature. It may be used to describe a Feature's state at the environ-level, or per-membershop, depending on the context.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FeatureStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FeatureStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FeatureStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: str,
                 description: str,
                 update_time: str):
        """
        FeatureState describes the high-level state of a Feature. It may be used to describe a Feature's state at the environ-level, or per-membershop, depending on the context.
        :param str code: The high-level, machine-readable status of this Feature.
        :param str description: A human-readable description of the current status.
        :param str update_time: The time this status and any related Feature-specific details were updated.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        The high-level, machine-readable status of this Feature.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A human-readable description of the current status.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The time this status and any related Feature-specific details were updated.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class FleetLifecycleStateResponse(dict):
    """
    FleetLifecycleState describes the state of a Fleet resource.
    """
    def __init__(__self__, *,
                 code: str):
        """
        FleetLifecycleState describes the state of a Fleet resource.
        :param str code: The current state of the Fleet resource.
        """
        pulumi.set(__self__, "code", code)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        The current state of the Fleet resource.
        """
        return pulumi.get(self, "code")


@pulumi.output_type
class GkeClusterResponse(dict):
    """
    GkeCluster contains information specific to GKE clusters.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterMissing":
            suggest = "cluster_missing"
        elif key == "resourceLink":
            suggest = "resource_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GkeClusterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GkeClusterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GkeClusterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_missing: bool,
                 resource_link: str):
        """
        GkeCluster contains information specific to GKE clusters.
        :param bool cluster_missing: If cluster_missing is set then it denotes that the GKE cluster no longer exists in the GKE Control Plane.
        :param str resource_link: Immutable. Self-link of the GCP resource for the GKE cluster. For example: //container.googleapis.com/projects/my-project/locations/us-west1-a/clusters/my-cluster Zonal clusters are also supported.
        """
        pulumi.set(__self__, "cluster_missing", cluster_missing)
        pulumi.set(__self__, "resource_link", resource_link)

    @property
    @pulumi.getter(name="clusterMissing")
    def cluster_missing(self) -> bool:
        """
        If cluster_missing is set then it denotes that the GKE cluster no longer exists in the GKE Control Plane.
        """
        return pulumi.get(self, "cluster_missing")

    @property
    @pulumi.getter(name="resourceLink")
    def resource_link(self) -> str:
        """
        Immutable. Self-link of the GCP resource for the GKE cluster. For example: //container.googleapis.com/projects/my-project/locations/us-west1-a/clusters/my-cluster Zonal clusters are also supported.
        """
        return pulumi.get(self, "resource_link")


@pulumi.output_type
class KubernetesMetadataResponse(dict):
    """
    KubernetesMetadata provides informational metadata for Memberships representing Kubernetes clusters.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kubernetesApiServerVersion":
            suggest = "kubernetes_api_server_version"
        elif key == "memoryMb":
            suggest = "memory_mb"
        elif key == "nodeCount":
            suggest = "node_count"
        elif key == "nodeProviderId":
            suggest = "node_provider_id"
        elif key == "updateTime":
            suggest = "update_time"
        elif key == "vcpuCount":
            suggest = "vcpu_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kubernetes_api_server_version: str,
                 memory_mb: int,
                 node_count: int,
                 node_provider_id: str,
                 update_time: str,
                 vcpu_count: int):
        """
        KubernetesMetadata provides informational metadata for Memberships representing Kubernetes clusters.
        :param str kubernetes_api_server_version: Kubernetes API server version string as reported by `/version`.
        :param int memory_mb: The total memory capacity as reported by the sum of all Kubernetes nodes resources, defined in MB.
        :param int node_count: Node count as reported by Kubernetes nodes resources.
        :param str node_provider_id: Node providerID as reported by the first node in the list of nodes on the Kubernetes endpoint. On Kubernetes platforms that support zero-node clusters (like GKE-on-GCP), the node_count will be zero and the node_provider_id will be empty.
        :param str update_time: The time at which these details were last updated. This update_time is different from the Membership-level update_time since EndpointDetails are updated internally for API consumers.
        :param int vcpu_count: vCPU count as reported by Kubernetes nodes resources.
        """
        pulumi.set(__self__, "kubernetes_api_server_version", kubernetes_api_server_version)
        pulumi.set(__self__, "memory_mb", memory_mb)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "node_provider_id", node_provider_id)
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "vcpu_count", vcpu_count)

    @property
    @pulumi.getter(name="kubernetesApiServerVersion")
    def kubernetes_api_server_version(self) -> str:
        """
        Kubernetes API server version string as reported by `/version`.
        """
        return pulumi.get(self, "kubernetes_api_server_version")

    @property
    @pulumi.getter(name="memoryMb")
    def memory_mb(self) -> int:
        """
        The total memory capacity as reported by the sum of all Kubernetes nodes resources, defined in MB.
        """
        return pulumi.get(self, "memory_mb")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> int:
        """
        Node count as reported by Kubernetes nodes resources.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeProviderId")
    def node_provider_id(self) -> str:
        """
        Node providerID as reported by the first node in the list of nodes on the Kubernetes endpoint. On Kubernetes platforms that support zero-node clusters (like GKE-on-GCP), the node_count will be zero and the node_provider_id will be empty.
        """
        return pulumi.get(self, "node_provider_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The time at which these details were last updated. This update_time is different from the Membership-level update_time since EndpointDetails are updated internally for API consumers.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="vcpuCount")
    def vcpu_count(self) -> int:
        """
        vCPU count as reported by Kubernetes nodes resources.
        """
        return pulumi.get(self, "vcpu_count")


@pulumi.output_type
class KubernetesResourceResponse(dict):
    """
    KubernetesResource contains the YAML manifests and configuration for Membership Kubernetes resources in the cluster. After CreateMembership or UpdateMembership, these resources should be re-applied in the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectResources":
            suggest = "connect_resources"
        elif key == "membershipCrManifest":
            suggest = "membership_cr_manifest"
        elif key == "membershipResources":
            suggest = "membership_resources"
        elif key == "resourceOptions":
            suggest = "resource_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesResourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesResourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesResourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connect_resources: Sequence['outputs.ResourceManifestResponse'],
                 membership_cr_manifest: str,
                 membership_resources: Sequence['outputs.ResourceManifestResponse'],
                 resource_options: 'outputs.ResourceOptionsResponse'):
        """
        KubernetesResource contains the YAML manifests and configuration for Membership Kubernetes resources in the cluster. After CreateMembership or UpdateMembership, these resources should be re-applied in the cluster.
        :param Sequence['ResourceManifestResponse'] connect_resources: The Kubernetes resources for installing the GKE Connect agent This field is only populated in the Membership returned from a successful long-running operation from CreateMembership or UpdateMembership. It is not populated during normal GetMembership or ListMemberships requests. To get the resource manifest after the initial registration, the caller should make a UpdateMembership call with an empty field mask.
        :param str membership_cr_manifest: Input only. The YAML representation of the Membership CR. This field is ignored for GKE clusters where Hub can read the CR directly. Callers should provide the CR that is currently present in the cluster during CreateMembership or UpdateMembership, or leave this field empty if none exists. The CR manifest is used to validate the cluster has not been registered with another Membership.
        :param Sequence['ResourceManifestResponse'] membership_resources: Additional Kubernetes resources that need to be applied to the cluster after Membership creation, and after every update. This field is only populated in the Membership returned from a successful long-running operation from CreateMembership or UpdateMembership. It is not populated during normal GetMembership or ListMemberships requests. To get the resource manifest after the initial registration, the caller should make a UpdateMembership call with an empty field mask.
        :param 'ResourceOptionsResponse' resource_options: Optional. Options for Kubernetes resource generation.
        """
        pulumi.set(__self__, "connect_resources", connect_resources)
        pulumi.set(__self__, "membership_cr_manifest", membership_cr_manifest)
        pulumi.set(__self__, "membership_resources", membership_resources)
        pulumi.set(__self__, "resource_options", resource_options)

    @property
    @pulumi.getter(name="connectResources")
    def connect_resources(self) -> Sequence['outputs.ResourceManifestResponse']:
        """
        The Kubernetes resources for installing the GKE Connect agent This field is only populated in the Membership returned from a successful long-running operation from CreateMembership or UpdateMembership. It is not populated during normal GetMembership or ListMemberships requests. To get the resource manifest after the initial registration, the caller should make a UpdateMembership call with an empty field mask.
        """
        return pulumi.get(self, "connect_resources")

    @property
    @pulumi.getter(name="membershipCrManifest")
    def membership_cr_manifest(self) -> str:
        """
        Input only. The YAML representation of the Membership CR. This field is ignored for GKE clusters where Hub can read the CR directly. Callers should provide the CR that is currently present in the cluster during CreateMembership or UpdateMembership, or leave this field empty if none exists. The CR manifest is used to validate the cluster has not been registered with another Membership.
        """
        return pulumi.get(self, "membership_cr_manifest")

    @property
    @pulumi.getter(name="membershipResources")
    def membership_resources(self) -> Sequence['outputs.ResourceManifestResponse']:
        """
        Additional Kubernetes resources that need to be applied to the cluster after Membership creation, and after every update. This field is only populated in the Membership returned from a successful long-running operation from CreateMembership or UpdateMembership. It is not populated during normal GetMembership or ListMemberships requests. To get the resource manifest after the initial registration, the caller should make a UpdateMembership call with an empty field mask.
        """
        return pulumi.get(self, "membership_resources")

    @property
    @pulumi.getter(name="resourceOptions")
    def resource_options(self) -> 'outputs.ResourceOptionsResponse':
        """
        Optional. Options for Kubernetes resource generation.
        """
        return pulumi.get(self, "resource_options")


@pulumi.output_type
class MembershipEndpointResponse(dict):
    """
    MembershipEndpoint contains information needed to contact a Kubernetes API, endpoint and any additional Kubernetes metadata.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applianceCluster":
            suggest = "appliance_cluster"
        elif key == "edgeCluster":
            suggest = "edge_cluster"
        elif key == "gkeCluster":
            suggest = "gke_cluster"
        elif key == "kubernetesMetadata":
            suggest = "kubernetes_metadata"
        elif key == "kubernetesResource":
            suggest = "kubernetes_resource"
        elif key == "multiCloudCluster":
            suggest = "multi_cloud_cluster"
        elif key == "onPremCluster":
            suggest = "on_prem_cluster"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MembershipEndpointResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MembershipEndpointResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MembershipEndpointResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 appliance_cluster: 'outputs.ApplianceClusterResponse',
                 edge_cluster: 'outputs.EdgeClusterResponse',
                 gke_cluster: 'outputs.GkeClusterResponse',
                 kubernetes_metadata: 'outputs.KubernetesMetadataResponse',
                 kubernetes_resource: 'outputs.KubernetesResourceResponse',
                 multi_cloud_cluster: 'outputs.MultiCloudClusterResponse',
                 on_prem_cluster: 'outputs.OnPremClusterResponse'):
        """
        MembershipEndpoint contains information needed to contact a Kubernetes API, endpoint and any additional Kubernetes metadata.
        :param 'ApplianceClusterResponse' appliance_cluster: Optional. Specific information for a GDC Edge Appliance cluster.
        :param 'EdgeClusterResponse' edge_cluster: Optional. Specific information for a Google Edge cluster.
        :param 'GkeClusterResponse' gke_cluster: Optional. Specific information for a GKE-on-GCP cluster.
        :param 'KubernetesMetadataResponse' kubernetes_metadata: Useful Kubernetes-specific metadata.
        :param 'KubernetesResourceResponse' kubernetes_resource: Optional. The in-cluster Kubernetes Resources that should be applied for a correctly registered cluster, in the steady state. These resources: * Ensure that the cluster is exclusively registered to one and only one Hub Membership. * Propagate Workload Pool Information available in the Membership Authority field. * Ensure proper initial configuration of default Hub Features.
        :param 'MultiCloudClusterResponse' multi_cloud_cluster: Optional. Specific information for a GKE Multi-Cloud cluster.
        :param 'OnPremClusterResponse' on_prem_cluster: Optional. Specific information for a GKE On-Prem cluster. An onprem user-cluster who has no resourceLink is not allowed to use this field, it should have a nil "type" instead.
        """
        pulumi.set(__self__, "appliance_cluster", appliance_cluster)
        pulumi.set(__self__, "edge_cluster", edge_cluster)
        pulumi.set(__self__, "gke_cluster", gke_cluster)
        pulumi.set(__self__, "kubernetes_metadata", kubernetes_metadata)
        pulumi.set(__self__, "kubernetes_resource", kubernetes_resource)
        pulumi.set(__self__, "multi_cloud_cluster", multi_cloud_cluster)
        pulumi.set(__self__, "on_prem_cluster", on_prem_cluster)

    @property
    @pulumi.getter(name="applianceCluster")
    def appliance_cluster(self) -> 'outputs.ApplianceClusterResponse':
        """
        Optional. Specific information for a GDC Edge Appliance cluster.
        """
        return pulumi.get(self, "appliance_cluster")

    @property
    @pulumi.getter(name="edgeCluster")
    def edge_cluster(self) -> 'outputs.EdgeClusterResponse':
        """
        Optional. Specific information for a Google Edge cluster.
        """
        return pulumi.get(self, "edge_cluster")

    @property
    @pulumi.getter(name="gkeCluster")
    def gke_cluster(self) -> 'outputs.GkeClusterResponse':
        """
        Optional. Specific information for a GKE-on-GCP cluster.
        """
        return pulumi.get(self, "gke_cluster")

    @property
    @pulumi.getter(name="kubernetesMetadata")
    def kubernetes_metadata(self) -> 'outputs.KubernetesMetadataResponse':
        """
        Useful Kubernetes-specific metadata.
        """
        return pulumi.get(self, "kubernetes_metadata")

    @property
    @pulumi.getter(name="kubernetesResource")
    def kubernetes_resource(self) -> 'outputs.KubernetesResourceResponse':
        """
        Optional. The in-cluster Kubernetes Resources that should be applied for a correctly registered cluster, in the steady state. These resources: * Ensure that the cluster is exclusively registered to one and only one Hub Membership. * Propagate Workload Pool Information available in the Membership Authority field. * Ensure proper initial configuration of default Hub Features.
        """
        return pulumi.get(self, "kubernetes_resource")

    @property
    @pulumi.getter(name="multiCloudCluster")
    def multi_cloud_cluster(self) -> 'outputs.MultiCloudClusterResponse':
        """
        Optional. Specific information for a GKE Multi-Cloud cluster.
        """
        return pulumi.get(self, "multi_cloud_cluster")

    @property
    @pulumi.getter(name="onPremCluster")
    def on_prem_cluster(self) -> 'outputs.OnPremClusterResponse':
        """
        Optional. Specific information for a GKE On-Prem cluster. An onprem user-cluster who has no resourceLink is not allowed to use this field, it should have a nil "type" instead.
        """
        return pulumi.get(self, "on_prem_cluster")


@pulumi.output_type
class MembershipSpecResponse(dict):
    """
    **Workload Certificate**: The membership-specific input for WorkloadCertificate feature.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateManagement":
            suggest = "certificate_management"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MembershipSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MembershipSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MembershipSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_management: str):
        """
        **Workload Certificate**: The membership-specific input for WorkloadCertificate feature.
        :param str certificate_management: Specifies workload certificate management.
        """
        pulumi.set(__self__, "certificate_management", certificate_management)

    @property
    @pulumi.getter(name="certificateManagement")
    def certificate_management(self) -> str:
        """
        Specifies workload certificate management.
        """
        return pulumi.get(self, "certificate_management")


@pulumi.output_type
class MembershipStateResponse(dict):
    """
    MembershipState describes the state of a Membership resource.
    """
    def __init__(__self__, *,
                 code: str):
        """
        MembershipState describes the state of a Membership resource.
        :param str code: The current state of the Membership resource.
        """
        pulumi.set(__self__, "code", code)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        The current state of the Membership resource.
        """
        return pulumi.get(self, "code")


@pulumi.output_type
class MultiCloudClusterResponse(dict):
    """
    MultiCloudCluster contains information specific to GKE Multi-Cloud clusters.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterMissing":
            suggest = "cluster_missing"
        elif key == "resourceLink":
            suggest = "resource_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiCloudClusterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiCloudClusterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiCloudClusterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_missing: bool,
                 resource_link: str):
        """
        MultiCloudCluster contains information specific to GKE Multi-Cloud clusters.
        :param bool cluster_missing: If cluster_missing is set then it denotes that API(gkemulticloud.googleapis.com) resource for this GKE Multi-Cloud cluster no longer exists.
        :param str resource_link: Immutable. Self-link of the GCP resource for the GKE Multi-Cloud cluster. For example: //gkemulticloud.googleapis.com/projects/my-project/locations/us-west1-a/awsClusters/my-cluster //gkemulticloud.googleapis.com/projects/my-project/locations/us-west1-a/azureClusters/my-cluster //gkemulticloud.googleapis.com/projects/my-project/locations/us-west1-a/attachedClusters/my-cluster
        """
        pulumi.set(__self__, "cluster_missing", cluster_missing)
        pulumi.set(__self__, "resource_link", resource_link)

    @property
    @pulumi.getter(name="clusterMissing")
    def cluster_missing(self) -> bool:
        """
        If cluster_missing is set then it denotes that API(gkemulticloud.googleapis.com) resource for this GKE Multi-Cloud cluster no longer exists.
        """
        return pulumi.get(self, "cluster_missing")

    @property
    @pulumi.getter(name="resourceLink")
    def resource_link(self) -> str:
        """
        Immutable. Self-link of the GCP resource for the GKE Multi-Cloud cluster. For example: //gkemulticloud.googleapis.com/projects/my-project/locations/us-west1-a/awsClusters/my-cluster //gkemulticloud.googleapis.com/projects/my-project/locations/us-west1-a/azureClusters/my-cluster //gkemulticloud.googleapis.com/projects/my-project/locations/us-west1-a/attachedClusters/my-cluster
        """
        return pulumi.get(self, "resource_link")


@pulumi.output_type
class MultiClusterIngressFeatureSpecResponse(dict):
    """
    **Multi-cluster Ingress**: The configuration for the MultiClusterIngress feature.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configMembership":
            suggest = "config_membership"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiClusterIngressFeatureSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiClusterIngressFeatureSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiClusterIngressFeatureSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 billing: str,
                 config_membership: str):
        """
        **Multi-cluster Ingress**: The configuration for the MultiClusterIngress feature.
        :param str billing: Deprecated: This field will be ignored and should not be set. Customer's billing structure.
        :param str config_membership: Fully-qualified Membership name which hosts the MultiClusterIngress CRD. Example: `projects/foo-proj/locations/global/memberships/bar`
        """
        pulumi.set(__self__, "billing", billing)
        pulumi.set(__self__, "config_membership", config_membership)

    @property
    @pulumi.getter
    def billing(self) -> str:
        """
        Deprecated: This field will be ignored and should not be set. Customer's billing structure.
        """
        return pulumi.get(self, "billing")

    @property
    @pulumi.getter(name="configMembership")
    def config_membership(self) -> str:
        """
        Fully-qualified Membership name which hosts the MultiClusterIngress CRD. Example: `projects/foo-proj/locations/global/memberships/bar`
        """
        return pulumi.get(self, "config_membership")


@pulumi.output_type
class OnPremClusterResponse(dict):
    """
    OnPremCluster contains information specific to GKE On-Prem clusters.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminCluster":
            suggest = "admin_cluster"
        elif key == "clusterMissing":
            suggest = "cluster_missing"
        elif key == "clusterType":
            suggest = "cluster_type"
        elif key == "resourceLink":
            suggest = "resource_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OnPremClusterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OnPremClusterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OnPremClusterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_cluster: bool,
                 cluster_missing: bool,
                 cluster_type: str,
                 resource_link: str):
        """
        OnPremCluster contains information specific to GKE On-Prem clusters.
        :param bool admin_cluster: Immutable. Whether the cluster is an admin cluster.
        :param bool cluster_missing: If cluster_missing is set then it denotes that API(gkeonprem.googleapis.com) resource for this GKE On-Prem cluster no longer exists.
        :param str cluster_type: Immutable. The on prem cluster's type.
        :param str resource_link: Immutable. Self-link of the GCP resource for the GKE On-Prem cluster. For example: //gkeonprem.googleapis.com/projects/my-project/locations/us-west1-a/vmwareClusters/my-cluster //gkeonprem.googleapis.com/projects/my-project/locations/us-west1-a/bareMetalClusters/my-cluster
        """
        pulumi.set(__self__, "admin_cluster", admin_cluster)
        pulumi.set(__self__, "cluster_missing", cluster_missing)
        pulumi.set(__self__, "cluster_type", cluster_type)
        pulumi.set(__self__, "resource_link", resource_link)

    @property
    @pulumi.getter(name="adminCluster")
    def admin_cluster(self) -> bool:
        """
        Immutable. Whether the cluster is an admin cluster.
        """
        return pulumi.get(self, "admin_cluster")

    @property
    @pulumi.getter(name="clusterMissing")
    def cluster_missing(self) -> bool:
        """
        If cluster_missing is set then it denotes that API(gkeonprem.googleapis.com) resource for this GKE On-Prem cluster no longer exists.
        """
        return pulumi.get(self, "cluster_missing")

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> str:
        """
        Immutable. The on prem cluster's type.
        """
        return pulumi.get(self, "cluster_type")

    @property
    @pulumi.getter(name="resourceLink")
    def resource_link(self) -> str:
        """
        Immutable. Self-link of the GCP resource for the GKE On-Prem cluster. For example: //gkeonprem.googleapis.com/projects/my-project/locations/us-west1-a/vmwareClusters/my-cluster //gkeonprem.googleapis.com/projects/my-project/locations/us-west1-a/bareMetalClusters/my-cluster
        """
        return pulumi.get(self, "resource_link")


@pulumi.output_type
class ResourceManifestResponse(dict):
    """
    ResourceManifest represents a single Kubernetes resource to be applied to the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterScoped":
            suggest = "cluster_scoped"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceManifestResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceManifestResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceManifestResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_scoped: bool,
                 manifest: str):
        """
        ResourceManifest represents a single Kubernetes resource to be applied to the cluster.
        :param bool cluster_scoped: Whether the resource provided in the manifest is `cluster_scoped`. If unset, the manifest is assumed to be namespace scoped. This field is used for REST mapping when applying the resource in a cluster.
        :param str manifest: YAML manifest of the resource.
        """
        pulumi.set(__self__, "cluster_scoped", cluster_scoped)
        pulumi.set(__self__, "manifest", manifest)

    @property
    @pulumi.getter(name="clusterScoped")
    def cluster_scoped(self) -> bool:
        """
        Whether the resource provided in the manifest is `cluster_scoped`. If unset, the manifest is assumed to be namespace scoped. This field is used for REST mapping when applying the resource in a cluster.
        """
        return pulumi.get(self, "cluster_scoped")

    @property
    @pulumi.getter
    def manifest(self) -> str:
        """
        YAML manifest of the resource.
        """
        return pulumi.get(self, "manifest")


@pulumi.output_type
class ResourceOptionsResponse(dict):
    """
    ResourceOptions represent options for Kubernetes resource generation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectVersion":
            suggest = "connect_version"
        elif key == "k8sVersion":
            suggest = "k8s_version"
        elif key == "v1beta1Crd":
            suggest = "v1beta1_crd"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connect_version: str,
                 k8s_version: str,
                 v1beta1_crd: bool):
        """
        ResourceOptions represent options for Kubernetes resource generation.
        :param str connect_version: Optional. The Connect agent version to use for connect_resources. Defaults to the latest GKE Connect version. The version must be a currently supported version, obsolete versions will be rejected.
        :param str k8s_version: Optional. Major version of the Kubernetes cluster. This is only used to determine which version to use for the CustomResourceDefinition resources, `apiextensions/v1beta1` or`apiextensions/v1`.
        :param bool v1beta1_crd: Optional. Use `apiextensions/v1beta1` instead of `apiextensions/v1` for CustomResourceDefinition resources. This option should be set for clusters with Kubernetes apiserver versions <1.16.
        """
        pulumi.set(__self__, "connect_version", connect_version)
        pulumi.set(__self__, "k8s_version", k8s_version)
        pulumi.set(__self__, "v1beta1_crd", v1beta1_crd)

    @property
    @pulumi.getter(name="connectVersion")
    def connect_version(self) -> str:
        """
        Optional. The Connect agent version to use for connect_resources. Defaults to the latest GKE Connect version. The version must be a currently supported version, obsolete versions will be rejected.
        """
        return pulumi.get(self, "connect_version")

    @property
    @pulumi.getter(name="k8sVersion")
    def k8s_version(self) -> str:
        """
        Optional. Major version of the Kubernetes cluster. This is only used to determine which version to use for the CustomResourceDefinition resources, `apiextensions/v1beta1` or`apiextensions/v1`.
        """
        return pulumi.get(self, "k8s_version")

    @property
    @pulumi.getter(name="v1beta1Crd")
    def v1beta1_crd(self) -> bool:
        """
        Optional. Use `apiextensions/v1beta1` instead of `apiextensions/v1` for CustomResourceDefinition resources. This option should be set for clusters with Kubernetes apiserver versions <1.16.
        """
        return pulumi.get(self, "v1beta1_crd")


@pulumi.output_type
class ServiceMeshAnalysisMessageBaseResponse(dict):
    """
    AnalysisMessageBase describes some common information that is needed for all messages.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "documentationUrl":
            suggest = "documentation_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshAnalysisMessageBaseResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshAnalysisMessageBaseResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshAnalysisMessageBaseResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 documentation_url: str,
                 level: str,
                 type: 'outputs.ServiceMeshTypeResponse'):
        """
        AnalysisMessageBase describes some common information that is needed for all messages.
        :param str documentation_url: A url pointing to the Service Mesh or Istio documentation for this specific error type.
        :param str level: Represents how severe a message is.
        :param 'ServiceMeshTypeResponse' type: Represents the specific type of a message.
        """
        pulumi.set(__self__, "documentation_url", documentation_url)
        pulumi.set(__self__, "level", level)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="documentationUrl")
    def documentation_url(self) -> str:
        """
        A url pointing to the Service Mesh or Istio documentation for this specific error type.
        """
        return pulumi.get(self, "documentation_url")

    @property
    @pulumi.getter
    def level(self) -> str:
        """
        Represents how severe a message is.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def type(self) -> 'outputs.ServiceMeshTypeResponse':
        """
        Represents the specific type of a message.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceMeshAnalysisMessageResponse(dict):
    """
    AnalysisMessage is a single message produced by an analyzer, and it used to communicate to the end user about the state of their Service Mesh configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageBase":
            suggest = "message_base"
        elif key == "resourcePaths":
            suggest = "resource_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshAnalysisMessageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshAnalysisMessageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshAnalysisMessageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Mapping[str, str],
                 description: str,
                 message_base: 'outputs.ServiceMeshAnalysisMessageBaseResponse',
                 resource_paths: Sequence[str]):
        """
        AnalysisMessage is a single message produced by an analyzer, and it used to communicate to the end user about the state of their Service Mesh configuration.
        :param Mapping[str, str] args: A UI can combine these args with a template (based on message_base.type) to produce an internationalized message.
        :param str description: A human readable description of what the error means. It is suitable for non-internationalize display purposes.
        :param 'ServiceMeshAnalysisMessageBaseResponse' message_base: Details common to all types of Istio and ServiceMesh analysis messages.
        :param Sequence[str] resource_paths: A list of strings specifying the resource identifiers that were the cause of message generation. A "path" here may be: * MEMBERSHIP_ID if the cause is a specific member cluster * MEMBERSHIP_ID/(NAMESPACE\\/)?RESOURCETYPE/NAME if the cause is a resource in a cluster
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "message_base", message_base)
        pulumi.set(__self__, "resource_paths", resource_paths)

    @property
    @pulumi.getter
    def args(self) -> Mapping[str, str]:
        """
        A UI can combine these args with a template (based on message_base.type) to produce an internationalized message.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A human readable description of what the error means. It is suitable for non-internationalize display purposes.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="messageBase")
    def message_base(self) -> 'outputs.ServiceMeshAnalysisMessageBaseResponse':
        """
        Details common to all types of Istio and ServiceMesh analysis messages.
        """
        return pulumi.get(self, "message_base")

    @property
    @pulumi.getter(name="resourcePaths")
    def resource_paths(self) -> Sequence[str]:
        """
        A list of strings specifying the resource identifiers that were the cause of message generation. A "path" here may be: * MEMBERSHIP_ID if the cause is a specific member cluster * MEMBERSHIP_ID/(NAMESPACE\\/)?RESOURCETYPE/NAME if the cause is a resource in a cluster
        """
        return pulumi.get(self, "resource_paths")


@pulumi.output_type
class ServiceMeshFeatureStateResponse(dict):
    """
    **Service Mesh**: State for the whole Hub, as analyzed by the Service Mesh Hub Controller.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "analysisMessages":
            suggest = "analysis_messages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshFeatureStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshFeatureStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshFeatureStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 analysis_messages: Sequence['outputs.ServiceMeshAnalysisMessageResponse']):
        """
        **Service Mesh**: State for the whole Hub, as analyzed by the Service Mesh Hub Controller.
        :param Sequence['ServiceMeshAnalysisMessageResponse'] analysis_messages: Results of running Service Mesh analyzers.
        """
        pulumi.set(__self__, "analysis_messages", analysis_messages)

    @property
    @pulumi.getter(name="analysisMessages")
    def analysis_messages(self) -> Sequence['outputs.ServiceMeshAnalysisMessageResponse']:
        """
        Results of running Service Mesh analyzers.
        """
        return pulumi.get(self, "analysis_messages")


@pulumi.output_type
class ServiceMeshTypeResponse(dict):
    """
    A unique identifier for the type of message. Display_name is intended to be human-readable, code is intended to be machine readable. There should be a one-to-one mapping between display_name and code. (i.e. do not re-use display_names or codes between message types.) See istio.analysis.v1alpha1.AnalysisMessageBase.Type
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceMeshTypeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceMeshTypeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceMeshTypeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: str,
                 display_name: str):
        """
        A unique identifier for the type of message. Display_name is intended to be human-readable, code is intended to be machine readable. There should be a one-to-one mapping between display_name and code. (i.e. do not re-use display_names or codes between message types.) See istio.analysis.v1alpha1.AnalysisMessageBase.Type
        :param str code: A 7 character code matching `^IST[0-9]{4}$` or `^ASM[0-9]{4}$`, intended to uniquely identify the message type. (e.g. "IST0001" is mapped to the "InternalError" message type.)
        :param str display_name: A human-readable name for the message type. e.g. "InternalError", "PodMissingProxy". This should be the same for all messages of the same type. (This corresponds to the `name` field in open-source Istio.)
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        A 7 character code matching `^IST[0-9]{4}$` or `^ASM[0-9]{4}$`, intended to uniquely identify the message type. (e.g. "IST0001" is mapped to the "InternalError" message type.)
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A human-readable name for the message type. e.g. "InternalError", "PodMissingProxy". This should be the same for all messages of the same type. (This corresponds to the `name` field in open-source Istio.)
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class StatusResponse(dict):
    """
    Status specifies state for the subcomponent.
    """
    def __init__(__self__, *,
                 code: str,
                 description: str):
        """
        Status specifies state for the subcomponent.
        :param str code: Code specifies AppDevExperienceFeature's subcomponent ready state.
        :param str description: Description is populated if Code is Failed, explaining why it has failed.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Code specifies AppDevExperienceFeature's subcomponent ready state.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description is populated if Code is Failed, explaining why it has failed.
        """
        return pulumi.get(self, "description")


