# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = ['BackupArgs', 'Backup']

@pulumi.input_type
class BackupArgs:
    def __init__(__self__, *,
                 backup_plan_id: pulumi.Input[str],
                 backup_id: Optional[pulumi.Input[str]] = None,
                 delete_lock_days: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 retain_days: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Backup resource.
        :param pulumi.Input[str] backup_id: The client-provided short name for the Backup resource. This name must: - be between 1 and 63 characters long (inclusive) - consist of only lower-case ASCII letters, numbers, and dashes - start with a lower-case letter - end with a lower-case letter or number - be unique within the set of Backups in this BackupPlan
        :param pulumi.Input[int] delete_lock_days: Minimum age for this Backup (in days). If this field is set to a non-zero value, the Backup will be "locked" against deletion (either manual or automatic deletion) for the number of days provided (measured from the creation time of the Backup). MUST be an integer value between 0-90 (inclusive). Defaults to parent BackupPlan's backup_delete_lock_days setting and may only be increased (either at creation time or in a subsequent update).
        :param pulumi.Input[str] description: User specified descriptive string for this Backup.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of custom labels supplied by user.
        :param pulumi.Input[int] retain_days: The age (in days) after which this Backup will be automatically deleted. Must be an integer value >= 0: - If 0, no automatic deletion will occur for this Backup. - If not 0, this must be >= delete_lock_days and <= 365. Once a Backup is created, this value may only be increased. Defaults to the parent BackupPlan's backup_retain_days value.
        """
        pulumi.set(__self__, "backup_plan_id", backup_plan_id)
        if backup_id is not None:
            pulumi.set(__self__, "backup_id", backup_id)
        if delete_lock_days is not None:
            pulumi.set(__self__, "delete_lock_days", delete_lock_days)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if retain_days is not None:
            pulumi.set(__self__, "retain_days", retain_days)

    @property
    @pulumi.getter(name="backupPlanId")
    def backup_plan_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "backup_plan_id")

    @backup_plan_id.setter
    def backup_plan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "backup_plan_id", value)

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client-provided short name for the Backup resource. This name must: - be between 1 and 63 characters long (inclusive) - consist of only lower-case ASCII letters, numbers, and dashes - start with a lower-case letter - end with a lower-case letter or number - be unique within the set of Backups in this BackupPlan
        """
        return pulumi.get(self, "backup_id")

    @backup_id.setter
    def backup_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_id", value)

    @property
    @pulumi.getter(name="deleteLockDays")
    def delete_lock_days(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum age for this Backup (in days). If this field is set to a non-zero value, the Backup will be "locked" against deletion (either manual or automatic deletion) for the number of days provided (measured from the creation time of the Backup). MUST be an integer value between 0-90 (inclusive). Defaults to parent BackupPlan's backup_delete_lock_days setting and may only be increased (either at creation time or in a subsequent update).
        """
        return pulumi.get(self, "delete_lock_days")

    @delete_lock_days.setter
    def delete_lock_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delete_lock_days", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        User specified descriptive string for this Backup.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of custom labels supplied by user.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="retainDays")
    def retain_days(self) -> Optional[pulumi.Input[int]]:
        """
        The age (in days) after which this Backup will be automatically deleted. Must be an integer value >= 0: - If 0, no automatic deletion will occur for this Backup. - If not 0, this must be >= delete_lock_days and <= 365. Once a Backup is created, this value may only be increased. Defaults to the parent BackupPlan's backup_retain_days value.
        """
        return pulumi.get(self, "retain_days")

    @retain_days.setter
    def retain_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retain_days", value)


class Backup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_id: Optional[pulumi.Input[str]] = None,
                 backup_plan_id: Optional[pulumi.Input[str]] = None,
                 delete_lock_days: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 retain_days: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Creates a Backup for the given BackupPlan.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backup_id: The client-provided short name for the Backup resource. This name must: - be between 1 and 63 characters long (inclusive) - consist of only lower-case ASCII letters, numbers, and dashes - start with a lower-case letter - end with a lower-case letter or number - be unique within the set of Backups in this BackupPlan
        :param pulumi.Input[int] delete_lock_days: Minimum age for this Backup (in days). If this field is set to a non-zero value, the Backup will be "locked" against deletion (either manual or automatic deletion) for the number of days provided (measured from the creation time of the Backup). MUST be an integer value between 0-90 (inclusive). Defaults to parent BackupPlan's backup_delete_lock_days setting and may only be increased (either at creation time or in a subsequent update).
        :param pulumi.Input[str] description: User specified descriptive string for this Backup.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of custom labels supplied by user.
        :param pulumi.Input[int] retain_days: The age (in days) after which this Backup will be automatically deleted. Must be an integer value >= 0: - If 0, no automatic deletion will occur for this Backup. - If not 0, this must be >= delete_lock_days and <= 365. Once a Backup is created, this value may only be increased. Defaults to the parent BackupPlan's backup_retain_days value.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a Backup for the given BackupPlan.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param BackupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_id: Optional[pulumi.Input[str]] = None,
                 backup_plan_id: Optional[pulumi.Input[str]] = None,
                 delete_lock_days: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 retain_days: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupArgs.__new__(BackupArgs)

            __props__.__dict__["backup_id"] = backup_id
            if backup_plan_id is None and not opts.urn:
                raise TypeError("Missing required property 'backup_plan_id'")
            __props__.__dict__["backup_plan_id"] = backup_plan_id
            __props__.__dict__["delete_lock_days"] = delete_lock_days
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["retain_days"] = retain_days
            __props__.__dict__["all_namespaces"] = None
            __props__.__dict__["cluster_metadata"] = None
            __props__.__dict__["complete_time"] = None
            __props__.__dict__["config_backup_size_bytes"] = None
            __props__.__dict__["contains_secrets"] = None
            __props__.__dict__["contains_volume_data"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["delete_lock_expire_time"] = None
            __props__.__dict__["encryption_key"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["manual"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pod_count"] = None
            __props__.__dict__["resource_count"] = None
            __props__.__dict__["retain_expire_time"] = None
            __props__.__dict__["selected_applications"] = None
            __props__.__dict__["selected_namespaces"] = None
            __props__.__dict__["size_bytes"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_reason"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["volume_count"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["backup_plan_id", "location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Backup, __self__).__init__(
            'google-native:gkebackup/v1:Backup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Backup':
        """
        Get an existing Backup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = BackupArgs.__new__(BackupArgs)

        __props__.__dict__["all_namespaces"] = None
        __props__.__dict__["backup_id"] = None
        __props__.__dict__["backup_plan_id"] = None
        __props__.__dict__["cluster_metadata"] = None
        __props__.__dict__["complete_time"] = None
        __props__.__dict__["config_backup_size_bytes"] = None
        __props__.__dict__["contains_secrets"] = None
        __props__.__dict__["contains_volume_data"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["delete_lock_days"] = None
        __props__.__dict__["delete_lock_expire_time"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["encryption_key"] = None
        __props__.__dict__["etag"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["manual"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["pod_count"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["resource_count"] = None
        __props__.__dict__["retain_days"] = None
        __props__.__dict__["retain_expire_time"] = None
        __props__.__dict__["selected_applications"] = None
        __props__.__dict__["selected_namespaces"] = None
        __props__.__dict__["size_bytes"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["state_reason"] = None
        __props__.__dict__["uid"] = None
        __props__.__dict__["update_time"] = None
        __props__.__dict__["volume_count"] = None
        return Backup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allNamespaces")
    def all_namespaces(self) -> pulumi.Output[bool]:
        """
        If True, all namespaces were included in the Backup.
        """
        return pulumi.get(self, "all_namespaces")

    @property
    @pulumi.getter(name="backupId")
    def backup_id(self) -> pulumi.Output[Optional[str]]:
        """
        The client-provided short name for the Backup resource. This name must: - be between 1 and 63 characters long (inclusive) - consist of only lower-case ASCII letters, numbers, and dashes - start with a lower-case letter - end with a lower-case letter or number - be unique within the set of Backups in this BackupPlan
        """
        return pulumi.get(self, "backup_id")

    @property
    @pulumi.getter(name="backupPlanId")
    def backup_plan_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "backup_plan_id")

    @property
    @pulumi.getter(name="clusterMetadata")
    def cluster_metadata(self) -> pulumi.Output['outputs.ClusterMetadataResponse']:
        """
        Information about the GKE cluster from which this Backup was created.
        """
        return pulumi.get(self, "cluster_metadata")

    @property
    @pulumi.getter(name="completeTime")
    def complete_time(self) -> pulumi.Output[str]:
        """
        Completion time of the Backup
        """
        return pulumi.get(self, "complete_time")

    @property
    @pulumi.getter(name="configBackupSizeBytes")
    def config_backup_size_bytes(self) -> pulumi.Output[str]:
        """
        The size of the config backup in bytes.
        """
        return pulumi.get(self, "config_backup_size_bytes")

    @property
    @pulumi.getter(name="containsSecrets")
    def contains_secrets(self) -> pulumi.Output[bool]:
        """
        Whether or not the Backup contains Kubernetes Secrets. Controlled by the parent BackupPlan's include_secrets value.
        """
        return pulumi.get(self, "contains_secrets")

    @property
    @pulumi.getter(name="containsVolumeData")
    def contains_volume_data(self) -> pulumi.Output[bool]:
        """
        Whether or not the Backup contains volume data. Controlled by the parent BackupPlan's include_volume_data value.
        """
        return pulumi.get(self, "contains_volume_data")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The timestamp when this Backup resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deleteLockDays")
    def delete_lock_days(self) -> pulumi.Output[int]:
        """
        Minimum age for this Backup (in days). If this field is set to a non-zero value, the Backup will be "locked" against deletion (either manual or automatic deletion) for the number of days provided (measured from the creation time of the Backup). MUST be an integer value between 0-90 (inclusive). Defaults to parent BackupPlan's backup_delete_lock_days setting and may only be increased (either at creation time or in a subsequent update).
        """
        return pulumi.get(self, "delete_lock_days")

    @property
    @pulumi.getter(name="deleteLockExpireTime")
    def delete_lock_expire_time(self) -> pulumi.Output[str]:
        """
        The time at which an existing delete lock will expire for this backup (calculated from create_time + delete_lock_days).
        """
        return pulumi.get(self, "delete_lock_expire_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        User specified descriptive string for this Backup.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> pulumi.Output['outputs.EncryptionKeyResponse']:
        """
        The customer managed encryption key that was used to encrypt the Backup's artifacts. Inherited from the parent BackupPlan's encryption_key value.
        """
        return pulumi.get(self, "encryption_key")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a backup from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform backup updates in order to avoid race conditions: An `etag` is returned in the response to `GetBackup`, and systems are expected to put that etag in the request to `UpdateBackup` or `DeleteBackup` to ensure that their change will be applied to the same version of the resource.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A set of custom labels supplied by user.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def manual(self) -> pulumi.Output[bool]:
        """
        This flag indicates whether this Backup resource was created manually by a user or via a schedule in the BackupPlan. A value of True means that the Backup was created manually.
        """
        return pulumi.get(self, "manual")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The fully qualified name of the Backup. `projects/*/locations/*/backupPlans/*/backups/*`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="podCount")
    def pod_count(self) -> pulumi.Output[int]:
        """
        The total number of Kubernetes Pods contained in the Backup.
        """
        return pulumi.get(self, "pod_count")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="resourceCount")
    def resource_count(self) -> pulumi.Output[int]:
        """
        The total number of Kubernetes resources included in the Backup.
        """
        return pulumi.get(self, "resource_count")

    @property
    @pulumi.getter(name="retainDays")
    def retain_days(self) -> pulumi.Output[int]:
        """
        The age (in days) after which this Backup will be automatically deleted. Must be an integer value >= 0: - If 0, no automatic deletion will occur for this Backup. - If not 0, this must be >= delete_lock_days and <= 365. Once a Backup is created, this value may only be increased. Defaults to the parent BackupPlan's backup_retain_days value.
        """
        return pulumi.get(self, "retain_days")

    @property
    @pulumi.getter(name="retainExpireTime")
    def retain_expire_time(self) -> pulumi.Output[str]:
        """
        The time at which this Backup will be automatically deleted (calculated from create_time + retain_days).
        """
        return pulumi.get(self, "retain_expire_time")

    @property
    @pulumi.getter(name="selectedApplications")
    def selected_applications(self) -> pulumi.Output['outputs.NamespacedNamesResponse']:
        """
        If set, the list of ProtectedApplications whose resources were included in the Backup.
        """
        return pulumi.get(self, "selected_applications")

    @property
    @pulumi.getter(name="selectedNamespaces")
    def selected_namespaces(self) -> pulumi.Output['outputs.NamespacesResponse']:
        """
        If set, the list of namespaces that were included in the Backup.
        """
        return pulumi.get(self, "selected_namespaces")

    @property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> pulumi.Output[str]:
        """
        The total size of the Backup in bytes = config backup size + sum(volume backup sizes)
        """
        return pulumi.get(self, "size_bytes")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Current state of the Backup
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateReason")
    def state_reason(self) -> pulumi.Output[str]:
        """
        Human-readable description of why the backup is in the current `state`.
        """
        return pulumi.get(self, "state_reason")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[str]:
        """
        Server generated global unique identifier of [UUID4](https://en.wikipedia.org/wiki/Universally_unique_identifier)
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The timestamp when this Backup resource was last updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="volumeCount")
    def volume_count(self) -> pulumi.Output[int]:
        """
        The total number of volume backups contained in the Backup.
        """
        return pulumi.get(self, "volume_count")

