# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AuditConfigResponse',
    'AuditLogConfigResponse',
    'BindingResponse',
    'CloudSqlConnectionProfileResponse',
    'CloudSqlSettingsResponse',
    'DatabaseTypeResponse',
    'DumpFlagResponse',
    'DumpFlagsResponse',
    'ExprResponse',
    'MySqlConnectionProfileResponse',
    'PostgreSqlConnectionProfileResponse',
    'ReverseSshConnectivityResponse',
    'SqlAclEntryResponse',
    'SqlIpConfigResponse',
    'SslConfigResponse',
    'StaticIpConnectivityResponse',
    'StatusResponse',
    'VpcPeeringConnectivityResponse',
]

@pulumi.output_type
class AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param Sequence['AuditLogConfigResponse'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class CloudSqlConnectionProfileResponse(dict):
    """
    Specifies required connection parameters, and, optionally, the parameters required to create a Cloud SQL destination database instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudSqlId":
            suggest = "cloud_sql_id"
        elif key == "privateIp":
            suggest = "private_ip"
        elif key == "publicIp":
            suggest = "public_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudSqlConnectionProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudSqlConnectionProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudSqlConnectionProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_sql_id: str,
                 private_ip: str,
                 public_ip: str,
                 settings: 'outputs.CloudSqlSettingsResponse'):
        """
        Specifies required connection parameters, and, optionally, the parameters required to create a Cloud SQL destination database instance.
        :param str cloud_sql_id: The Cloud SQL instance ID that this connection profile is associated with.
        :param str private_ip: The Cloud SQL database instance's private IP.
        :param str public_ip: The Cloud SQL database instance's public IP.
        :param 'CloudSqlSettingsResponse' settings: Immutable. Metadata used to create the destination Cloud SQL database.
        """
        pulumi.set(__self__, "cloud_sql_id", cloud_sql_id)
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "public_ip", public_ip)
        pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="cloudSqlId")
    def cloud_sql_id(self) -> str:
        """
        The Cloud SQL instance ID that this connection profile is associated with.
        """
        return pulumi.get(self, "cloud_sql_id")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The Cloud SQL database instance's private IP.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> str:
        """
        The Cloud SQL database instance's public IP.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def settings(self) -> 'outputs.CloudSqlSettingsResponse':
        """
        Immutable. Metadata used to create the destination Cloud SQL database.
        """
        return pulumi.get(self, "settings")


@pulumi.output_type
class CloudSqlSettingsResponse(dict):
    """
    Settings for creating a Cloud SQL database instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activationPolicy":
            suggest = "activation_policy"
        elif key == "autoStorageIncrease":
            suggest = "auto_storage_increase"
        elif key == "cmekKeyName":
            suggest = "cmek_key_name"
        elif key == "dataDiskSizeGb":
            suggest = "data_disk_size_gb"
        elif key == "dataDiskType":
            suggest = "data_disk_type"
        elif key == "databaseFlags":
            suggest = "database_flags"
        elif key == "databaseVersion":
            suggest = "database_version"
        elif key == "ipConfig":
            suggest = "ip_config"
        elif key == "rootPassword":
            suggest = "root_password"
        elif key == "rootPasswordSet":
            suggest = "root_password_set"
        elif key == "sourceId":
            suggest = "source_id"
        elif key == "storageAutoResizeLimit":
            suggest = "storage_auto_resize_limit"
        elif key == "userLabels":
            suggest = "user_labels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudSqlSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudSqlSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudSqlSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 activation_policy: str,
                 auto_storage_increase: bool,
                 cmek_key_name: str,
                 collation: str,
                 data_disk_size_gb: str,
                 data_disk_type: str,
                 database_flags: Mapping[str, str],
                 database_version: str,
                 ip_config: 'outputs.SqlIpConfigResponse',
                 root_password: str,
                 root_password_set: bool,
                 source_id: str,
                 storage_auto_resize_limit: str,
                 tier: str,
                 user_labels: Mapping[str, str],
                 zone: str):
        """
        Settings for creating a Cloud SQL database instance.
        :param str activation_policy: The activation policy specifies when the instance is activated; it is applicable only when the instance state is 'RUNNABLE'. Valid values: 'ALWAYS': The instance is on, and remains so even in the absence of connection requests. `NEVER`: The instance is off; it is not activated, even if a connection request arrives.
        :param bool auto_storage_increase: [default: ON] If you enable this setting, Cloud SQL checks your available storage every 30 seconds. If the available storage falls below a threshold size, Cloud SQL automatically adds additional storage capacity. If the available storage repeatedly falls below the threshold size, Cloud SQL continues to add storage until it reaches the maximum of 30 TB.
        :param str cmek_key_name: The KMS key name used for the csql instance.
        :param str collation: The Cloud SQL default instance level collation.
        :param str data_disk_size_gb: The storage capacity available to the database, in GB. The minimum (and default) size is 10GB.
        :param str data_disk_type: The type of storage: `PD_SSD` (default) or `PD_HDD`.
        :param Mapping[str, str] database_flags: The database flags passed to the Cloud SQL instance at startup. An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param str database_version: The database engine type and version.
        :param 'SqlIpConfigResponse' ip_config: The settings for IP Management. This allows to enable or disable the instance IP and manage which external networks can connect to the instance. The IPv4 address cannot be disabled.
        :param str root_password: Input only. Initial root password.
        :param bool root_password_set: Indicates If this connection profile root password is stored.
        :param str source_id: The Database Migration Service source connection profile ID, in the format: `projects/my_project_name/locations/us-central1/connectionProfiles/connection_profile_ID`
        :param str storage_auto_resize_limit: The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        :param str tier: The tier (or machine type) for this instance, for example: `db-n1-standard-1` (MySQL instances) or `db-custom-1-3840` (PostgreSQL instances). For more information, see [Cloud SQL Instance Settings](https://cloud.google.com/sql/docs/mysql/instance-settings).
        :param Mapping[str, str] user_labels: The resource labels for a Cloud SQL instance to use to annotate any related underlying resources such as Compute Engine VMs. An object containing a list of "key": "value" pairs. Example: `{ "name": "wrench", "mass": "18kg", "count": "3" }`.
        :param str zone: The Google Cloud Platform zone where your Cloud SQL datdabse instance is located.
        """
        pulumi.set(__self__, "activation_policy", activation_policy)
        pulumi.set(__self__, "auto_storage_increase", auto_storage_increase)
        pulumi.set(__self__, "cmek_key_name", cmek_key_name)
        pulumi.set(__self__, "collation", collation)
        pulumi.set(__self__, "data_disk_size_gb", data_disk_size_gb)
        pulumi.set(__self__, "data_disk_type", data_disk_type)
        pulumi.set(__self__, "database_flags", database_flags)
        pulumi.set(__self__, "database_version", database_version)
        pulumi.set(__self__, "ip_config", ip_config)
        pulumi.set(__self__, "root_password", root_password)
        pulumi.set(__self__, "root_password_set", root_password_set)
        pulumi.set(__self__, "source_id", source_id)
        pulumi.set(__self__, "storage_auto_resize_limit", storage_auto_resize_limit)
        pulumi.set(__self__, "tier", tier)
        pulumi.set(__self__, "user_labels", user_labels)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> str:
        """
        The activation policy specifies when the instance is activated; it is applicable only when the instance state is 'RUNNABLE'. Valid values: 'ALWAYS': The instance is on, and remains so even in the absence of connection requests. `NEVER`: The instance is off; it is not activated, even if a connection request arrives.
        """
        return pulumi.get(self, "activation_policy")

    @property
    @pulumi.getter(name="autoStorageIncrease")
    def auto_storage_increase(self) -> bool:
        """
        [default: ON] If you enable this setting, Cloud SQL checks your available storage every 30 seconds. If the available storage falls below a threshold size, Cloud SQL automatically adds additional storage capacity. If the available storage repeatedly falls below the threshold size, Cloud SQL continues to add storage until it reaches the maximum of 30 TB.
        """
        return pulumi.get(self, "auto_storage_increase")

    @property
    @pulumi.getter(name="cmekKeyName")
    def cmek_key_name(self) -> str:
        """
        The KMS key name used for the csql instance.
        """
        return pulumi.get(self, "cmek_key_name")

    @property
    @pulumi.getter
    def collation(self) -> str:
        """
        The Cloud SQL default instance level collation.
        """
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter(name="dataDiskSizeGb")
    def data_disk_size_gb(self) -> str:
        """
        The storage capacity available to the database, in GB. The minimum (and default) size is 10GB.
        """
        return pulumi.get(self, "data_disk_size_gb")

    @property
    @pulumi.getter(name="dataDiskType")
    def data_disk_type(self) -> str:
        """
        The type of storage: `PD_SSD` (default) or `PD_HDD`.
        """
        return pulumi.get(self, "data_disk_type")

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Mapping[str, str]:
        """
        The database flags passed to the Cloud SQL instance at startup. An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "database_flags")

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> str:
        """
        The database engine type and version.
        """
        return pulumi.get(self, "database_version")

    @property
    @pulumi.getter(name="ipConfig")
    def ip_config(self) -> 'outputs.SqlIpConfigResponse':
        """
        The settings for IP Management. This allows to enable or disable the instance IP and manage which external networks can connect to the instance. The IPv4 address cannot be disabled.
        """
        return pulumi.get(self, "ip_config")

    @property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> str:
        """
        Input only. Initial root password.
        """
        return pulumi.get(self, "root_password")

    @property
    @pulumi.getter(name="rootPasswordSet")
    def root_password_set(self) -> bool:
        """
        Indicates If this connection profile root password is stored.
        """
        return pulumi.get(self, "root_password_set")

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> str:
        """
        The Database Migration Service source connection profile ID, in the format: `projects/my_project_name/locations/us-central1/connectionProfiles/connection_profile_ID`
        """
        return pulumi.get(self, "source_id")

    @property
    @pulumi.getter(name="storageAutoResizeLimit")
    def storage_auto_resize_limit(self) -> str:
        """
        The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        """
        return pulumi.get(self, "storage_auto_resize_limit")

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        The tier (or machine type) for this instance, for example: `db-n1-standard-1` (MySQL instances) or `db-custom-1-3840` (PostgreSQL instances). For more information, see [Cloud SQL Instance Settings](https://cloud.google.com/sql/docs/mysql/instance-settings).
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Mapping[str, str]:
        """
        The resource labels for a Cloud SQL instance to use to annotate any related underlying resources such as Compute Engine VMs. An object containing a list of "key": "value" pairs. Example: `{ "name": "wrench", "mass": "18kg", "count": "3" }`.
        """
        return pulumi.get(self, "user_labels")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        The Google Cloud Platform zone where your Cloud SQL datdabse instance is located.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class DatabaseTypeResponse(dict):
    """
    A message defining the database engine and provider.
    """
    def __init__(__self__, *,
                 engine: str,
                 provider: str):
        """
        A message defining the database engine and provider.
        :param str engine: The database engine.
        :param str provider: The database provider.
        """
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "provider", provider)

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        The database engine.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def provider(self) -> str:
        """
        The database provider.
        """
        return pulumi.get(self, "provider")


@pulumi.output_type
class DumpFlagResponse(dict):
    """
    Dump flag definition.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        Dump flag definition.
        :param str name: The name of the flag
        :param str value: The value of the flag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the flag
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the flag.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DumpFlagsResponse(dict):
    """
    Dump flags definition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dumpFlags":
            suggest = "dump_flags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DumpFlagsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DumpFlagsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DumpFlagsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dump_flags: Sequence['outputs.DumpFlagResponse']):
        """
        Dump flags definition.
        :param Sequence['DumpFlagResponse'] dump_flags: The flags for the initial dump.
        """
        pulumi.set(__self__, "dump_flags", dump_flags)

    @property
    @pulumi.getter(name="dumpFlags")
    def dump_flags(self) -> Sequence['outputs.DumpFlagResponse']:
        """
        The flags for the initial dump.
        """
        return pulumi.get(self, "dump_flags")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class MySqlConnectionProfileResponse(dict):
    """
    Specifies connection parameters required specifically for MySQL databases.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudSqlId":
            suggest = "cloud_sql_id"
        elif key == "passwordSet":
            suggest = "password_set"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MySqlConnectionProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MySqlConnectionProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MySqlConnectionProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_sql_id: str,
                 host: str,
                 password: str,
                 password_set: bool,
                 port: int,
                 ssl: 'outputs.SslConfigResponse',
                 username: str):
        """
        Specifies connection parameters required specifically for MySQL databases.
        :param str cloud_sql_id: If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
        :param str host: The IP or hostname of the source MySQL database.
        :param str password: Input only. The password for the user that Database Migration Service will be using to connect to the database. This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
        :param bool password_set: Indicates If this connection profile password is stored.
        :param int port: The network port of the source MySQL database.
        :param 'SslConfigResponse' ssl: SSL configuration for the destination to connect to the source database.
        :param str username: The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        """
        pulumi.set(__self__, "cloud_sql_id", cloud_sql_id)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "password_set", password_set)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "ssl", ssl)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="cloudSqlId")
    def cloud_sql_id(self) -> str:
        """
        If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
        """
        return pulumi.get(self, "cloud_sql_id")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The IP or hostname of the source MySQL database.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Input only. The password for the user that Database Migration Service will be using to connect to the database. This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="passwordSet")
    def password_set(self) -> bool:
        """
        Indicates If this connection profile password is stored.
        """
        return pulumi.get(self, "password_set")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The network port of the source MySQL database.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def ssl(self) -> 'outputs.SslConfigResponse':
        """
        SSL configuration for the destination to connect to the source database.
        """
        return pulumi.get(self, "ssl")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class PostgreSqlConnectionProfileResponse(dict):
    """
    Specifies connection parameters required specifically for PostgreSQL databases.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudSqlId":
            suggest = "cloud_sql_id"
        elif key == "passwordSet":
            suggest = "password_set"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PostgreSqlConnectionProfileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PostgreSqlConnectionProfileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PostgreSqlConnectionProfileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_sql_id: str,
                 host: str,
                 password: str,
                 password_set: bool,
                 port: int,
                 ssl: 'outputs.SslConfigResponse',
                 username: str):
        """
        Specifies connection parameters required specifically for PostgreSQL databases.
        :param str cloud_sql_id: If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
        :param str host: The IP or hostname of the source PostgreSQL database.
        :param str password: Input only. The password for the user that Database Migration Service will be using to connect to the database. This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
        :param bool password_set: Indicates If this connection profile password is stored.
        :param int port: The network port of the source PostgreSQL database.
        :param 'SslConfigResponse' ssl: SSL configuration for the destination to connect to the source database.
        :param str username: The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        """
        pulumi.set(__self__, "cloud_sql_id", cloud_sql_id)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "password_set", password_set)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "ssl", ssl)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="cloudSqlId")
    def cloud_sql_id(self) -> str:
        """
        If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
        """
        return pulumi.get(self, "cloud_sql_id")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The IP or hostname of the source PostgreSQL database.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Input only. The password for the user that Database Migration Service will be using to connect to the database. This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="passwordSet")
    def password_set(self) -> bool:
        """
        Indicates If this connection profile password is stored.
        """
        return pulumi.get(self, "password_set")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The network port of the source PostgreSQL database.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def ssl(self) -> 'outputs.SslConfigResponse':
        """
        SSL configuration for the destination to connect to the source database.
        """
        return pulumi.get(self, "ssl")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ReverseSshConnectivityResponse(dict):
    """
    The details needed to configure a reverse SSH tunnel between the source and destination databases. These details will be used when calling the generateSshScript method (see https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs/generateSshScript) to produce the script that will help set up the reverse SSH tunnel, and to set up the VPC peering between the Cloud SQL private network and the VPC.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vmIp":
            suggest = "vm_ip"
        elif key == "vmPort":
            suggest = "vm_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReverseSshConnectivityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReverseSshConnectivityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReverseSshConnectivityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 vm: str,
                 vm_ip: str,
                 vm_port: int,
                 vpc: str):
        """
        The details needed to configure a reverse SSH tunnel between the source and destination databases. These details will be used when calling the generateSshScript method (see https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs/generateSshScript) to produce the script that will help set up the reverse SSH tunnel, and to set up the VPC peering between the Cloud SQL private network and the VPC.
        :param str vm: The name of the virtual machine (Compute Engine) used as the bastion server for the SSH tunnel.
        :param str vm_ip: The IP of the virtual machine (Compute Engine) used as the bastion server for the SSH tunnel.
        :param int vm_port: The forwarding port of the virtual machine (Compute Engine) used as the bastion server for the SSH tunnel.
        :param str vpc: The name of the VPC to peer with the Cloud SQL private network.
        """
        pulumi.set(__self__, "vm", vm)
        pulumi.set(__self__, "vm_ip", vm_ip)
        pulumi.set(__self__, "vm_port", vm_port)
        pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter
    def vm(self) -> str:
        """
        The name of the virtual machine (Compute Engine) used as the bastion server for the SSH tunnel.
        """
        return pulumi.get(self, "vm")

    @property
    @pulumi.getter(name="vmIp")
    def vm_ip(self) -> str:
        """
        The IP of the virtual machine (Compute Engine) used as the bastion server for the SSH tunnel.
        """
        return pulumi.get(self, "vm_ip")

    @property
    @pulumi.getter(name="vmPort")
    def vm_port(self) -> int:
        """
        The forwarding port of the virtual machine (Compute Engine) used as the bastion server for the SSH tunnel.
        """
        return pulumi.get(self, "vm_port")

    @property
    @pulumi.getter
    def vpc(self) -> str:
        """
        The name of the VPC to peer with the Cloud SQL private network.
        """
        return pulumi.get(self, "vpc")


@pulumi.output_type
class SqlAclEntryResponse(dict):
    """
    An entry for an Access Control list.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expireTime":
            suggest = "expire_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlAclEntryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlAclEntryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlAclEntryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expire_time: str,
                 label: str,
                 ttl: str,
                 value: str):
        """
        An entry for an Access Control list.
        :param str expire_time: The time when this access control entry expires in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example: `2012-11-15T16:19:00.094Z`.
        :param str label: A label to identify this entry.
        :param str ttl: Input only. The time-to-leave of this access control entry.
        :param str value: The allowlisted value for the access control list.
        """
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        The time when this access control entry expires in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example: `2012-11-15T16:19:00.094Z`.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        A label to identify this entry.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def ttl(self) -> str:
        """
        Input only. The time-to-leave of this access control entry.
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The allowlisted value for the access control list.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class SqlIpConfigResponse(dict):
    """
    IP Management configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizedNetworks":
            suggest = "authorized_networks"
        elif key == "enableIpv4":
            suggest = "enable_ipv4"
        elif key == "privateNetwork":
            suggest = "private_network"
        elif key == "requireSsl":
            suggest = "require_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SqlIpConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SqlIpConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SqlIpConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorized_networks: Sequence['outputs.SqlAclEntryResponse'],
                 enable_ipv4: bool,
                 private_network: str,
                 require_ssl: bool):
        """
        IP Management configuration.
        :param Sequence['SqlAclEntryResponse'] authorized_networks: The list of external networks that are allowed to connect to the instance using the IP. See https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as 'slash' notation (e.g. `192.168.100.0/24`).
        :param bool enable_ipv4: Whether the instance should be assigned an IPv4 address or not.
        :param str private_network: The resource link for the VPC network from which the Cloud SQL instance is accessible for private IP. For example, `projects/myProject/global/networks/default`. This setting can be updated, but it cannot be removed after it is set.
        :param bool require_ssl: Whether SSL connections over IP should be enforced or not.
        """
        pulumi.set(__self__, "authorized_networks", authorized_networks)
        pulumi.set(__self__, "enable_ipv4", enable_ipv4)
        pulumi.set(__self__, "private_network", private_network)
        pulumi.set(__self__, "require_ssl", require_ssl)

    @property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> Sequence['outputs.SqlAclEntryResponse']:
        """
        The list of external networks that are allowed to connect to the instance using the IP. See https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as 'slash' notation (e.g. `192.168.100.0/24`).
        """
        return pulumi.get(self, "authorized_networks")

    @property
    @pulumi.getter(name="enableIpv4")
    def enable_ipv4(self) -> bool:
        """
        Whether the instance should be assigned an IPv4 address or not.
        """
        return pulumi.get(self, "enable_ipv4")

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> str:
        """
        The resource link for the VPC network from which the Cloud SQL instance is accessible for private IP. For example, `projects/myProject/global/networks/default`. This setting can be updated, but it cannot be removed after it is set.
        """
        return pulumi.get(self, "private_network")

    @property
    @pulumi.getter(name="requireSsl")
    def require_ssl(self) -> bool:
        """
        Whether SSL connections over IP should be enforced or not.
        """
        return pulumi.get(self, "require_ssl")


@pulumi.output_type
class SslConfigResponse(dict):
    """
    SSL configuration information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCertificate":
            suggest = "ca_certificate"
        elif key == "clientCertificate":
            suggest = "client_certificate"
        elif key == "clientKey":
            suggest = "client_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SslConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SslConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SslConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_certificate: str,
                 client_certificate: str,
                 client_key: str,
                 type: str):
        """
        SSL configuration information.
        :param str ca_certificate: Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate. The replica will use this certificate to verify it's connecting to the right host.
        :param str client_certificate: Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.If this field is used then the 'client_key' field is mandatory.
        :param str client_key: Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate. If this field is used then the 'client_certificate' field is mandatory.
        :param str type: The ssl config type according to 'client_key', 'client_certificate' and 'ca_certificate'.
        """
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        pulumi.set(__self__, "client_certificate", client_certificate)
        pulumi.set(__self__, "client_key", client_key)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> str:
        """
        Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate. The replica will use this certificate to verify it's connecting to the right host.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> str:
        """
        Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.If this field is used then the 'client_key' field is mandatory.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> str:
        """
        Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate. If this field is used then the 'client_certificate' field is mandatory.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The ssl config type according to 'client_key', 'client_certificate' and 'ca_certificate'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class StaticIpConnectivityResponse(dict):
    """
    The source database will allow incoming connections from the destination database's public IP. You can retrieve the Cloud SQL instance's public IP from the Cloud SQL console or using Cloud SQL APIs. No additional configuration is required.
    """
    def __init__(__self__):
        """
        The source database will allow incoming connections from the destination database's public IP. You can retrieve the Cloud SQL instance's public IP from the Cloud SQL console or using Cloud SQL APIs. No additional configuration is required.
        """
        pass


@pulumi.output_type
class StatusResponse(dict):
    """
    The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
    """
    def __init__(__self__, *,
                 code: int,
                 details: Sequence[Mapping[str, str]],
                 message: str):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param str message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence[Mapping[str, str]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class VpcPeeringConnectivityResponse(dict):
    """
    The details of the VPC where the source database is located in Google Cloud. We will use this information to set up the VPC peering connection between Cloud SQL and this VPC.
    """
    def __init__(__self__, *,
                 vpc: str):
        """
        The details of the VPC where the source database is located in Google Cloud. We will use this information to set up the VPC peering connection between Cloud SQL and this VPC.
        :param str vpc: The name of the VPC network to peer with the Cloud SQL private network.
        """
        pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter
    def vpc(self) -> str:
        """
        The name of the VPC network to peer with the Cloud SQL private network.
        """
        return pulumi.get(self, "vpc")


