# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AuditConfigArgs',
    'AuditLogConfigArgs',
    'AuthConfigArgs',
    'BindingArgs',
    'ConfigVariableArgs',
    'ExprArgs',
    'JwtClaimsArgs',
    'LockConfigArgs',
    'Oauth2ClientCredentialsArgs',
    'Oauth2JwtBearerArgs',
    'SecretArgs',
    'SshPublicKeyArgs',
    'UserPasswordArgs',
]

@pulumi.input_type
class AuditConfigArgs:
    def __init__(__self__, *,
                 audit_log_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]] audit_log_configs: The configuration for logging of each type of permission.
        :param pulumi.Input[str] service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        if audit_log_configs is not None:
            pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @audit_log_configs.setter
    def audit_log_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]):
        pulumi.set(self, "audit_log_configs", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class AuditLogConfigArgs:
    def __init__(__self__, *,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_type: Optional[pulumi.Input['AuditLogConfigLogType']] = None):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param pulumi.Input['AuditLogConfigLogType'] log_type: The log type that this config enables.
        """
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input['AuditLogConfigLogType']]:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input['AuditLogConfigLogType']]):
        pulumi.set(self, "log_type", value)


@pulumi.input_type
class AuthConfigArgs:
    def __init__(__self__, *,
                 additional_variables: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigVariableArgs']]]] = None,
                 auth_type: Optional[pulumi.Input['AuthConfigAuthType']] = None,
                 oauth2_client_credentials: Optional[pulumi.Input['Oauth2ClientCredentialsArgs']] = None,
                 oauth2_jwt_bearer: Optional[pulumi.Input['Oauth2JwtBearerArgs']] = None,
                 ssh_public_key: Optional[pulumi.Input['SshPublicKeyArgs']] = None,
                 user_password: Optional[pulumi.Input['UserPasswordArgs']] = None):
        """
        AuthConfig defines details of a authentication type.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigVariableArgs']]] additional_variables: List containing additional auth configs.
        :param pulumi.Input['AuthConfigAuthType'] auth_type: The type of authentication configured.
        :param pulumi.Input['Oauth2ClientCredentialsArgs'] oauth2_client_credentials: Oauth2ClientCredentials.
        :param pulumi.Input['Oauth2JwtBearerArgs'] oauth2_jwt_bearer: Oauth2JwtBearer.
        :param pulumi.Input['SshPublicKeyArgs'] ssh_public_key: SSH Public Key.
        :param pulumi.Input['UserPasswordArgs'] user_password: UserPassword.
        """
        if additional_variables is not None:
            pulumi.set(__self__, "additional_variables", additional_variables)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if oauth2_client_credentials is not None:
            pulumi.set(__self__, "oauth2_client_credentials", oauth2_client_credentials)
        if oauth2_jwt_bearer is not None:
            pulumi.set(__self__, "oauth2_jwt_bearer", oauth2_jwt_bearer)
        if ssh_public_key is not None:
            pulumi.set(__self__, "ssh_public_key", ssh_public_key)
        if user_password is not None:
            pulumi.set(__self__, "user_password", user_password)

    @property
    @pulumi.getter(name="additionalVariables")
    def additional_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigVariableArgs']]]]:
        """
        List containing additional auth configs.
        """
        return pulumi.get(self, "additional_variables")

    @additional_variables.setter
    def additional_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigVariableArgs']]]]):
        pulumi.set(self, "additional_variables", value)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[pulumi.Input['AuthConfigAuthType']]:
        """
        The type of authentication configured.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: Optional[pulumi.Input['AuthConfigAuthType']]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter(name="oauth2ClientCredentials")
    def oauth2_client_credentials(self) -> Optional[pulumi.Input['Oauth2ClientCredentialsArgs']]:
        """
        Oauth2ClientCredentials.
        """
        return pulumi.get(self, "oauth2_client_credentials")

    @oauth2_client_credentials.setter
    def oauth2_client_credentials(self, value: Optional[pulumi.Input['Oauth2ClientCredentialsArgs']]):
        pulumi.set(self, "oauth2_client_credentials", value)

    @property
    @pulumi.getter(name="oauth2JwtBearer")
    def oauth2_jwt_bearer(self) -> Optional[pulumi.Input['Oauth2JwtBearerArgs']]:
        """
        Oauth2JwtBearer.
        """
        return pulumi.get(self, "oauth2_jwt_bearer")

    @oauth2_jwt_bearer.setter
    def oauth2_jwt_bearer(self, value: Optional[pulumi.Input['Oauth2JwtBearerArgs']]):
        pulumi.set(self, "oauth2_jwt_bearer", value)

    @property
    @pulumi.getter(name="sshPublicKey")
    def ssh_public_key(self) -> Optional[pulumi.Input['SshPublicKeyArgs']]:
        """
        SSH Public Key.
        """
        return pulumi.get(self, "ssh_public_key")

    @ssh_public_key.setter
    def ssh_public_key(self, value: Optional[pulumi.Input['SshPublicKeyArgs']]):
        pulumi.set(self, "ssh_public_key", value)

    @property
    @pulumi.getter(name="userPassword")
    def user_password(self) -> Optional[pulumi.Input['UserPasswordArgs']]:
        """
        UserPassword.
        """
        return pulumi.get(self, "user_password")

    @user_password.setter
    def user_password(self, value: Optional[pulumi.Input['UserPasswordArgs']]):
        pulumi.set(self, "user_password", value)


@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members`, or principals, with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class ConfigVariableArgs:
    def __init__(__self__, *,
                 bool_value: Optional[pulumi.Input[bool]] = None,
                 int_value: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 secret_value: Optional[pulumi.Input['SecretArgs']] = None,
                 string_value: Optional[pulumi.Input[str]] = None):
        """
        ConfigVariable represents a configuration variable present in a Connection. or AuthConfig.
        :param pulumi.Input[bool] bool_value: Value is a bool.
        :param pulumi.Input[str] int_value: Value is an integer
        :param pulumi.Input[str] key: Key of the config variable.
        :param pulumi.Input['SecretArgs'] secret_value: Value is a secret.
        :param pulumi.Input[str] string_value: Value is a string.
        """
        if bool_value is not None:
            pulumi.set(__self__, "bool_value", bool_value)
        if int_value is not None:
            pulumi.set(__self__, "int_value", int_value)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if secret_value is not None:
            pulumi.set(__self__, "secret_value", secret_value)
        if string_value is not None:
            pulumi.set(__self__, "string_value", string_value)

    @property
    @pulumi.getter(name="boolValue")
    def bool_value(self) -> Optional[pulumi.Input[bool]]:
        """
        Value is a bool.
        """
        return pulumi.get(self, "bool_value")

    @bool_value.setter
    def bool_value(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "bool_value", value)

    @property
    @pulumi.getter(name="intValue")
    def int_value(self) -> Optional[pulumi.Input[str]]:
        """
        Value is an integer
        """
        return pulumi.get(self, "int_value")

    @int_value.setter
    def int_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "int_value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Key of the config variable.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="secretValue")
    def secret_value(self) -> Optional[pulumi.Input['SecretArgs']]:
        """
        Value is a secret.
        """
        return pulumi.get(self, "secret_value")

    @secret_value.setter
    def secret_value(self, value: Optional[pulumi.Input['SecretArgs']]):
        pulumi.set(self, "secret_value", value)

    @property
    @pulumi.getter(name="stringValue")
    def string_value(self) -> Optional[pulumi.Input[str]]:
        """
        Value is a string.
        """
        return pulumi.get(self, "string_value")

    @string_value.setter
    def string_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "string_value", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class JwtClaimsArgs:
    def __init__(__self__, *,
                 audience: Optional[pulumi.Input[str]] = None,
                 issuer: Optional[pulumi.Input[str]] = None,
                 subject: Optional[pulumi.Input[str]] = None):
        """
        JWT claims used for the jwt-bearer authorization grant.
        :param pulumi.Input[str] audience: Value for the "aud" claim.
        :param pulumi.Input[str] issuer: Value for the "iss" claim.
        :param pulumi.Input[str] subject: Value for the "sub" claim.
        """
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)

    @property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[str]]:
        """
        Value for the "aud" claim.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audience", value)

    @property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[str]]:
        """
        Value for the "iss" claim.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input[str]]:
        """
        Value for the "sub" claim.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject", value)


@pulumi.input_type
class LockConfigArgs:
    def __init__(__self__, *,
                 locked: Optional[pulumi.Input[bool]] = None,
                 reason: Optional[pulumi.Input[str]] = None):
        """
        Determines whether or no a connection is locked. If locked, a reason must be specified.
        :param pulumi.Input[bool] locked: Indicates whether or not the connection is locked.
        :param pulumi.Input[str] reason: Describes why a connection is locked.
        """
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not the connection is locked.
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "locked", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        Describes why a connection is locked.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)


@pulumi.input_type
class Oauth2ClientCredentialsArgs:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input['SecretArgs']] = None):
        """
        Parameters to support Oauth 2.0 Client Credentials Grant Authentication. See https://tools.ietf.org/html/rfc6749#section-1.3.4 for more details.
        :param pulumi.Input[str] client_id: The client identifier.
        :param pulumi.Input['SecretArgs'] client_secret: Secret version reference containing the client secret.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The client identifier.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input['SecretArgs']]:
        """
        Secret version reference containing the client secret.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input['SecretArgs']]):
        pulumi.set(self, "client_secret", value)


@pulumi.input_type
class Oauth2JwtBearerArgs:
    def __init__(__self__, *,
                 client_key: Optional[pulumi.Input['SecretArgs']] = None,
                 jwt_claims: Optional[pulumi.Input['JwtClaimsArgs']] = None):
        """
        Parameters to support JSON Web Token (JWT) Profile for Oauth 2.0 Authorization Grant based authentication. See https://tools.ietf.org/html/rfc7523 for more details.
        :param pulumi.Input['SecretArgs'] client_key: Secret version reference containing a PKCS#8 PEM-encoded private key associated with the Client Certificate. This private key will be used to sign JWTs used for the jwt-bearer authorization grant. Specified in the form as: `projects/*/secrets/*/versions/*`.
        :param pulumi.Input['JwtClaimsArgs'] jwt_claims: JwtClaims providers fields to generate the token.
        """
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if jwt_claims is not None:
            pulumi.set(__self__, "jwt_claims", jwt_claims)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input['SecretArgs']]:
        """
        Secret version reference containing a PKCS#8 PEM-encoded private key associated with the Client Certificate. This private key will be used to sign JWTs used for the jwt-bearer authorization grant. Specified in the form as: `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input['SecretArgs']]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter(name="jwtClaims")
    def jwt_claims(self) -> Optional[pulumi.Input['JwtClaimsArgs']]:
        """
        JwtClaims providers fields to generate the token.
        """
        return pulumi.get(self, "jwt_claims")

    @jwt_claims.setter
    def jwt_claims(self, value: Optional[pulumi.Input['JwtClaimsArgs']]):
        pulumi.set(self, "jwt_claims", value)


@pulumi.input_type
class SecretArgs:
    def __init__(__self__, *,
                 secret_version: Optional[pulumi.Input[str]] = None):
        """
        Secret provides a reference to entries in Secret Manager.
        :param pulumi.Input[str] secret_version: The resource name of the secret version in the format, format as: `projects/*/secrets/*/versions/*`.
        """
        if secret_version is not None:
            pulumi.set(__self__, "secret_version", secret_version)

    @property
    @pulumi.getter(name="secretVersion")
    def secret_version(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name of the secret version in the format, format as: `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "secret_version")

    @secret_version.setter
    def secret_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_version", value)


@pulumi.input_type
class SshPublicKeyArgs:
    def __init__(__self__, *,
                 cert_type: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input['SecretArgs']] = None,
                 ssh_client_cert: Optional[pulumi.Input['SecretArgs']] = None,
                 ssh_client_cert_pass: Optional[pulumi.Input['SecretArgs']] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Parameters to support Ssh public key Authentication.
        :param pulumi.Input[str] cert_type: Format of SSH Client cert.
        :param pulumi.Input['SecretArgs'] password: This is an optional field used in case client has enabled multi-factor authentication
        :param pulumi.Input['SecretArgs'] ssh_client_cert: SSH Client Cert. It should contain both public and private key.
        :param pulumi.Input['SecretArgs'] ssh_client_cert_pass: Password (passphrase) for ssh client certificate if it has one.
        :param pulumi.Input[str] username: The user account used to authenticate.
        """
        if cert_type is not None:
            pulumi.set(__self__, "cert_type", cert_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if ssh_client_cert is not None:
            pulumi.set(__self__, "ssh_client_cert", ssh_client_cert)
        if ssh_client_cert_pass is not None:
            pulumi.set(__self__, "ssh_client_cert_pass", ssh_client_cert_pass)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="certType")
    def cert_type(self) -> Optional[pulumi.Input[str]]:
        """
        Format of SSH Client cert.
        """
        return pulumi.get(self, "cert_type")

    @cert_type.setter
    def cert_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert_type", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input['SecretArgs']]:
        """
        This is an optional field used in case client has enabled multi-factor authentication
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input['SecretArgs']]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="sshClientCert")
    def ssh_client_cert(self) -> Optional[pulumi.Input['SecretArgs']]:
        """
        SSH Client Cert. It should contain both public and private key.
        """
        return pulumi.get(self, "ssh_client_cert")

    @ssh_client_cert.setter
    def ssh_client_cert(self, value: Optional[pulumi.Input['SecretArgs']]):
        pulumi.set(self, "ssh_client_cert", value)

    @property
    @pulumi.getter(name="sshClientCertPass")
    def ssh_client_cert_pass(self) -> Optional[pulumi.Input['SecretArgs']]:
        """
        Password (passphrase) for ssh client certificate if it has one.
        """
        return pulumi.get(self, "ssh_client_cert_pass")

    @ssh_client_cert_pass.setter
    def ssh_client_cert_pass(self, value: Optional[pulumi.Input['SecretArgs']]):
        pulumi.set(self, "ssh_client_cert_pass", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The user account used to authenticate.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class UserPasswordArgs:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input['SecretArgs']] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Parameters to support Username and Password Authentication.
        :param pulumi.Input['SecretArgs'] password: Secret version reference containing the password.
        :param pulumi.Input[str] username: Username.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input['SecretArgs']]:
        """
        Secret version reference containing the password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input['SecretArgs']]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


